/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingGuardian;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardCoordinator;
import akka.cluster.sharding.ShardRegion;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.ccompat.package;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t-t!B\u0013'\u0011\u0003ic!B\u0018'\u0011\u0003\u0001\u0004B\u0002$\u0002\t\u0003\u00119\u0005C\u0004\u0003J\u0005!\tEa\u0013\t\u000f\t%\u0013\u0001\"\u0011\u0003V!9!qL\u0001\u0005B\t\u0005\u0004b\u0002B3\u0003\u0011\u0005#q\r\u0004\u0005_\u0019\u0002a\b\u0003\u0005C\u000f\t\u0005\t\u0015!\u0003D\u0011\u00151u\u0001\"\u0001H\u0011\u001dIuA1A\u0005\n)Ca!U\u0004!\u0002\u0013Y\u0005bB\u0015\b\u0005\u0004%IA\u0015\u0005\u0007/\u001e\u0001\u000b\u0011B*\t\u000fa;!\u0019!C\u00053\"1!o\u0002Q\u0001\niCqa]\u0004C\u0002\u0013%\u0011\f\u0003\u0004u\u000f\u0001\u0006IA\u0017\u0005\tk\u001eA)\u0019!C\u0005m\")qo\u0002C\u0001q\"1qo\u0002C\u0001\u0003\u0007B\u0001\"!\u0015\b\t\u0003Q\u00131\u000b\u0005\u0007o\u001e!\t!a\u001e\t\r]<A\u0011AAB\u0011\u00199x\u0001\"\u0001\u0002\u000e\"1qo\u0002C\u0001\u0003GCaa^\u0004\u0005\u0002\u00055\u0006bBA[\u000f\u0011\u0005\u0011q\u0017\u0005\b\u0003k;A\u0011AAe\u0011\u001d\tyo\u0002C\u0005\u0003cDq!!.\b\t\u0003\t9\u0010C\u0004\u00026\u001e!\tAa\u0002\t\u000f\tEq\u0001\"\u0001\u0003\u0014!9!QE\u0004\u0005\u0002\t\u001d\u0002b\u0002B\u0017\u000f\u0011\u0005!q\u0006\u0005\b\u0005g9A\u0011\u0001B\u001b\u0011\u001d\u0011Yd\u0002C\u0001\u0005{\tqb\u00117vgR,'o\u00155be\u0012Lgn\u001a\u0006\u0003O!\n\u0001b\u001d5be\u0012Lgn\u001a\u0006\u0003S)\nqa\u00197vgR,'OC\u0001,\u0003\u0011\t7n[1\u0004\u0001A\u0011a&A\u0007\u0002M\ty1\t\\;ti\u0016\u00148\u000b[1sI&twmE\u0003\u0002c]\u0012\t\u0005\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0004qmjT\"A\u001d\u000b\u0005iR\u0013!B1di>\u0014\u0018B\u0001\u001f:\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u00059:1cA\u00042\u007fA\u0011\u0001\bQ\u0005\u0003\u0003f\u0012\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0002\rML8\u000f^3n!\tAD)\u0003\u0002Fs\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"\"!\u0010%\t\u000b\tK\u0001\u0019A\"\u0002\u00071|w-F\u0001L!\tau*D\u0001N\u0015\tq%&A\u0003fm\u0016tG/\u0003\u0002Q\u001b\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002*\u0012a\u0015\t\u0003)Vk\u0011\u0001K\u0005\u0003-\"\u0012qa\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003\u001d\u0011XmZ5p]N,\u0012A\u0017\t\u00057\n$w.D\u0001]\u0015\tif,\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u00181\u0002\tU$\u0018\u000e\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019GLA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA44\u001b\u0005A'BA5-\u0003\u0019a$o\\8u}%\u00111nM\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002lgA\u0011\u0001\b]\u0005\u0003cf\u0012\u0001\"Q2u_J\u0014VMZ\u0001\te\u0016<\u0017n\u001c8tA\u00059\u0001O]8yS\u0016\u001c\u0018\u0001\u00039s_bLWm\u001d\u0011\u0002\u0011\u001d,\u0018M\u001d3jC:,\u0012a\\\u0001\u0006gR\f'\u000f\u001e\u000b\u000e_f\\\u0018\u0011AA\u0006\u0003;\t9#!\u000f\t\u000bi\u001c\u0002\u0019\u00013\u0002\u0011QL\b/\u001a(b[\u0016DQ\u0001`\nA\u0002u\f1\"\u001a8uSRL\bK]8qgB\u0011\u0001H`\u0005\u0003\u007ff\u0012Q\u0001\u0015:paNDq!a\u0001\u0014\u0001\u0004\t)!\u0001\u0005tKR$\u0018N\\4t!\rq\u0013qA\u0005\u0004\u0003\u00131#aF\"mkN$XM]*iCJ$\u0017N\\4TKR$\u0018N\\4t\u0011\u001d\tia\u0005a\u0001\u0003\u001f\tq\"\u001a=ue\u0006\u001cG/\u00128uSRL\u0018\n\u001a\t\u0005\u0003#\t9BD\u0002/\u0003'I1!!\u0006'\u0003-\u0019\u0006.\u0019:e%\u0016<\u0017n\u001c8\n\t\u0005e\u00111\u0004\u0002\u0010\u000bb$(/Y2u\u000b:$\u0018\u000e^=JI*\u0019\u0011Q\u0003\u0014\t\u000f\u0005}1\u00031\u0001\u0002\"\u0005qQ\r\u001f;sC\u000e$8\u000b[1sI&#\u0007\u0003BA\t\u0003GIA!!\n\u0002\u001c\tqQ\t\u001f;sC\u000e$8\u000b[1sI&#\u0007bBA\u0015'\u0001\u0007\u00111F\u0001\u0013C2dwnY1uS>t7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0002.\u0005Mbb\u0001\u0018\u00020%\u0019\u0011\u0011\u0007\u0014\u0002!MC\u0017M\u001d3D_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\u001b\u0003o\u0011qc\u00155be\u0012\fE\u000e\\8dCRLwN\\*ue\u0006$XmZ=\u000b\u0007\u0005Eb\u0005C\u0004\u0002<M\u0001\r!!\u0010\u0002%!\fg\u000eZ(gMN#x\u000e]'fgN\fw-\u001a\t\u0004e\u0005}\u0012bAA!g\t\u0019\u0011I\\=\u0015\u001b=\f)%a\u0012\u0002J\u0005-\u0013QJA(\u0011\u0015QH\u00031\u0001e\u0011\u0015aH\u00031\u0001~\u0011\u001d\ti\u0001\u0006a\u0001\u0003\u001fAq!a\b\u0015\u0001\u0004\t\t\u0003C\u0004\u0002*Q\u0001\r!a\u000b\t\u000f\u0005mB\u00031\u0001\u0002>\u0005i\u0011N\u001c;fe:\fGn\u0015;beR$rb\\A+\u0003/\ny&!\u0019\u0002d\u0005\u0015\u0014q\r\u0005\u0006uV\u0001\r\u0001\u001a\u0005\u0007yV\u0001\r!!\u0017\u0011\u000bI\nY\u0006Z?\n\u0007\u0005u3GA\u0005Gk:\u001cG/[8oc!9\u00111A\u000bA\u0002\u0005\u0015\u0001bBA\u0007+\u0001\u0007\u0011q\u0002\u0005\b\u0003?)\u0002\u0019AA\u0011\u0011\u001d\tI#\u0006a\u0001\u0003WAq!a\u000f\u0016\u0001\u0004\ti\u0004K\u0002\u0016\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cR\u0013AC1o]>$\u0018\r^5p]&!\u0011QOA8\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0015\u0017=\fI(a\u001f\u0002~\u0005}\u0014\u0011\u0011\u0005\u0006uZ\u0001\r\u0001\u001a\u0005\u0006yZ\u0001\r! \u0005\b\u0003\u00071\u0002\u0019AA\u0003\u0011\u001d\tiA\u0006a\u0001\u0003\u001fAq!a\b\u0017\u0001\u0004\t\t\u0003F\u0005p\u0003\u000b\u000b9)!#\u0002\f\")!p\u0006a\u0001I\")Ap\u0006a\u0001{\"9\u0011QB\fA\u0002\u0005=\u0001bBA\u0010/\u0001\u0007\u0011\u0011\u0005\u000b\u000e_\u0006=\u0015\u0011SAJ\u0003+\u000by*!)\t\u000biD\u0002\u0019\u00013\t\u000bqD\u0002\u0019A?\t\u000f\u0005\r\u0001\u00041\u0001\u0002\u0006!9\u0011q\u0013\rA\u0002\u0005e\u0015\u0001E7fgN\fw-Z#yiJ\f7\r^8s!\u0011\t\t\"a'\n\t\u0005u\u00151\u0004\u0002\u0011\u001b\u0016\u001c8/Y4f\u000bb$(/Y2u_JDq!!\u000b\u0019\u0001\u0004\tY\u0003C\u0004\u0002<a\u0001\r!!\u0010\u0015\u0013=\f)+a*\u0002*\u0006-\u0006\"\u0002>\u001a\u0001\u0004!\u0007\"\u0002?\u001a\u0001\u0004i\bbBA\u00023\u0001\u0007\u0011Q\u0001\u0005\b\u0003/K\u0002\u0019AAM)\u001dy\u0017qVAY\u0003gCQA\u001f\u000eA\u0002\u0011DQ\u0001 \u000eA\u0002uDq!a&\u001b\u0001\u0004\tI*\u0001\u0006ti\u0006\u0014H\u000f\u0015:pqf$\u0012b\\A]\u0003w\u000b)-a2\t\u000bi\\\u0002\u0019\u00013\t\u000f\u0005u6\u00041\u0001\u0002@\u0006!!o\u001c7f!\u0011\u0011\u0014\u0011\u00193\n\u0007\u0005\r7G\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u001bY\u0002\u0019AA\b\u0011\u001d\tyb\u0007a\u0001\u0003C!2b\\Af\u0003\u001b\fy-a;\u0002n\")!\u0010\ba\u0001I\"9\u0011Q\u0018\u000fA\u0002\u0005}\u0006bBAi9\u0001\u0007\u00111[\u0001\u000bI\u0006$\u0018mQ3oi\u0016\u0014\b#\u0002\u001a\u0002B\u0006U\u0007\u0003BAl\u0003KtA!!7\u0002b:!\u00111\\Ap\u001d\r9\u0017Q\\\u0005\u0002W%\u0011\u0011FK\u0005\u0004\u0003GD\u0013aD\"mkN$XM]*fiRLgnZ:\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u000b\t\u0006$\u0018mQ3oi\u0016\u0014(bAArQ!9\u0011Q\u0002\u000fA\u0002\u0005=\u0001bBA\u00109\u0001\u0007\u0011\u0011E\u0001\naJ|\u00070\u001f(b[\u0016$R\u0001ZAz\u0003kDQA_\u000fA\u0002\u0011Dq!!5\u001e\u0001\u0004\t\u0019\u000eF\u0004p\u0003s\fYP!\u0002\t\u000bit\u0002\u0019\u00013\t\u000f\u0005uf\u00041\u0001\u0002~B)\u0011q B\u0001I6\ta,C\u0002\u0003\u0004y\u0013\u0001b\u00149uS>t\u0017\r\u001c\u0005\b\u0003/s\u0002\u0019AAM)%y'\u0011\u0002B\u0006\u0005\u001b\u0011y\u0001C\u0003{?\u0001\u0007A\rC\u0004\u0002>~\u0001\r!!@\t\u000f\u0005Ew\u00041\u0001\u0002~\"9\u0011qS\u0010A\u0002\u0005e\u0015AD:iCJ$G+\u001f9f\u001d\u0006lWm]\u000b\u0003\u0005+\u0001RAa\u0006\u0003\"\u0011l!A!\u0007\u000b\t\tm!QD\u0001\nS6lW\u000f^1cY\u0016T1Aa\b4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0011IBA\u0002TKR\f\u0011cZ3u'\"\f'\u000f\u001a+za\u0016t\u0015-\\3t+\t\u0011I\u0003E\u0003\u0002\u0000\n-B-C\u0002\u0003$y\u000b1b\u001d5be\u0012\u0014VmZ5p]R\u0019qN!\r\t\u000bi\u0014\u0003\u0019\u00013\u0002!MD\u0017M\u001d3SK\u001eLwN\u001c)s_bLH#B8\u00038\te\u0002\"\u0002>$\u0001\u0004!\u0007bBAiG\u0001\u0007\u0011Q[\u0001\u001fI\u00164\u0017-\u001e7u'\"\f'\u000fZ!mY>\u001c\u0017\r^5p]N#(/\u0019;fOf$B!a\u000b\u0003@!9\u00111\u0001\u0013A\u0002\u0005\u0015\u0001c\u0001\u001d\u0003D%\u0019!QI\u001d\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u00035\n1aZ3u)\ri$Q\n\u0005\u0007\u0005\u000e\u0001\rAa\u0014\u0011\u0007a\u0012\t&C\u0002\u0003Te\u00121\"Q2u_J\u001c\u0016p\u001d;f[R\u0019QHa\u0016\t\r\t#\u0001\u0019\u0001B-!\rA$1L\u0005\u0004\u0005;J$AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018A\u00027p_.,\b\u000f\u0006\u0002\u0003d9\u0011a\u0006A\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R\u0019QH!\u001b\t\u000b\t3\u0001\u0019A\"")
public class ClusterSharding
implements Extension {
    private ActorRef guardian;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private final ConcurrentHashMap<String, ActorRef> proxies;
    private volatile boolean bitmap$0;

    public static ClusterSharding createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterSharding$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterSharding$ lookup() {
        return ClusterSharding$.MODULE$.lookup();
    }

    public static ClusterSharding get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterSharding get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private ConcurrentHashMap<String, ActorRef> regions() {
        return this.regions;
    }

    private ConcurrentHashMap<String, ActorRef> proxies() {
        return this.proxies;
    }

    private ActorRef guardian$lzycompute() {
        ClusterSharding clusterSharding = this;
        synchronized (clusterSharding) {
            if (!this.bitmap$0) {
                String guardianName = this.system.settings().config().getString("akka.cluster.sharding.guardian-name");
                String string = this.system.settings().config().getString("akka.cluster.sharding.use-dispatcher");
                String string2 = "".equals(string) ? "akka.actor.default-dispatcher" : string;
                String dispatcher = string2;
                this.guardian = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                this.bitmap$0 = true;
            }
        }
        return this.guardian;
    }

    private ActorRef guardian() {
        return !this.bitmap$0 ? this.guardian$lzycompute() : this.guardian;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$1 -> entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    @InternalApi
    public ActorRef internalStart(String typeName, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        ActorRef actorRef;
        if (settings.shouldHostShard(this.cluster())) {
            ActorRef actorRef2;
            ActorRef actorRef3 = this.regions().get(typeName);
            if (actorRef3 == null) {
                ActorRef shardRegion;
                ActorRef x$3;
                Timeout x$2;
                ClusterShardingGuardian.Start x$1;
                Timeout timeout = this.system.settings().CreationTimeout();
                ClusterShardingGuardian.Start startMsg = new ClusterShardingGuardian.Start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
                ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
                Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = startMsg), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
                if (!(object instanceof ClusterShardingGuardian.Started)) {
                    throw new MatchError(object);
                }
                ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
                ActorRef actorRef4 = shardRegion = started.shardRegion();
                ActorRef shardRegion2 = actorRef4;
                this.regions().put(typeName, shardRegion2);
                actorRef2 = shardRegion2;
            } else {
                actorRef2 = actorRef3;
            }
            actorRef = actorRef2;
        } else {
            this.log().debug("Starting Shard Region Proxy [{}] (no actors will be hosted on this node)...", (Object)typeName);
            actorRef = this.startProxy(typeName, settings.role(), (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
        }
        return actorRef;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$2 -> entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.messageExtractor$1.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$1.entityId(A1), this.messageExtractor$1.entityMessage(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = this.messageExtractor$1.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$1 = messageExtractor$1;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, (Object)PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ShardRegion.MessageExtractor messageExtractor) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.startProxy(typeName, role, (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef startProxy(String typeName, Option<String> role, Option<String> dataCenter, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef actorRef;
        ActorRef actorRef2 = this.proxies().get(this.proxyName(typeName, dataCenter));
        if (actorRef2 == null) {
            ActorRef shardRegion;
            ActorRef x$3;
            Timeout x$2;
            ClusterShardingGuardian.StartProxy x$1;
            Timeout timeout = this.system.settings().CreationTimeout();
            ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
            ClusterShardingGuardian.StartProxy startMsg = new ClusterShardingGuardian.StartProxy(typeName, dataCenter, settings, extractEntityId, extractShardId);
            ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
            Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = startMsg), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
            if (!(object instanceof ClusterShardingGuardian.Started)) {
                throw new MatchError(object);
            }
            ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
            ActorRef actorRef3 = shardRegion = started.shardRegion();
            ActorRef shardRegion2 = actorRef3;
            this.proxies().put(this.proxyName(typeName, dataCenter), shardRegion2);
            actorRef = shardRegion2;
        } else {
            actorRef = actorRef2;
        }
        return actorRef;
    }

    private String proxyName(String typeName, Option<String> dataCenter) {
        String string;
        Option<String> option = dataCenter;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(5).append(typeName).append("Proxy").toString();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String t = (String)some.value();
            string = new StringBuilder(6).append(typeName).append("Proxy").append("-").append(t).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, role, Optional.empty(), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, Optional<String> dataCenter, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (Option<String>)Option$.MODULE$.apply(dataCenter.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.messageExtractor$2.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$2.entityId(A1), this.messageExtractor$2.entityMessage(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = this.messageExtractor$2.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$2 = messageExtractor$2;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg));
    }

    public scala.collection.immutable.Set<String> shardTypeNames() {
        return ((TraversableOnce)package.JavaConverters$.MODULE$.asScalaSetConverter(this.regions().keySet()).asScala()).toSet();
    }

    public Set<String> getShardTypeNames() {
        return this.regions().keySet();
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef;
        ActorRef actorRef2 = this.regions().get(typeName);
        if (actorRef2 == null) {
            ActorRef actorRef3;
            ActorRef actorRef4 = this.proxies().get(this.proxyName(typeName, (Option<String>)None$.MODULE$));
            if (actorRef4 == null) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
            }
            actorRef = actorRef3 = actorRef4;
        } else {
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public ActorRef shardRegionProxy(String typeName, String dataCenter) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, (Option<String>)new Some((Object)dataCenter)));
        if (actorRef == null) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
        }
        ActorRef actorRef2 = actorRef;
        return actorRef2;
    }

    public ShardCoordinator.ShardAllocationStrategy defaultShardAllocationStrategy(ClusterShardingSettings settings) {
        int threshold = settings.tuningParameters().leastShardAllocationRebalanceThreshold();
        int maxSimultaneousRebalance = settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance();
        return new ShardCoordinator.LeastShardAllocationStrategy(threshold, maxSimultaneousRebalance);
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.regions = new ConcurrentHashMap();
        this.proxies = new ConcurrentHashMap();
    }
}

