/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ms!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\u0002C\u0016\u0002\u0005\u0004%\t!\u0001\u0017\t\rU\n\u0001\u0015!\u0003.\u0011\u00151\u0014\u0001\"\u00018\u0011\u001d\t)%\u0001C\u0001\u0003\u000f2A!\t\u000b\u0001s!A!h\u0002B\u0001B\u0003%1\bC\u0003*\u000f\u0011\u0005\u0011\n\u0003\u0004L\u000f\u0001&I\u0001\u0014\u0005\u00073\u001e!\t\u0001\u0006.\t\u000b\t<A\u0011A2\t\rQ<\u0001\u0015\"\u0003v\u0011\u001d\tYa\u0002C\u0001\u0003\u001bAq!a\u0006\b\t\u0003\tI\u0002C\u0005\u0002$\u001d\t\n\u0011\"\u0001\u0002&!9\u0011qC\u0004\u0005\u0002\u0005m\u0002\u0002CA \u000f\u0001&I!!\u0011\u0002\u001fM#(/Z1nKJ4\u0015m\u0019;pefT!!\u0006\f\u0002\u0005%|'BA\f\u0019\u0003!\u0001\u0018mY6bO\u0016\u0014(BA\r\u001b\u0003!AH\u000eZ3qY>L(BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001!\t\u0001\u0013!D\u0001\u0015\u0005=\u0019FO]3b[\u0016\u0014h)Y2u_JL8CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aH\u0001\u0007Y><w-\u001a:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003I\n\u0001b\u001a:jujdW\rZ\u0005\u0003i=\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0010I\u00164\u0017-\u001e7u\u001b\u0006\u0004\b/\u001b8hgR\t\u0001\b\u0005\u0002!\u000fM\u0011qaI\u0001\u0010CJ\u001c\u0007.\u001b<f\u001b\u0006\u0004\b/\u001b8hgB!Ah\u0011$G\u001d\ti\u0014\t\u0005\u0002?K5\tqH\u0003\u0002A=\u00051AH]8pizJ!AQ\u0013\u0002\rA\u0013X\rZ3g\u0013\t!UIA\u0002NCBT!AQ\u0013\u0011\u0005q:\u0015B\u0001%F\u0005\u0019\u0019FO]5oOR\u0011\u0001H\u0013\u0005\u0006u%\u0001\raO\u0001\u0018O\u0016$\u0018I]2iSZ,WI\u001c;ssN#(/Z1nKJ$\"!\u0014)\u0011\u0005\u0001r\u0015BA(\u0015\u0005!\u0019FO]3b[\u0016\u0014\b\"B)\u000b\u0001\u0004\u0011\u0016\u0001\u00024jY\u0016\u0004\"aU,\u000e\u0003QS!!F+\u000b\u0003Y\u000bAA[1wC&\u0011\u0001\f\u0016\u0002\u0005\r&dW-A\u000fhKR\f%o\u00195jm\u0016,e\u000e\u001e:z'R\u0014X-Y7TiJ,\u0017-\\3s)\ri5\f\u0019\u0005\u00069.\u0001\r!X\u0001\u0003SN\u0004\"a\u00150\n\u0005}#&aC%oaV$8\u000b\u001e:fC6DQ!Y\u0006A\u0002\u0019\u000bAA\\1nK\u00061r-\u001a;Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002eeB\u0011Q\r]\u0007\u0002M*\u0011q\r[\u0001\nCJ\u001c\u0007.\u001b<feNT!!\u001b6\u0002\u0011\r|W\u000e\u001d:fgNT!a\u001b7\u0002\u000f\r|W.\\8og*\u0011QN\\\u0001\u0007CB\f7\r[3\u000b\u0003=\f1a\u001c:h\u0013\t\thMA\nBe\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003t\u0019\u0001\u0007!+\u0001\u0004uCJ<W\r^\u0001\u001aO\u0016$H+\u0019:Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002wyv\u0004\"a\u001e>\u000e\u0003aT!!\u001f4\u0002\u0007Q\f'/\u0003\u0002|q\n1B+\u0019:Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003t\u001b\u0001\u0007!\u000bC\u0003\u007f\u001b\u0001\u0007q0\u0001\u0006d_6\u0004(/Z:t_J\u0004r\u0001JA\u0001\u0003\u000b\t)!C\u0002\u0002\u0004\u0015\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007M\u000b9!C\u0002\u0002\nQ\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0003[1t\u0003J\u001c\u0007.\u001b<f\u000bb$XM\\:j_:$B!a\u0004\u0002\u0016A\u0019A%!\u0005\n\u0007\u0005MQEA\u0004C_>dW-\u00198\t\u000b\u0005t\u0001\u0019\u0001$\u0002\u0011M$(/Z1nKJ$r!TA\u000e\u0003;\ty\u0002C\u0003]\u001f\u0001\u0007Q\fC\u0003b\u001f\u0001\u0007a\tC\u0005\u0002\"=\u0001\n\u00111\u0001\u0002\u0010\u0005I\u0011n]!sG\"Lg/Z\u0001\u0013gR\u0014X-Y7fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002()\"\u0011qBA\u0015W\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001bK\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0012q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GcA'\u0002>!)\u0011+\u0005a\u0001%\u0006qq-\u001a;Be\u000eD\u0017N^3UsB,Gc\u0001$\u0002D!)\u0011M\u0005a\u0001\r\u0006Iam\u001c:D_:4\u0017n\u001a\u000b\u0004q\u0005%\u0003bBA&\r\u0001\u0007\u0011QJ\u0001\u0007G>tg-[4\u0011\t\u0005=\u0013qK\u0007\u0003\u0003#RA!a\u0013\u0002T)\u0019\u0011Q\u000b\u000f\u0002\u0011QL\b/Z:bM\u0016LA!!\u0017\u0002R\t11i\u001c8gS\u001e\u0004")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : (isArchive ? new ZipArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is)) : new FileStreamStreamer(is, name));
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    public boolean streamer$default$3() {
        return false;
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings) {
        this.archiveMappings = archiveMappings;
    }
}

