/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bufferlo
implements CharSequence {
    private LinkedList buffers = new LinkedList();
    private BufferloOutputStream out = new BufferloOutputStream();
    private BufferloInputStream in = new BufferloInputStream();

    public void clear() {
        this.buffers.clear();
    }

    public int readFromChannel(ReadableByteChannel source) throws IOException {
        int totalRead = 0;
        while (true) {
            ByteBuffer writeInto = this.getWriteIntoBuffer();
            int bytesRead = source.read(writeInto);
            this.doneWriting();
            if (bytesRead < 0 && totalRead == 0) {
                return bytesRead;
            }
            if (bytesRead <= 0) {
                return totalRead;
            }
            totalRead += bytesRead;
        }
    }

    public int readFromChannel(ReadableByteChannel source, int bytesRequested) throws IOException {
        int totalRead;
        int bytesRead;
        for (totalRead = 0; totalRead < bytesRequested; totalRead += bytesRead) {
            ByteBuffer writeInto = this.getWriteIntoBuffer();
            int bytesRemaining = bytesRequested - totalRead;
            int maxBytesToRead = Math.min(bytesRemaining, writeInto.remaining());
            writeInto.limit(writeInto.position() + maxBytesToRead);
            bytesRead = source.read(writeInto);
            this.doneWriting();
            if (bytesRead < 0 && totalRead == 0) {
                return bytesRead;
            }
            if (bytesRead > 0) continue;
            return totalRead;
        }
        return totalRead;
    }

    public long writeToChannel(GatheringByteChannel target) throws IOException {
        if (this.length() == 0) {
            return 0L;
        }
        ByteBuffer[] toWrite = new ByteBuffer[this.buffers.size()];
        for (int b = 0; b < this.buffers.size(); ++b) {
            ByteBuffer buffer = (ByteBuffer)this.buffers.get(b);
            buffer.flip();
            toWrite[b] = buffer;
        }
        long totalWritten = target.write(toWrite);
        ListIterator<ByteBuffer> b = this.buffers.listIterator();
        while (b.hasNext()) {
            ByteBuffer buffer = (ByteBuffer)b.next();
            if (!buffer.hasRemaining()) {
                b.remove();
                continue;
            }
            if (buffer.position() > 0) {
                int bytesLeftToRead = buffer.remaining();
                buffer.limit(buffer.capacity());
                ByteBuffer noneRead = buffer.slice();
                noneRead.position(bytesLeftToRead);
                noneRead.limit(bytesLeftToRead);
                b.set(noneRead);
                continue;
            }
            buffer.position(buffer.limit());
        }
        return totalWritten;
    }

    public long writeToChannel(GatheringByteChannel target, SelectionKey selectionKey) throws IOException {
        if (!selectionKey.isValid()) {
            throw new IOException("Key cancelled");
        }
        long totalWritten = this.writeToChannel(target);
        if (this.length() > 0) {
            selectionKey.interestOps(selectionKey.interestOps() | 4);
        } else {
            selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        }
        return totalWritten;
    }

    public byte[] consumeBytes(int bytes) {
        try {
            int read;
            byte[] result = new byte[bytes];
            for (int totalRead = 0; totalRead < bytes; totalRead += read) {
                read = this.getInputStream().read(result, totalRead, bytes - totalRead);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public BufferloInputStream getInputStream() {
        return this.in;
    }

    public BufferloOutputStream getOutputStream() {
        return this.out;
    }

    public Bufferlo duplicate() {
        Bufferlo result = new Bufferlo();
        for (int i = 0; i < this.buffers.size(); ++i) {
            ByteBuffer buffer = (ByteBuffer)this.buffers.get(i);
            result.buffers.add(this.removeTrailingSpace(buffer));
        }
        return result;
    }

    public Bufferlo consume(int bytes) {
        assert (bytes >= 0 && bytes <= this.length());
        Bufferlo result = this.duplicate();
        result.limit(bytes);
        this.skip(bytes);
        return result;
    }

    public void write(String data) {
        this.append(Bufferlo.stringToBytes(data));
    }

    public static final ByteBuffer stringToBytes(String in) {
        try {
            return ByteBuffer.wrap(in.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Bufferlo append(Bufferlo data) {
        this.buffers.addAll(data.buffers);
        data.buffers.clear();
        return this;
    }

    public Bufferlo append(ByteBuffer data) {
        ByteBuffer myCopy = data.slice();
        myCopy.position(myCopy.limit());
        this.buffers.add(myCopy);
        data.position(data.limit());
        return this;
    }

    public void limit(int bytes) {
        int bytesLeft = bytes;
        ListIterator b = this.buffers.listIterator();
        while (b.hasNext()) {
            ByteBuffer current = (ByteBuffer)b.next();
            if (bytesLeft <= 0) {
                b.remove();
            } else if (current.capacity() >= bytesLeft) {
                current.position(bytesLeft);
                current.limit(bytesLeft);
            }
            bytesLeft -= current.capacity();
        }
    }

    public void skip(int bytes) {
        assert (bytes >= 0 && bytes <= this.length());
        int bytesLeft = bytes;
        ListIterator<ByteBuffer> b = this.buffers.listIterator();
        while (b.hasNext()) {
            ByteBuffer current = (ByteBuffer)b.next();
            if (bytesLeft >= current.limit()) {
                bytesLeft -= current.limit();
                b.remove();
                continue;
            }
            current.position(bytesLeft);
            ByteBuffer smaller = current.slice();
            smaller.position(smaller.limit());
            b.set(smaller);
            break;
        }
    }

    private ByteBuffer removeTrailingSpace(ByteBuffer buffer) {
        ByteBuffer clone = buffer.duplicate();
        clone.position(0);
        ByteBuffer noTrailingSpace = clone.slice();
        noTrailingSpace.position(noTrailingSpace.limit());
        return noTrailingSpace;
    }

    private ByteBuffer getReadFromBuffer() {
        if (this.buffers.isEmpty()) {
            return null;
        }
        ByteBuffer readFrom = (ByteBuffer)this.buffers.getFirst();
        readFrom.flip();
        return readFrom;
    }

    private void doneReading() {
        ByteBuffer readFrom = (ByteBuffer)this.buffers.getFirst();
        if (!readFrom.hasRemaining()) {
            this.buffers.removeFirst();
        } else {
            int bytesLeftToRead = readFrom.remaining();
            readFrom.limit(readFrom.capacity());
            ByteBuffer noneRead = readFrom.slice();
            noneRead.position(bytesLeftToRead);
            noneRead.limit(bytesLeftToRead);
            this.buffers.set(0, noneRead);
        }
    }

    private ByteBuffer getWriteIntoBuffer() {
        ByteBuffer last;
        if (!this.buffers.isEmpty() && (last = (ByteBuffer)this.buffers.getLast()).position() < last.capacity()) {
            last.limit(last.capacity());
            return last;
        }
        ByteBuffer writeInto = this.getNewBuffer();
        this.buffers.addLast(writeInto);
        return writeInto;
    }

    private void doneWriting() {
        ByteBuffer writeInto = (ByteBuffer)this.buffers.getLast();
        writeInto.limit(writeInto.position());
    }

    @Override
    public int length() {
        int bytesAvailable = 0;
        for (ByteBuffer buffer : this.buffers) {
            bytesAvailable += buffer.position();
        }
        return bytesAvailable;
    }

    @Override
    public char charAt(int index) {
        int bytesLeft = index;
        for (ByteBuffer buffer : this.buffers) {
            if (bytesLeft < buffer.position()) {
                return (char)buffer.get(bytesLeft);
            }
            bytesLeft -= buffer.position();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        Bufferlo clone = this.duplicate();
        clone.skip(start);
        clone.limit(end - start);
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int c = 0; c < this.length(); ++c) {
            result.append(this.charAt(c));
        }
        return result.toString();
    }

    public String toDebugString() {
        return "BUFFERLO {" + this.buffers + "}";
    }

    public int indexOf(String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(this);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    public int consume(String regex) throws ParseException {
        Matcher matcher = Pattern.compile(regex).matcher(this);
        if (!matcher.find()) {
            throw new ParseException(regex + " is not in current buffer", 0);
        }
        if (matcher.start() != 0) {
            throw new ParseException(regex + " is not a prefix of " + this, 0);
        }
        this.skip(matcher.end());
        return matcher.end();
    }

    public String readUntil(String regex) throws ParseException {
        return this.readUntil(regex, true);
    }

    public String readUntil(String regex, boolean consume) throws ParseException {
        Matcher matcher = Pattern.compile(regex).matcher(this);
        if (!matcher.find()) {
            throw new ParseException(regex + " is not in current buffer", 0);
        }
        String result = ((Object)this.subSequence(0, matcher.start())).toString();
        if (consume) {
            this.skip(matcher.end());
        }
        return result;
    }

    private ByteBuffer getNewBuffer() {
        int BUFFER_SIZE = 8196;
        return ByteBuffer.allocateDirect(BUFFER_SIZE);
    }

    class BufferloInputStream
    extends InputStream {
        BufferloInputStream() {
        }

        @Override
        public int read() {
            ByteBuffer readBuffer = Bufferlo.this.getReadFromBuffer();
            if (readBuffer == null) {
                return -1;
            }
            int result = 0xFF & readBuffer.get();
            Bufferlo.this.doneReading();
            return result;
        }
    }

    class BufferloOutputStream
    extends OutputStream {
        BufferloOutputStream() {
        }

        @Override
        public void write(int b) {
            ByteBuffer writeBuffer = Bufferlo.this.getWriteIntoBuffer();
            writeBuffer.put((byte)b);
            Bufferlo.this.doneWriting();
        }
    }
}

