/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u0012%\u0005\"b\u0003\u0002\u0003\u001e\u0001\u0005+\u0007I\u0011\u0001\u001f\t\u0011\u0001\u0003!\u0011#Q\u0001\nuB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005c\u0001\tE\t\u0015!\u0003J\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015)\u0003\u0001\"\u0001k\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u001d\u0011\b!!A\u0005\u0002MDq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003S\u0001\u0011\u0011!C!\u0003WA\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00131\u000e\u0005\n\u0003[\u0002\u0011\u0011!C!\u0003_:\u0001\"a\u001d%\u0011\u0003A\u0013Q\u000f\u0004\bG\u0011B\t\u0001KA<\u0011\u0019\u0019w\u0003\"\u0001\u0002z!I\u00111P\fC\u0002\u0013\u0015\u0011Q\u0010\u0005\t\u0003\u0007;\u0002\u0015!\u0004\u0002\u0000!I\u0011QQ\fC\u0002\u0013\u0015\u0011q\u0011\u0005\t\u0003C;\u0002\u0015!\u0004\u0002\n\"9\u00111U\f\u0005\u0002\u0005\u0015\u0006\u0002CAY/\u0001\u0006I!a-\t\u000f\u0005Uv\u0003\"\u0001\u00028\"I\u0011\u0011Y\f\u0002\u0002\u0013\u0005\u00151\u0019\u0005\n\u0003+<\u0012\u0011!CA\u0003/D\u0011\"a=\u0018\u0003\u0003%I!!>\u0003!\r{W\u000e\u001d:fgNLwN\u001c+bE2,'BA\u0013'\u0003!\u0019w.\u001c9sKN\u001c(BA\u0014)\u0003\u0019\t'\u000f^3ss*\u0011\u0011FK\u0001\u0007e\u0016lw\u000e^3\u000b\u0003-\nA!Y6lCV\u0011QFV\n\u0005\u00019\"t\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003_UJ!A\u000e\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011q\u0006O\u0005\u0003sA\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011b\u001c:jO&tW+\u001b3\u0004\u0001U\tQ\b\u0005\u00020}%\u0011q\b\r\u0002\u0005\u0019>tw-\u0001\u0006pe&<\u0017N\\+jI\u0002\nqA^3sg&|g.F\u0001D!\tyC)\u0003\u0002Fa\t!!)\u001f;f\u0003!1XM]:j_:\u0004\u0013A\u00033jGRLwN\\1ssV\t\u0011\n\u0005\u0003K#R{fBA&P!\ta\u0005'D\u0001N\u0015\tq5(\u0001\u0004=e>|GOP\u0005\u0003!B\na\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\ri\u0015\r\u001d\u0006\u0003!B\u0002\"!\u0016,\r\u0001\u0011)q\u000b\u0001b\u00011\n\tA+\u0005\u0002Z9B\u0011qFW\u0005\u00037B\u0012qAT8uQ&tw\r\u0005\u00020;&\u0011a\f\r\u0002\u0004\u0003:L\bCA\u0018a\u0013\t\t\u0007GA\u0002J]R\f1\u0002Z5di&|g.\u0019:zA\u00051A(\u001b8jiz\"B!Z4iSB\u0019a\r\u0001+\u000e\u0003\u0011BQAO\u0004A\u0002uBQ!Q\u0004A\u0002\rCQaR\u0004A\u0002%#\"aX6\t\u000b1D\u0001\u0019\u0001+\u0002\u000bY\fG.^3\u0002\r%tg/\u001a:u+\u0005y\u0007c\u00014q)&\u0011\u0011\u000f\n\u0002\u0013\t\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8UC\ndW-\u0001\u0003d_BLXC\u0001;x)\u0011)\b0\u001f>\u0011\u0007\u0019\u0004a\u000f\u0005\u0002Vo\u0012)qK\u0003b\u00011\"9!H\u0003I\u0001\u0002\u0004i\u0004bB!\u000b!\u0003\u0005\ra\u0011\u0005\b\u000f*\u0001\n\u00111\u0001|!\u0011Q\u0015K^0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0019a0a\u0005\u0016\u0003}T3!PA\u0001W\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0007a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0011q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B,\f\u0005\u0004A\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u00033\ti\"\u0006\u0002\u0002\u001c)\u001a1)!\u0001\u0005\u000b]c!\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u00111EA\u0014+\t\t)CK\u0002J\u0003\u0003!QaV\u0007C\u0002a\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tA\u0001\\1oO*\u0011\u0011qG\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002<\u0005E\"AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001`\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001XA#\u0011!\t9\u0005EA\u0001\u0002\u0004y\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002NA)\u0011qJA+96\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0002\u0014AC2pY2,7\r^5p]&!\u0011qKA)\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00131\r\t\u0004_\u0005}\u0013bAA1a\t9!i\\8mK\u0006t\u0007\u0002CA$%\u0005\u0005\t\u0019\u0001/\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012aX\u0001\ti>\u001cFO]5oOR\u0011\u0011QF\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u0013\u0011\u000f\u0005\t\u0003\u000f*\u0012\u0011!a\u00019\u0006\u00012i\\7qe\u0016\u001c8/[8o)\u0006\u0014G.\u001a\t\u0003M^\u00192a\u0006\u00188)\t\t)(A\bO_R\u001cu.\u001c9sKN\u001cX\rZ%e+\t\tyh\u0004\u0002\u0002\u0002v\tq@\u0001\tO_R\u001cu.\u001c9sKN\u001cX\rZ%eA\u0005\t2i\\7qCJ,')\u001f\u001aoIZ\u000bG.^3\u0016\u0005\u0005%\u0005CBAF\u0003#\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRA\u001b\u0003\u0011)H/\u001b7\n\t\u0005M\u0015Q\u0012\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bCB\u0018\u0002\u0018\u0006mu,C\u0002\u0002\u001aB\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0018\u0003;KA!a(\u00022\t1qJ\u00196fGR\f!cQ8na\u0006\u0014XMQ=3]\u00124\u0016\r\\;fA\u0005\t2m\\7qCJ,')\u001f\u001aoIZ\u000bG.^3\u0016\t\u0005\u001d\u0016qV\u000b\u0003\u0003S\u0003b!a#\u0002\u0012\u0006-\u0006CB\u0018\u0002\u0018\u00065v\fE\u0002V\u0003_#QaV\u000fC\u0002a\u000baaX3naRL\bc\u00014\u00019\u0006)Q-\u001c9usV!\u0011\u0011XA`+\t\tY\f\u0005\u0003g\u0001\u0005u\u0006cA+\u0002@\u0012)qk\bb\u00011\u0006)\u0011\r\u001d9msV!\u0011QYAf)!\t9-!4\u0002P\u0006E\u0007\u0003\u00024\u0001\u0003\u0013\u00042!VAf\t\u00159\u0006E1\u0001Y\u0011\u0015Q\u0004\u00051\u0001>\u0011\u0015\t\u0005\u00051\u0001D\u0011\u00199\u0005\u00051\u0001\u0002TB)!*UAe?\u00069QO\\1qa2LX\u0003BAm\u0003W$B!a7\u0002nB)q&!8\u0002b&\u0019\u0011q\u001c\u0019\u0003\r=\u0003H/[8o!\u001dy\u00131]\u001fD\u0003OL1!!:1\u0005\u0019!V\u000f\u001d7fgA)!*UAu?B\u0019Q+a;\u0005\u000b]\u000b#\u0019\u0001-\t\u0013\u0005=\u0018%!AA\u0002\u0005E\u0018a\u0001=%aA!a\rAAu\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0005")
public final class CompressionTable<T>
implements Product,
scala.Serializable {
    private final long originUid;
    private final byte version;
    private final Map<T, Object> dictionary;

    public static <T> Option<Tuple3<Object, Object, Map<T, Object>>> unapply(CompressionTable<T> compressionTable) {
        return CompressionTable$.MODULE$.unapply(compressionTable);
    }

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    public Map<T, Object> dictionary() {
        return this.dictionary;
    }

    public int compress(T value) {
        int n;
        Option option = this.dictionary().get(value);
        if (option instanceof Some) {
            int id;
            Some some = (Some)option;
            n = id = BoxesRunTime.unboxToInt((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            n = -1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public DecompressionTable<T> invert() {
        DecompressionTable decompressionTable;
        if (this.dictionary().isEmpty()) {
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            long x$1 = this.originUid();
            byte x$2 = this.version();
            Object x$3 = qual$1.copy$default$3();
            decompressionTable = qual$1.copy(x$1, x$2, x$3);
        } else {
            int i;
            Integer expectedGaplessSum = this.dictionary().size() * (this.dictionary().size() + 1) / 2;
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$)) == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Compression table should start allocating from 0, yet lowest allocated id was ").append(this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$)).toString());
            Predef$.MODULE$.require(BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.dictionary().values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.dictionary().size())), (Object)expectedGaplessSum), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: ").append(this.dictionary()).toString());
            Tuple2[] tups = new Tuple2[this.dictionary().size()];
            Object[] ts = new Object[this.dictionary().size()];
            Iterator mit = this.dictionary().iterator();
            for (i = 0; i < tups.length; ++i) {
                tups[i] = (Tuple2)mit.next();
            }
            Arrays.sort((Object[])tups, CompressionTable$.MODULE$.compareBy2ndValue());
            for (i = 0; i < tups.length; ++i) {
                ScalaRunTime$.MODULE$.array_update((Object)ts, i, tups[i]._1());
            }
            decompressionTable = new DecompressionTable(this.originUid(), this.version(), ts);
        }
        return decompressionTable;
    }

    public <T> CompressionTable<T> copy(long originUid, byte version, Map<T, Object> dictionary) {
        return new CompressionTable<T>(originUid, version, dictionary);
    }

    public <T> long copy$default$1() {
        return this.originUid();
    }

    public <T> byte copy$default$2() {
        return this.version();
    }

    public <T> Map<T, Object> copy$default$3() {
        return this.dictionary();
    }

    public String productPrefix() {
        return "CompressionTable";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.originUid());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToByte((byte)this.version());
                break;
            }
            case 2: {
                object = this.dictionary();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompressionTable;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.originUid()));
        n = Statics.mix((int)n, (int)this.version());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.dictionary()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompressionTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompressionTable compressionTable = (CompressionTable)x$1;
        if (this.originUid() != compressionTable.originUid()) return false;
        if (this.version() != compressionTable.version()) return false;
        Map<T, Object> map = this.dictionary();
        Map<T, Object> map2 = compressionTable.dictionary();
        if (map != null) {
            if (!map.equals(map2)) return false;
            return true;
        }
        if (map2 == null) return true;
        return false;
    }

    public CompressionTable(long originUid, byte version, Map<T, Object> dictionary) {
        this.originUid = originUid;
        this.version = version;
        this.dictionary = dictionary;
        Product.$init$((Product)this);
    }
}

