/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

abstract class AbstractWebClientReactiveOAuth2AccessTokenResponseClient<T extends AbstractOAuth2AuthorizationGrantRequest>
implements ReactiveOAuth2AccessTokenResponseClient<T> {
    private WebClient webClient = WebClient.builder().build();

    AbstractWebClientReactiveOAuth2AccessTokenResponseClient() {
    }

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(T grantRequest) {
        Assert.notNull(grantRequest, (String)"grantRequest cannot be null");
        return Mono.defer(() -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.clientRegistration(grantRequest).getProviderDetails().getTokenUri(), new Object[0])).headers(headers -> this.populateTokenRequestHeaders(grantRequest, (HttpHeaders)headers))).body(this.createTokenRequestBody(grantRequest)).exchange().flatMap(response -> this.readTokenResponse(grantRequest, (ClientResponse)response)));
    }

    abstract ClientRegistration clientRegistration(T var1);

    private void populateTokenRequestHeaders(T grantRequest, HttpHeaders headers) {
        ClientRegistration clientRegistration = this.clientRegistration(grantRequest);
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
        }
    }

    private BodyInserters.FormInserter<String> createTokenRequestBody(T grantRequest) {
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getGrantType().getValue());
        return this.populateTokenRequestBody(grantRequest, (BodyInserters.FormInserter<String>)body);
    }

    BodyInserters.FormInserter<String> populateTokenRequestBody(T grantRequest, BodyInserters.FormInserter<String> body) {
        Set<String> scopes;
        ClientRegistration clientRegistration = this.clientRegistration(grantRequest);
        if (!ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        if (!CollectionUtils.isEmpty(scopes = this.scopes(grantRequest))) {
            body.with("scope", (Object)StringUtils.collectionToDelimitedString(scopes, (String)" "));
        }
        return body;
    }

    abstract Set<String> scopes(T var1);

    Set<String> defaultScopes(T grantRequest) {
        return this.scopes(grantRequest);
    }

    private Mono<OAuth2AccessTokenResponse> readTokenResponse(T grantRequest, ClientResponse response) {
        return ((Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse())).map(tokenResponse -> this.populateTokenResponse(grantRequest, (OAuth2AccessTokenResponse)tokenResponse));
    }

    OAuth2AccessTokenResponse populateTokenResponse(T grantRequest, OAuth2AccessTokenResponse tokenResponse) {
        if (CollectionUtils.isEmpty((Collection)tokenResponse.getAccessToken().getScopes())) {
            Set<String> defaultScopes = this.defaultScopes(grantRequest);
            tokenResponse = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)tokenResponse).scopes(defaultScopes).build();
        }
        return tokenResponse;
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }
}

