/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.vti.DeferModification;

class InsertVTIResultSet
extends DMLVTIResultSet {
    private PreparedStatement ps;
    private VTIResultSet vtiRS;
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public InsertVTIResultSet(NoPutResultSet noPutResultSet, NoPutResultSet noPutResultSet2, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
        this.vtiRS = (VTIResultSet)noPutResultSet2;
    }

    @Override
    protected void openCore() throws StandardException {
        Object object;
        if (this.ps == null) {
            this.ps = (PreparedStatement)this.vtiRS.getVTIConstructor().invoke(this.activation);
        }
        if (this.ps instanceof DeferModification) {
            try {
                ((DeferModification)((Object)this.ps)).modificationNotify(1, this.constants.deferred);
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        ExecRow execRow = this.getNextRowCore(this.sourceResultSet);
        try {
            this.rs = this.ps.executeQuery();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.firstExecute && this.constants.deferred) {
            object = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, (Properties)object, this.resultDescription);
        }
        while (execRow != null) {
            if (this.constants.deferred) {
                this.rowHolder.insert(execRow);
            } else {
                this.insertIntoVTI(this.rs, execRow);
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                execRow = null;
                continue;
            }
            execRow = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            object = this.rowHolder.getResultSet();
            try {
                object.open();
                while ((execRow = object.getNextRow()) != null) {
                    this.insertIntoVTI(this.rs, execRow);
                }
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void insertIntoVTI(ResultSet resultSet, ExecRow execRow) throws StandardException {
        try {
            resultSet.moveToInsertRow();
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i];
                try {
                    if (dataValueDescriptor.isNull()) {
                        resultSet.updateNull(i + 1);
                        continue;
                    }
                    dataValueDescriptor.setInto(resultSet, i + 1);
                    continue;
                }
                catch (Throwable throwable) {
                    resultSet.updateObject(i + 1, dataValueDescriptor.getObject());
                }
            }
            resultSet.insertRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            this.rs = null;
        }
        if (!this.vtiRS.isReuseablePs() && this.ps != null) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        super.cleanUp();
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    @Override
    public void finish() throws StandardException {
        if (this.ps != null && !this.vtiRS.isReuseablePs()) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        super.finish();
    }
}

