/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.views;

import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.v1.views.TeamMemberView;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class TeamView {
    private String id;
    private String teamName;
    private List<TeamMemberView> members = new ArrayList<TeamMemberView>();
    private List<String> permissions = new ArrayList<String>();
    private boolean systemTeam;

    @PublicApiMember
    public TeamView() {
    }

    public TeamView(Team team, UserInfoResolver userInfoResolver) {
        this.id = team.getId();
        this.teamName = team.getTeamName();
        this.members.addAll(team.getMembers().stream().map(t -> new TeamMemberView((String)t, TeamMemberView.MemberType.PRINCIPAL, userInfoResolver)).collect(Collectors.toList()));
        this.members.addAll(team.getRoles().stream().map(role -> new TeamMemberView((String)role, TeamMemberView.MemberType.ROLE, userInfoResolver)).collect(Collectors.toList()));
        this.permissions = team.getPermissions().stream().filter(p -> !XLReleasePermissions.DUMMY.getPermissionName().equals(p)).collect(Collectors.toList());
        this.systemTeam = team.isSystemTeam();
    }

    public TeamView(Team team, UserInfoResolver userInfoResolver, RoleService roleService) {
        this.id = team.getId();
        this.teamName = team.getTeamName();
        this.members.addAll(team.getMembers().stream().map(t -> new TeamMemberView((String)t, TeamMemberView.MemberType.PRINCIPAL, userInfoResolver)).collect(Collectors.toList()));
        this.members.addAll(team.getRoles().stream().map(role -> new TeamMemberView((String)role, TeamMemberView.MemberType.ROLE, userInfoResolver, roleService)).collect(Collectors.toList()));
        this.permissions = team.getPermissions().stream().filter(p -> !XLReleasePermissions.DUMMY.getPermissionName().equals(p)).collect(Collectors.toList());
        this.systemTeam = team.isSystemTeam();
    }

    @PublicApiMember
    public String getId() {
        return this.id;
    }

    @PublicApiMember
    public void setId(String id) {
        this.id = id;
    }

    @PublicApiMember
    public String getTeamName() {
        return this.teamName;
    }

    @PublicApiMember
    public List<TeamMemberView> getMembers() {
        return this.members;
    }

    @PublicApiMember
    public List<String> getPermissions() {
        return this.permissions;
    }

    public boolean isSystemTeam() {
        return this.systemTeam;
    }

    @PublicApiMember
    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @PublicApiMember
    public void setMembers(List<TeamMemberView> members) {
        this.members = members;
    }

    @PublicApiMember
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public Team toTeam() {
        List principals = this.members.stream().filter(member -> member.getType() == TeamMemberView.MemberType.PRINCIPAL).map(TeamMemberView::getName).collect(Collectors.toList());
        List roles = this.members.stream().filter(member -> member.getType() == TeamMemberView.MemberType.ROLE).map(TeamMemberView::getName).collect(Collectors.toList());
        return TeamBuilder.newTeam().withId(this.id).withTeamName(this.teamName).withMembers(principals).withRoles(roles).withPermissions(this.permissions).build();
    }
}

