/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;

public final class OAuth2TokenValidatorResult {
    static final OAuth2TokenValidatorResult NO_ERRORS = new OAuth2TokenValidatorResult(Collections.emptyList());
    private final Collection<OAuth2Error> errors;

    private OAuth2TokenValidatorResult(Collection<OAuth2Error> errors) {
        Assert.notNull(errors, (String)"errors cannot be null");
        this.errors = new ArrayList<OAuth2Error>(errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Collection<OAuth2Error> getErrors() {
        return this.errors;
    }

    public static OAuth2TokenValidatorResult success() {
        return NO_ERRORS;
    }

    public static OAuth2TokenValidatorResult failure(OAuth2Error ... errors) {
        return OAuth2TokenValidatorResult.failure(Arrays.asList(errors));
    }

    public static OAuth2TokenValidatorResult failure(Collection<OAuth2Error> errors) {
        if (errors.isEmpty()) {
            return NO_ERRORS;
        }
        return new OAuth2TokenValidatorResult(errors);
    }
}

