/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.rendering;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import akka.http.impl.engine.rendering.HttpRequestRendererFactory;
import akka.http.impl.engine.rendering.RenderSupport$;
import akka.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import akka.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import akka.http.impl.engine.rendering.RequestRenderingContext;
import akka.http.impl.util.ByteStringRendering;
import akka.http.impl.util.Renderer$;
import akka.http.impl.util.package$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import akka.http.scaladsl.model.UriRendering$;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.CustomHeader;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding$;
import akka.http.scaladsl.model.headers.User$minusAgent;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rc!\u0002\u001f>\u0001\r;\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\ti\u0002\u0001C\u0001\u0005g9\u0001\"!\u0006>\u0011\u0003\u0019\u0015q\u0003\u0004\byuB\taQA\r\u0011\u0019A\u0017\u0002\"\u0001\u0002\u001c!9\u0011QD\u0005\u0005\u0002\u0005}a!CA\u001a\u0013A\u0005\u0019\u0013EA\u001b\u0011\u001d\t9\u0004\u0004D\u0001\u0003s9qAa\f\n\u0011\u0003\t\u0019EB\u0004\u00024%A\t!a\u0010\t\r!|A\u0011AA!\r\u0019\t9e\u0004!\u0002J!Q\u0011\u0011L\t\u0003\u0016\u0004%\t!a\u0017\t\u0013\u0005u\u0013C!E!\u0002\u0013A\bB\u00025\u0012\t\u0003\ty\u0006C\u0004\u00028E!\t!!\u000f\t\u0013\u0005\u001d\u0014#!A\u0005\u0002\u0005%\u0004\"CA7#E\u0005I\u0011AA8\u0011%\t))EA\u0001\n\u0003\n9\tC\u0005\u0002\u001aF\t\t\u0011\"\u0001\u0002\u001c\"I\u0011QT\t\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003K\u000b\u0012\u0011!C!\u0003OC\u0011\"!.\u0012\u0003\u0003%\t!a.\t\u0013\u0005\u0005\u0017#!A\u0005B\u0005\r\u0007\"CAc#\u0005\u0005I\u0011IAd\u0011%\tI-EA\u0001\n\u0003\nYmB\u0005\u0002P>\t\t\u0011#\u0001\u0002R\u001aI\u0011qI\b\u0002\u0002#\u0005\u00111\u001b\u0005\u0007Q\u0006\"\t!!9\t\u0013\u0005\u0015\u0017%!A\u0005F\u0005\u001d\u0007\"CArC\u0005\u0005I\u0011QAs\u0011%\tI/IA\u0001\n\u0003\u000bY\u000fC\u0005\u0002t\u0006\n\t\u0011\"\u0003\u0002v\u001a1\u0011QH\bA\u0005'A!\"a\u000e(\u0005+\u0007I\u0011AA\u001d\u0011%\u0011)b\nB\tB\u0003%\u0011\u000f\u0003\u0004iO\u0011\u0005!q\u0003\u0005\n\u0003O:\u0013\u0011!C\u0001\u00057A\u0011\"!\u001c(#\u0003%\tAa\b\t\u0013\u0005\u0015u%!A\u0005B\u0005\u001d\u0005\"CAMO\u0005\u0005I\u0011AAN\u0011%\tijJA\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0002&\u001e\n\t\u0011\"\u0011\u0002(\"I\u0011QW\u0014\u0002\u0002\u0013\u0005!q\u0005\u0005\n\u0003\u0003<\u0013\u0011!C!\u0003\u0007D\u0011\"!2(\u0003\u0003%\t%a2\t\u0013\u0005%w%!A\u0005B\t-r!CA\u007f\u001f\u0005\u0005\t\u0012AA\u0000\r%\tidDA\u0001\u0012\u0003\u0011\t\u0001\u0003\u0004im\u0011\u0005!q\u0001\u0005\n\u0003\u000b4\u0014\u0011!C#\u0003\u000fD\u0011\"a97\u0003\u0003%\tI!\u0003\t\u0013\u0005%h'!A\u0005\u0002\n5\u0001\"CAzm\u0005\u0005I\u0011BA{\u0005iAE\u000f\u001e9SKF,Xm\u001d;SK:$WM]3s\r\u0006\u001cGo\u001c:z\u0015\tqt(A\u0005sK:$WM]5oO*\u0011\u0001)Q\u0001\u0007K:<\u0017N\\3\u000b\u0005\t\u001b\u0015\u0001B5na2T!\u0001R#\u0002\t!$H\u000f\u001d\u0006\u0002\r\u0006!\u0011m[6b'\t\u0001\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VMZ\u0001\u0010kN,'/Q4f]RDU-\u00193fe\u000e\u0001\u0001cA%R'&\u0011!K\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Q[V\"A+\u000b\u0005Y;\u0016a\u00025fC\u0012,'o\u001d\u0006\u00031f\u000bQ!\\8eK2T!AW\"\u0002\u0011M\u001c\u0017\r\\1eg2L!\u0001X+\u0003\u001fU\u001bXM\u001d\u0013nS:,8/Q4f]R\fQC]3rk\u0016\u001cH\u000fS3bI\u0016\u00148+\u001b>f\u0011&tG\u000f\u0005\u0002J?&\u0011\u0001M\u0013\u0002\u0004\u0013:$\u0018a\u00017pOB\u00111MZ\u0007\u0002I*\u0011Q-R\u0001\u0006KZ,g\u000e^\u0005\u0003O\u0012\u0014a\u0002T8hO&tw-\u00113baR,'/\u0001\u0004=S:LGO\u0010\u000b\u0005U2lg\u000e\u0005\u0002l\u00015\tQ\bC\u0003O\t\u0001\u0007\u0001\u000bC\u0003^\t\u0001\u0007a\fC\u0003b\t\u0001\u0007!-\u0001\bsK:$WM\u001d+p'>,(oY3\u0015\u0007E\f\u0019\u0001\u0005\u0003smbtX\"A:\u000b\u0005i#(BA;F\u0003\u0019\u0019HO]3b[&\u0011qo\u001d\u0002\u0007'>,(oY3\u0011\u0005edX\"\u0001>\u000b\u0005m,\u0015\u0001B;uS2L!! >\u0003\u0015\tKH/Z*ue&tw\r\u0005\u0002J\u007f&\u0019\u0011\u0011\u0001&\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0006\u0015\u0001\r!a\u0002\u0002\u0007\r$\b\u0010E\u0002l\u0003\u0013I1!a\u0003>\u0005]\u0011V-];fgR\u0014VM\u001c3fe&twmQ8oi\u0016DH/\u0001\u0004sK:$WM\u001d\u000b\u0005\u0003#\u0011\t\u0004E\u0002\u0002\u00141q!a\u001b\u0005\u00025!#H\u000f\u001d*fcV,7\u000f\u001e*f]\u0012,'/\u001a:GC\u000e$xN]=\u0011\u0005-L1CA\u0005I)\t\t9\"\u0001\u0007sK:$WM]*ue&\u001cG\u000fF\u0004y\u0003C\t\u0019#!\r\t\u000f\u0005\u00151\u00021\u0001\u0002\b!9\u0011QE\u0006A\u0002\u0005\u001d\u0012\u0001C:fiRLgnZ:\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ1!!\nZ\u0013\u0011\ty#a\u000b\u00031\rc\u0017.\u001a8u\u0007>tg.Z2uS>t7+\u001a;uS:<7\u000fC\u0003b\u0017\u0001\u0007!M\u0001\fSKF,Xm\u001d;SK:$WM]5oO>+H\u000f];u'\ta\u0001*\u0001\u0006csR,7\u000b\u001e:fC6,\u0012!]\u0015\u0004\u0019\u001d\n\"\u0001C*ue\u0016\fW.\u001a3\u0014\u0005=AECAA\"!\r\t)eD\u0007\u0002\u0013\t11\u000b\u001e:jGR\u001c\u0002\"\u0005%\u0002L\u00055\u00131\u000b\t\u0004\u0003\u000bb\u0001cA%\u0002P%\u0019\u0011\u0011\u000b&\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0011*!\u0016\n\u0007\u0005]#J\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003csR,7/F\u0001y\u0003\u0019\u0011\u0017\u0010^3tAQ!\u0011\u0011MA3!\r\t\u0019'E\u0007\u0002\u001f!1\u0011\u0011\f\u000bA\u0002a\fAaY8qsR!\u0011\u0011MA6\u0011!\tIF\u0006I\u0001\u0002\u0004A\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cR3\u0001_A:W\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u0013Ut7\r[3dW\u0016$'bAA@\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015\u0001\u00027b]\u001eT!!a%\u0002\t)\fg/Y\u0005\u0005\u0003/\u000biI\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002=\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001@\u0002\"\"A\u00111\u0015\u000e\u0002\u0002\u0003\u0007a,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0003R!a+\u00022zl!!!,\u000b\u0007\u0005=&*\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002.\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI,a0\u0011\u0007%\u000bY,C\u0002\u0002>*\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002$r\t\t\u00111\u0001\u007f\u0003!A\u0017m\u001d5D_\u0012,G#\u00010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!#\u0002\r\u0015\fX/\u00197t)\u0011\tI,!4\t\u0011\u0005\rv$!AA\u0002y\faa\u0015;sS\u000e$\bcAA2CM)\u0011%!6\u0002TA9\u0011q[Aoq\u0006\u0005TBAAm\u0015\r\tYNS\u0001\beVtG/[7f\u0013\u0011\ty.!7\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002R\u0006)\u0011\r\u001d9msR!\u0011\u0011MAt\u0011\u0019\tI\u0006\na\u0001q\u00069QO\\1qa2LH\u0003BAw\u0003_\u00042!S)y\u0011%\t\t0JA\u0001\u0002\u0004\t\t'A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001f\t\u0005\u0003\u0017\u000bI0\u0003\u0003\u0002|\u00065%AB(cU\u0016\u001cG/\u0001\u0005TiJ,\u0017-\\3e!\r\t\u0019GN\n\u0006m\t\r\u00111\u000b\t\b\u0003/\fi.\u001dB\u0003!\r\t\u0019g\n\u000b\u0003\u0003\u007f$BA!\u0002\u0003\f!1\u0011qG\u001dA\u0002E$BAa\u0004\u0003\u0012A\u0019\u0011*U9\t\u0013\u0005E((!AA\u0002\t\u00151\u0003C\u0014I\u0003\u0017\ni%a\u0015\u0002\u0017\tLH/Z*ue\u0016\fW\u000e\t\u000b\u0005\u0005\u000b\u0011I\u0002\u0003\u0004\u00028)\u0002\r!\u001d\u000b\u0005\u0005\u000b\u0011i\u0002\u0003\u0005\u00028-\u0002\n\u00111\u0001r+\t\u0011\tCK\u0002r\u0003g\"2A B\u0013\u0011!\t\u0019kLA\u0001\u0002\u0004qF\u0003BA]\u0005SA\u0001\"a)2\u0003\u0003\u0005\rA \u000b\u0005\u0003s\u0013i\u0003\u0003\u0005\u0002$R\n\t\u00111\u0001\u007f\u0003Y\u0011V-];fgR\u0014VM\u001c3fe&twmT;uaV$\bbBA\u0003\r\u0001\u0007\u0011q\u0001\u000b\u0004q\nU\u0002bBA\u0003\u000f\u0001\u0007\u0011q\u0001\u0015\u0004\u0001\te\u0002\u0003\u0002B\u001e\u0005\u007fi!A!\u0010\u000b\u0007\u0005}T)\u0003\u0003\u0003B\tu\"aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint);
        HttpRequestRendererFactory.renderRequestLine$1(r, ctx);
        this.renderHeaders$1(ctx.request().headers().toList(), HttpRequestRendererFactory.renderHeaders$default$2$1(), HttpRequestRendererFactory.renderHeaders$default$3$1(), HttpRequestRendererFactory.renderHeaders$default$4$1(), ctx, r);
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        ByteString bytes;
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (!(requestRenderingOutput instanceof RequestRenderingOutput.Strict)) {
            if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Request entity was not Strict but ").append(ctx.request().entity().getClass().getSimpleName()).toString());
            }
            throw new MatchError((Object)requestRenderingOutput);
        }
        RequestRenderingOutput.Strict strict = (RequestRenderingOutput.Strict)requestRenderingOutput;
        ByteString byteString = bytes = strict.bytes();
        return byteString;
    }

    public static final /* synthetic */ boolean $anonfun$render$1(ByteStringRendering r$1, HttpHeader x0$1) {
        boolean bl;
        HttpHeader httpHeader = x0$1;
        if (httpHeader instanceof Raw$minusRequest$minusURI) {
            Raw$minusRequest$minusURI raw$minusRequest$minusURI = (Raw$minusRequest$minusURI)httpHeader;
            String rawUri = raw$minusRequest$minusURI.uri();
            r$1.$tilde$tilde(rawUri);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void renderRequestLine$1(ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(' ');
        boolean rawRequestUriRendered = ctx$1.request().headers().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestRendererFactory.$anonfun$render$1(r$1, x0$1)));
        Object object = !rawRequestUriRendered ? UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), package$.MODULE$.UTF8()) : BoxedUnit.UNIT;
        r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
    }

    private static final ByteStringRendering render$1(HttpHeader h, ByteStringRendering r$1) {
        return (ByteStringRendering)r$1.$tilde$tilde(h, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
    }

    private final void renderHeaders$1(List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        BoxedUnit boxedUnit;
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            ByteStringRendering byteStringRendering;
            .colon.colon colon2 = (.colon.colon)list;
            HttpHeader head = (HttpHeader)colon2.head();
            List tail = colon2.tl$access$1();
            boolean bl = false;
            RawHeader rawHeader = null;
            HttpHeader httpHeader = head;
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                Option<Transfer$minusEncoding> option = transfer$minusEncoding.withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, head, RenderSupport$.MODULE$.suppressionWarning$default$3());
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Transfer$minusEncoding te = (Transfer$minusEncoding)some.value();
                    HttpRequestRendererFactory.render$1(ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() ? te.withChunked() : te, r$1);
                    transferEncodingSeen = true;
                    remaining = tail;
                    continue;
                }
                throw new MatchError(option);
            }
            if (httpHeader instanceof Host) {
                Host host = (Host)httpHeader;
                HttpRequestRendererFactory.render$1(host, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)httpHeader;
                HttpRequestRendererFactory.render$1(user$minusAgent, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Raw$minusRequest$minusURI) {
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)httpHeader;
                Object object = customHeader.renderInRequests() ? HttpRequestRendererFactory.render$1(customHeader, r$1) : BoxedUnit.UNIT;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof RawHeader) {
                bl = true;
                rawHeader = (RawHeader)httpHeader;
                if (rawHeader.is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding")) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, rawHeader, "illegal RawHeader");
                    remaining = tail;
                    continue;
                }
            }
            if (bl && rawHeader.is("user-agent")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (bl && rawHeader.is("host")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader.renderInRequests()) {
                byteStringRendering = HttpRequestRendererFactory.render$1(httpHeader, r$1);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", (Object)httpHeader);
                byteStringRendering = BoxedUnit.UNIT;
            }
            remaining = tail;
        }
        if (Nil$.MODULE$.equals(list)) {
            Object object = !hostHeaderSeen ? r$1.$tilde$tilde(ctx$1.hostHeader(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer()) : BoxedUnit.UNIT;
            Object object2 = !userAgentSeen && this.userAgentHeader.isDefined() ? r$1.$tilde$tilde(this.userAgentHeader.get(), Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer()) : BoxedUnit.UNIT;
            if (ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$1.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)list);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final ByteStringRendering renderContentLength$1(long contentLength, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        ByteStringRendering byteStringRendering;
        block2: {
            block3: {
                if (!ctx$1.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$1.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance != null ? !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$) : requestEntityAcceptance$Expected$ != null) break block2;
            }
            byteStringRendering = (ByteStringRendering)r$1.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(contentLength).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            return byteStringRendering;
        }
        byteStringRendering = r$1;
        return byteStringRendering;
    }

    private static final RequestRenderingOutput renderStreamed$1(Source body, ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        Source source;
        Source headerPart = Source$.MODULE$.single((Object)r$1.get());
        Option<Future<NotUsed>> option = ctx$1.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Future future = (Future)some.value();
            Source barrier = (Source)Source$.MODULE$.fromFuture(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus((Graph)body).recoverWithRetries(-1, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = HttpResponseParser$OneHundredContinueError$.MODULE$.equals(A1) ? Source$.MODULE$.empty() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = HttpResponseParser$OneHundredContinueError$.MODULE$.equals(throwable);
                    return bl;
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return new RequestRenderingOutput.Streamed((Source<ByteString, Object>)stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        RequestRenderingOutput requestRenderingOutput;
        RequestEntity requestEntity = ctx$1.request().entity();
        if (requestEntity.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(0L, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = new RequestRenderingOutput.Strict(r$1.get());
        } else if (requestEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
            ByteString data = strict.data();
            HttpRequestRendererFactory.renderContentLength$1(data.length(), ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = ctx$1.sendEntityTrigger().isDefined() ? HttpRequestRendererFactory.renderStreamed$1(Source$.MODULE$.single((Object)data), r$1, ctx$1) : new RequestRenderingOutput.Strict(r$1.get().$plus$plus(data));
        } else if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)requestEntity;
            long contentLength = default_.contentLength();
            Source<ByteString, Object> data = default_.data();
            HttpRequestRendererFactory.renderContentLength$1(contentLength, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = HttpRequestRendererFactory.renderStreamed$1(data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)), r$1, ctx$1);
        } else if (requestEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)requestEntity;
            Source<HttpEntity.ChunkStreamPart, Object> chunks = chunked.chunks();
            r$1.$tilde$tilde(RenderSupport$.MODULE$.CrLf(), Renderer$.MODULE$.renderableRenderer());
            requestRenderingOutput = HttpRequestRendererFactory.renderStreamed$1(chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()), r$1, ctx$1);
        } else {
            throw new MatchError((Object)requestEntity);
        }
        return requestRenderingOutput;
    }

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public static interface RequestRenderingOutput {
        public Source<ByteString, Object> byteStream();
    }
}

