/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultPasswordTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PasswordOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient = new DefaultPasswordTokenResponseClient();
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        OAuth2AccessTokenResponse tokenResponse;
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (!AuthorizationGrantType.PASSWORD.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            return null;
        }
        String username = (String)context.getAttribute(OAuth2AuthorizationContext.USERNAME_ATTRIBUTE_NAME);
        String password = (String)context.getAttribute(OAuth2AuthorizationContext.PASSWORD_ATTRIBUTE_NAME);
        if (!StringUtils.hasText((String)username) || !StringUtils.hasText((String)password)) {
            return null;
        }
        if (authorizedClient != null && !this.hasTokenExpired((AbstractOAuth2Token)authorizedClient.getAccessToken())) {
            return null;
        }
        if (authorizedClient != null && this.hasTokenExpired((AbstractOAuth2Token)authorizedClient.getAccessToken()) && authorizedClient.getRefreshToken() != null) {
            return null;
        }
        OAuth2PasswordGrantRequest passwordGrantRequest = new OAuth2PasswordGrantRequest(clientRegistration, username, password);
        try {
            tokenResponse = this.accessTokenResponseClient.getTokenResponse(passwordGrantRequest);
        }
        catch (OAuth2AuthorizationException ex) {
            throw new ClientAuthorizationException(ex.getError(), clientRegistration.getRegistrationId(), ex);
        }
        return new OAuth2AuthorizedClient(clientRegistration, context.getPrincipal().getName(), tokenResponse.getAccessToken(), tokenResponse.getRefreshToken());
    }

    private boolean hasTokenExpired(AbstractOAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

