/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScriptLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(ScriptLifeCycle.class);
    private Map<String, State> executionStates = Maps.newHashMap();

    public synchronized void tryAborting(String executionId) {
        if (this.executionStates.containsKey(executionId)) {
            this.executionStates.get(executionId).tryInterrupting();
        }
    }

    public synchronized void preregister(String executionId) {
        logger.trace("PREREGISTER {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((!this.executionStates.containsKey(executionId) ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be unregistered", (Object)executionId);
        this.executionStates.put(executionId, State.preregistered());
    }

    public synchronized void register(String executionId) {
        logger.trace("REGISTER {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((!this.executionStates.containsKey(executionId) || this.executionStates.get(executionId).scriptState == ScriptState.PREREGISTERED ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be unregistered", (Object)executionId);
        State preregistered = this.executionStates.get(executionId);
        if (preregistered != null) {
            preregistered.register(executionId);
        } else {
            this.executionStates.put(executionId, new State());
        }
    }

    public synchronized void start(String executionId) throws InterruptedException {
        logger.trace("START {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (String)"Expected executionId: '%s' to be registered", (Object)executionId);
        this.executionStates.get(executionId).begin(executionId);
    }

    public synchronized void reset(String executionId) throws InterruptedException {
        logger.trace("RESET {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (String)"Expected executionId: '%s' to be registered", (Object)executionId);
        ScriptState scriptState = this.executionStates.get(executionId).scriptState;
        Preconditions.checkState((scriptState == ScriptState.REGISTERED || scriptState == ScriptState.DONE ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be registered or done", (Object)executionId);
        this.executionStates.get(executionId).reset(executionId);
    }

    public synchronized void end(String executionId) {
        logger.trace("END {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (String)"Expected executionId: '%s' to be registered", (Object)executionId);
        this.executionStates.get(executionId).end(executionId);
    }

    public synchronized void unregister(String executionId) {
        logger.trace("UNREGISTER {}", (Object)executionId);
        Preconditions.checkState((executionId != null ? 1 : 0) != 0, (Object)"executionId cannot be null");
        Preconditions.checkState((boolean)this.executionStates.containsKey(executionId), (String)"Expected executionId: '%s' to be registered", (Object)executionId);
        ScriptState scriptState = this.executionStates.get(executionId).scriptState;
        Preconditions.checkState((scriptState == ScriptState.REGISTERED || scriptState == ScriptState.DONE ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be registered or done", (Object)executionId);
        this.executionStates.remove(executionId);
    }

    public synchronized boolean isRegistered(String executionId) {
        return this.executionStates.containsKey(executionId);
    }

    static class State {
        private ScriptState scriptState = ScriptState.REGISTERED;
        private boolean interruptionRequested = false;
        private Thread thread = null;

        State() {
        }

        public static State preregistered() {
            State state = new State();
            state.scriptState = ScriptState.PREREGISTERED;
            return state;
        }

        public void tryInterrupting() {
            this.interruptionRequested = true;
            if (this.scriptState == ScriptState.STARTED) {
                this.thread.interrupt();
            }
        }

        public void register(String executionId) {
            Preconditions.checkState((this.scriptState == ScriptState.PREREGISTERED ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be preregistered", (Object)executionId);
            this.scriptState = ScriptState.REGISTERED;
        }

        public void begin(String executionId) throws InterruptedException {
            Preconditions.checkState((this.scriptState == ScriptState.REGISTERED ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be registered", (Object)executionId);
            if (this.interruptionRequested) {
                this.interruptionRequested = false;
                throw new InterruptedException();
            }
            this.scriptState = ScriptState.STARTED;
            this.thread = Thread.currentThread();
        }

        public void reset(String executionId) throws InterruptedException {
            Preconditions.checkState((this.scriptState == ScriptState.DONE ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be done", (Object)executionId);
            if (this.interruptionRequested) {
                this.interruptionRequested = false;
                throw new InterruptedException();
            }
            this.scriptState = ScriptState.REGISTERED;
        }

        public void end(String executionId) {
            Preconditions.checkState((this.scriptState == ScriptState.STARTED ? 1 : 0) != 0, (String)"Expected executionId: '%s' to be started", (Object)executionId);
            this.scriptState = ScriptState.DONE;
            Thread.interrupted();
        }
    }

    static enum ScriptState {
        REGISTERED,
        STARTED,
        DONE,
        PREREGISTERED;

    }
}

