/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OAuth2AccessTokenResponseMapConverter
implements Converter<OAuth2AccessTokenResponse, Map<String, String>> {
    public Map<String, String> convert(OAuth2AccessTokenResponse tokenResponse) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        long expiresIn = -1L;
        if (tokenResponse.getAccessToken().getExpiresAt() != null) {
            expiresIn = ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
        }
        parameters.put("access_token", tokenResponse.getAccessToken().getTokenValue());
        parameters.put("token_type", tokenResponse.getAccessToken().getTokenType().getValue());
        parameters.put("expires_in", String.valueOf(expiresIn));
        if (!CollectionUtils.isEmpty(tokenResponse.getAccessToken().getScopes())) {
            parameters.put("scope", StringUtils.collectionToDelimitedString(tokenResponse.getAccessToken().getScopes(), (String)" "));
        }
        if (tokenResponse.getRefreshToken() != null) {
            parameters.put("refresh_token", tokenResponse.getRefreshToken().getTokenValue());
        }
        if (!CollectionUtils.isEmpty(tokenResponse.getAdditionalParameters())) {
            for (Map.Entry<String, Object> entry : tokenResponse.getAdditionalParameters().entrySet()) {
                parameters.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return parameters;
    }
}

