/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.StringUtils;

public final class MapOAuth2AccessTokenResponseConverter
implements Converter<Map<String, String>, OAuth2AccessTokenResponse> {
    private static final Set<String> TOKEN_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("access_token", "expires_in", "refresh_token", "scope", "token_type"));

    public OAuth2AccessTokenResponse convert(Map<String, String> tokenResponseParameters) {
        String accessToken = tokenResponseParameters.get("access_token");
        OAuth2AccessToken.TokenType accessTokenType = null;
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(tokenResponseParameters.get("token_type"))) {
            accessTokenType = OAuth2AccessToken.TokenType.BEARER;
        }
        long expiresIn = 0L;
        if (tokenResponseParameters.containsKey("expires_in")) {
            try {
                expiresIn = Long.parseLong(tokenResponseParameters.get("expires_in"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Set<String> scopes = Collections.emptySet();
        if (tokenResponseParameters.containsKey("scope")) {
            String scope = tokenResponseParameters.get("scope");
            scopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        String refreshToken = tokenResponseParameters.get("refresh_token");
        LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : tokenResponseParameters.entrySet()) {
            if (TOKEN_RESPONSE_PARAMETER_NAMES.contains(entry.getKey())) continue;
            additionalParameters.put(entry.getKey(), entry.getValue());
        }
        return OAuth2AccessTokenResponse.withToken(accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }
}

