/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.validators;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import com.xebialabs.xlplatform.security.validator.Invalid;
import com.xebialabs.xlplatform.security.validator.StringValidator;
import com.xebialabs.xlplatform.security.validator.Valid;
import com.xebialabs.xlplatform.security.validator.ValidationResult;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator$;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005mq!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039c\u0001\u0002\u000f\u0010\u0001aB\u0001\"\u000f\u0003\u0003\u0006\u0004%\tA\u000f\u0005\t\u000b\u0012\u0011\t\u0011)A\u0005w!)A\u0005\u0002C\u0001\r\")\u0001\f\u0002C\u00013\")\u0011\u000e\u0002C\u0001U\")A\u000e\u0002C\u0001[\")A\u000e\u0002C\u0001_\")!\u000f\u0002C\u0001g\"9\u0011q\u0001\u0003\u0005\u0002\u0005%\u0011\u0001F+tKJ\f5mY8v]R4\u0016\r\\5eCR|'O\u0003\u0002\u0011#\u0005Qa/\u00197jI\u0006$xN]:\u000b\u0005I\u0019\u0012A\u00023p[\u0006LgN\u0003\u0002\u0015+\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003-]\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003a\t1aY8n\u0007\u0001\u0001\"aG\u0001\u000e\u0003=\u0011A#V:fe\u0006\u001b7m\\;oiZ\u000bG.\u001b3bi>\u00148CA\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AG\u0001\u0014SN4\u0016\r\\5e\u000b6\f\u0017\u000e\\!eIJ,7o\u001d\u000b\u0003Q-\u0002\"aH\u0015\n\u0005)\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u0006Y\r\u0001\r!L\u0001\u0006K6\f\u0017\u000e\u001c\t\u0003]Ur!aL\u001a\u0011\u0005A\u0002S\"A\u0019\u000b\u0005IJ\u0012A\u0002\u001fs_>$h(\u0003\u00025A\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!\u0004e\u0005\u0002\u0005=\u0005\t\u0002/Y:to>\u0014HMV1mS\u0012\fGo\u001c:\u0016\u0003m\u0002\"\u0001P\"\u000e\u0003uR!AP \u0002\u0013Y\fG.\u001b3bi>\u0014(B\u0001!B\u0003!\u0019XmY;sSRL(B\u0001\"\u0016\u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0003\tv\u0012qb\u0015;sS:<g+\u00197jI\u0006$xN]\u0001\u0013a\u0006\u001c8o^8sIZ\u000bG.\u001b3bi>\u0014\b\u0005\u0006\u0002H\u0011B\u00111\u0004\u0002\u0005\u0006s\u001d\u0001\ra\u000f\u0015\u0003\u000f)\u0003\"a\u0013,\u000e\u00031S!!\u0014(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002P!\u00069a-Y2u_JL(BA)S\u0003\u0015\u0011W-\u00198t\u0015\t\u0019F+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0016aA8sO&\u0011q\u000b\u0014\u0002\n\u0003V$xn^5sK\u0012\fQa\u00195fG.$\"AW/\u0011\u0005}Y\u0016B\u0001/!\u0005\u0011)f.\u001b;\t\u000byC\u0001\u0019A0\u0002\u0017U\u001cXM]!dG>,h\u000e\u001e\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\fQAZ8s[NT!\u0001Z3\u0002\u0005Y\f$B\u00014\u0014\u0003\r\t\u0007/[\u0005\u0003Q\u0006\u00141\"V:fe\u0006\u001b7m\\;oi\u0006i1\r[3dWV\u001bXM\u001d8b[\u0016$\"AW6\t\u000byK\u0001\u0019A0\u0002\u001b\rDWmY6QCN\u001cxo\u001c:e)\tQf\u000eC\u0003_\u0015\u0001\u0007q\f\u0006\u0002[a\")\u0011o\u0003a\u0001[\u0005A\u0001/Y:to>\u0014H-\u0001\twC2LG-\u0019;f!\u0006\u001c8o^8sIR\u0019A/!\u0002\u0011\u0007UTH0D\u0001w\u0015\t9\b0\u0001\u0003vi&d'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014A\u0001T5tiB\u0019Q0!\u0001\u000e\u0003yT!a` \u0002\u0007\u0011$x.C\u0002\u0002\u0004y\u0014\u0001\u0004U1tg^|'\u000f\u001a,bY&$\u0017\r^5p]J+7/\u001e7u\u0011\u0015\tH\u00021\u0001.\u0003)\u0019\u0007.Z2l\u000b6\f\u0017\u000e\u001c\u000b\u00045\u0006-\u0001\"\u00020\u000e\u0001\u0004y\u0006f\u0001\u0003\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016I\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI\"a\u0005\u0003\u0013\r{W\u000e]8oK:$\b")
public class UserAccountValidator {
    private final StringValidator passwordValidator;

    public static boolean isValidEmailAddress(String string) {
        return UserAccountValidator$.MODULE$.isValidEmailAddress(string);
    }

    public StringValidator passwordValidator() {
        return this.passwordValidator;
    }

    public void check(UserAccount userAccount) {
        Checks.checkNotNull((Object)userAccount, (String)"User Account can not be null.", (Object[])new Object[]{""});
        this.checkUsername(userAccount);
        this.checkPassword(userAccount);
        this.checkEmail(userAccount);
    }

    public void checkUsername(UserAccount userAccount) {
        block0: {
            Checks.checkArgument((!Strings.isBlank((String)userAccount.getUsername()) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
            if (userAccount.isExternal()) break block0;
            Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
            Matcher matcher = pattern.matcher(userAccount.getUsername());
            Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
        }
    }

    public void checkPassword(UserAccount userAccount) {
        block0: {
            Checks.checkArgument((!Strings.isBlank((String)userAccount.getPassword()) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
            if (userAccount.isExternal()) break block0;
            this.checkPassword(userAccount.getPassword());
        }
    }

    public void checkPassword(String password) {
        List invalids = (List)this.passwordValidator().validate((Object)password).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserAccountValidator.$anonfun$checkPassword$1(x$1)));
        if (invalids.nonEmpty()) {
            throw new Checks.IncorrectArgumentException(((TraversableOnce)new .colon.colon((Object)"Password needs to meet following requirements:", (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)invalids.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.message(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(System.lineSeparator()).append("\t").toString()), new Object[0]);
        }
    }

    public java.util.List<PasswordValidationResult> validatePassword(String password) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)this.passwordValidator().validate((Object)password).map((Function1 & Serializable & scala.Serializable)vr -> new PasswordValidationResult(vr instanceof Valid, vr.message()), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isValid()), Ordering.Boolean$.MODULE$.reverse())).asJava();
    }

    public void checkEmail(UserAccount userAccount) {
        block0: {
            String email = userAccount.getEmail();
            if (!Strings.isNotBlank((String)email)) break block0;
            Checks.checkArgument((boolean)UserAccountValidator$.MODULE$.isValidEmailAddress(email), (String)new StringBuilder(20).append("Email is malformed: ").append(email).toString(), (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkPassword$1(ValidationResult x$1) {
        return x$1 instanceof Invalid;
    }

    @Autowired
    public UserAccountValidator(StringValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }
}

