/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u000f\u001f\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!b\u0001\n\u0007i\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011]\u0003!Q1A\u0005\u0004aC\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tc\u0002\u0011)\u0019!C\u0001e\"A1\u0010\u0001B\u0001B\u0003%1\u000fC\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\t\n\u0001C!\u0003'Cq!a&\u0001\t\u0003\nI\nC\u0004\u0002z\u0002!\t%a?\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u000f\u0001\u0011\u0005#q\u0004\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003X\u0001!IA!\u0017\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!q\u000e\u0001\u0005\n\tE$!F*rY\u0012+G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%\u0001\u0006sKB|7/\u001b;pefT!a\t\u0013\u0002\u0011\u0011,G.\u001b<fefT!!\n\u0014\u0002\u0013ad'/\u001a7fCN,'BA\u0014)\u0003%AXMY5bY\u0006\u00147OC\u0001*\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M\"T\"\u0001\u0011\n\u0005U\u0002#A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f)feNL7\u000f^3oG\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0010\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003ye\u00121\u0003R3mSZ,'/\u001f)feNL7\u000f^3oG\u0016\f\u0011\u0004Z3mSZ,'/_'f[\n,'\u000fU3sg&\u001cH/\u001a8dKB\u0011\u0001hP\u0005\u0003\u0001f\u0012\u0011\u0004R3mSZ,'/_'f[\n,'\u000fU3sg&\u001cH/\u001a8dK\u00061BO]1dW\u0016$\u0017\n^3n!\u0016\u00148/[:uK:\u001cW\r\u0005\u00029\u0007&\u0011A)\u000f\u0002\u0017)J\f7m[3e\u0013R,W\u000eU3sg&\u001cH/\u001a8dK\u0006!2/\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\u0004\"a\u0012&\u000e\u0003!S!aH%\u000b\u0005\u0005\"\u0013BA&I\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s+\u0005q\u0005CA(U\u001b\u0005\u0001&BA)S\u0003!\u0019XmY;sSRL(BA*'\u0003!!W\r\u001d7ps&$\u0018BA+Q\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\u0002'A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\t\u0011\f\u0005\u0002[[:\u00111L\u001b\b\u00039\"t!!\u00184\u000f\u0005y+gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011'&\u0001\u0004=e>|GOP\u0005\u0002S%\u0011q\u0005K\u0005\u0003K\u0019J!a\u001a\u0013\u0002\u0005\u0011\u0014\u0017BA\u0010j\u0015\t9G%\u0003\u0002lY\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005}I\u0017B\u00018p\u0005\u001d!\u0015.\u00197fGRT!a\u001b7\u0002\u0011\u0011L\u0017\r\\3di\u0002\n\u0001\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0011%tG/\u001a:oC2T!\u0001\u001f\u0013\u0002\u0007\u0005\u0004\u0018.\u0003\u0002{k\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0003E!WmY8sCR|'oU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001fy\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003c\u0001\"a \u0001\u000e\u0003yAQAN\u0006A\u0002]BQ!P\u0006A\u0002yBQ!Q\u0006A\u0002\tCQ!R\u0006A\u0002\u0019CQ\u0001T\u0006A\u00049CQaV\u0006A\u0004eC\u0003\"a\u0003\u0002\u0010\u0005-\u0012Q\u0006\t\u0005\u0003#\t9#\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u00033\tY\"A\u0004gC\u000e$xN]=\u000b\t\u0005u\u0011qD\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003C\t\u0019#A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t)#A\u0002pe\u001eLA!!\u000b\u0002\u0014\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\tq\u0003\u001f7s%\u0016\u0004xn]5u_JL8+\u001d7ES\u0006dWm\u0019;\t\u000bE\\\u0001\u0019A:\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003o\t)\u0005\u0005\u0003\u0002:\u0005\u0005SBAA\u001e\u0015\r\u0019\u0013Q\b\u0006\u0004\u0003\u007f!\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002D\u0005m\"\u0001\u0003#fY&4XM]=\t\u000f\u0005\u001dC\u00021\u0001\u0002J\u0005QA-\u001a7jm\u0016\u0014\u00180\u00133\u0011\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\ny\u0005\u0005\u0002a]%\u0019\u0011\u0011\u000b\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t)&a\u0016\u0003\rM#(/\u001b8h\u0015\r\t\tF\f\u0015\u0004\u0019\u0005m\u0003\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005D.A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA3\u0003?\u0012!\"S:SK\u0006$wJ\u001c7z\u000399W\r\u001e\"z\u0013\u0012|%\u000fV5uY\u0016$B!a\u000e\u0002l!9\u0011QN\u0007A\u0002\u0005%\u0013!\u00053fY&4XM]=JI>\u0013H+\u001b;mK\"\u001aQ\"a\u0017\u0002\r\r\u0014X-\u0019;f)\u0011\t)(a\u001f\u0011\u00075\n9(C\u0002\u0002z9\u0012A!\u00168ji\"11E\u0004a\u0001\u0003o\ta!\u001e9eCR,G\u0003BA;\u0003\u0003CaaI\bA\u0002\u0005]\u0012AB3ySN$8\u000f\u0006\u0003\u0002\b\u00065\u0005cA\u0017\u0002\n&\u0019\u00111\u0012\u0018\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\t\tA\u0002\u0005%\u0003f\u0001\t\u0002\\\u00051A-\u001a7fi\u0016$B!!\u001e\u0002\u0016\"9\u0011qI\tA\u0002\u0005%\u0013AB:fCJ\u001c\u0007\u000e\u0006\b\u0002\u001c\u00065\u0016\u0011YAg\u0003/\f\t/!:\u0011\r\u0005u\u0015qUA\u001c\u001d\u0011\ty*a)\u000f\u0007\u0001\f\t+C\u00010\u0013\r\t)KL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI+a+\u0003\u0007M+\u0017OC\u0002\u0002&:Bq!a,\u0013\u0001\u0004\t\t,A\u0004gS2$XM]:\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u0006)am\u001c:ng*\u0019\u00111X<\u0002\u0005Y\f\u0014\u0002BA`\u0003k\u0013q#\u00112tiJ\f7\r\u001e#fY&4XM]=GS2$XM]:\t\u000f\u0005\r'\u00031\u0001\u0002F\u0006!\u0001/Y4f!\u0011\t9-!3\u000e\u0003%K1!a3J\u0005\u0011\u0001\u0016mZ3\t\u000f\u0005='\u00031\u0001\u0002R\u00069qN\u001d3fe\nK\b\u0003BAZ\u0003'LA!!6\u00026\n\tB)\u001a7jm\u0016\u0014\u0018p\u0014:eKJlu\u000eZ3\t\u000f\u0005e'\u00031\u0001\u0002\\\u0006Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\r\u0005u\u0015Q\\A%\u0013\u0011\ty.a+\u0003\u0011%#XM]1cY\u0016Dq!a9\u0013\u0001\u0004\tY.A\u0004s_2,\u0017\nZ:\t\u000f\u0005\u001d(\u00031\u0001\u0002j\u0006\u0001\u0012M\\=PMB+'/\\5tg&|gn\u001d\t\u0007\u0003;\u000b9+a;\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!=Q\u0003)\u0001XM]7jgNLwN\\\u0005\u0005\u0003k\fyO\u0001\u0006QKJl\u0017n]:j_:D3AEA.\u0003%\u0019X-\u0019:dQ&#7\u000f\u0006\u0003\u0002~\u0006}\bCBAO\u0003O\u000bI\u0005C\u0004\u00020N\u0001\r!!-)\u0007M\tY&\u0001\u0012gS:$G)\u001a7jm\u0016\u0014\u0018.Z:SK\u001a,'/\u001a8dS:<'+\u001a7fCN,\u0017\n\u001a\u000b\u0005\u0003{\u00149\u0001C\u0004\u0003\nQ\u0001\r!!\u0013\u0002\u0013I,G.Z1tK&#\u0017a\n4j]\u0012\f5\r^5wK\u0012+G.\u001b<fe&,7OU3gKJ,gnY5oO\u001a{G\u000eZ3s\u0013\u0012$BAa\u0004\u0003\u0018A1\u0011QTAT\u0005#\u00012\u0001\u000fB\n\u0013\r\u0011)\"\u000f\u0002\u000e\u0007&LEmV5uQRKG\u000f\\3\t\u000f\teQ\u00031\u0001\u0002J\u0005Aam\u001c7eKJLE\rK\u0002\u0016\u00037\n\u0001DZ5oIJ+G.Z1tKN\u0014\u0015\u0010R3mSZ,'/_%e)\u0011\u0011\tCa\f\u0011\r\u0005u\u0015q\u0015B\u0012!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0003s\u000bQA^5foNLAA!\f\u0003(\t9B)\u001a7jm\u0016\u0014\u0018P\u00127poJ+G.Z1tK&sgm\u001c\u0005\b\u0003\u000f2\u0002\u0019AA%Q\r1\u00121L\u0001\ri>$U\r\\5wKJLWm\u001d\u000b\u0005\u00037\u00139\u0004C\u0004\u0003:]\u0001\rAa\u000f\u0002\tI|wo\u001d\t\u0007\u0003;\u000b9K!\u0010\u0011\u0007a\u0012y$C\u0002\u0003Be\u00121\u0002R3mSZ,'/\u001f*po\u0006QAo\u001c#fY&4XM]=\u0015\r\u0005]\"q\tB&\u0011\u001d\u0011I\u0005\u0007a\u0001\u0005{\t1A]8x\u0011\u001d\u0011i\u0005\u0007a\u0001\u0003{\fQB\\3x%\u0016dW-Y:f\u0013\u0012\u001c\u0018\u0001\u00044j]\u00124u\u000e\u001c3fe&#G\u0003BA%\u0005'Bq!a\u0012\u001a\u0001\u0004\tI\u0005K\u0002\u001a\u00037\na\u0006Z3d_J\fG/Z,ji\",eMZ3di&4XmU3dkJLG/_!oIB\u000bG\u000f^3s]\u0012+G/Y5mgR!\u00111\u0014B.\u0011\u001d\u0011iF\u0007a\u0001\u00037\u000b!\u0002Z3mSZ,'/[3t\u00035i\u0017\r\u001d+p\t\u0016d\u0017N^3ssR!!1\rB5!\u0015i#QMA\u001c\u0013\r\u00119G\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t-4\u00041\u0001\u0003n\u0005qA-\u001a7jm\u0016\u0014\u0018PU8x\u001fB$\b#B\u0017\u0003f\tu\u0012\u0001F1sK&#X-\\:J]R\u000b'\r\\3FcV\fG\u000e\u0006\u0004\u0002\b\nM$Q\u0010\u0005\b\u0005kb\u0002\u0019\u0001B<\u0003\u001dyG\u000eZ%uK6\u0004B!!\u000f\u0003z%!!1PA\u001e\u0005-!&/Y2lK\u0012LE/Z7\t\u000f\t}D\u00041\u0001\u0003x\u00059a.Z<Ji\u0016l\u0007f\u0001\u0001\u0003\u0004B!!Q\u0011BF\u001b\t\u00119I\u0003\u0003\u0003\n\u0006}\u0011AC:uKJ,w\u000e^=qK&!!Q\u0012BD\u0005)\u0011V\r]8tSR|'/\u001f\u0015\u0004\u0001\tE\u0005\u0003BA/\u0005'KAA!&\u0002`\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)((Object)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable & scala.Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(originalDelivery.getTrackedItems()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), (Function2 & Serializable & scala.Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaSetConverter(originalDelivery.getReleaseIds()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, Seq<Permission> anyOfPermissions) {
        Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            String string;
            DeliverySqlBuilder deliverySqlBuilder = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withTrackedItemTitleLike(filters.getTrackedItemTitle(), filters.isStrictTrackedItemTitleMatch()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))).withFolder(filters.getFolderId()).withPermissions((Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (Seq)Nil$.MODULE$ : anyOfPermissions), principals, roleIds);
            AbstractDeliveryFilters abstractDeliveryFilters = filters;
            if (abstractDeliveryFilters instanceof DeliveryFilters) {
                DeliveryFilters deliveryFilters = (DeliveryFilters)abstractDeliveryFilters;
                string = deliveryFilters.getOriginPatternId();
            } else {
                string = null;
            }
            Tuple2 sqlWithParams = deliverySqlBuilder.withOriginPatternId(string).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<DeliveryRow>)Nil$.MODULE$;
        }
        Seq<DeliveryRow> deliveryRows = seq;
        Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))).withFolder(filters.getFolderId()).build();
        return (Seq)this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.domainId(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable & scala.Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Delivery> toDeliveries(Seq<DeliveryRow> rows) {
        Map<Object, Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, (Seq<String>)((Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
    }

    private Delivery toDelivery(DeliveryRow row, Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)((Object)some.value());
        delivery.setFolderId(row.folderId().absolute());
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), Set$.MODULE$.canBuildFrom());
        delivery.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    private Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(Seq<Delivery> deliveries) {
        return (Seq)deliveries.map((Function1 & Serializable & scala.Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS(), (List)Nil$.MODULE$))).asJava());
            return delivery;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)delivery -> (Delivery)((Object)((Object)this.decorateWithEffectiveSecurityAndPatternDetails((Seq<Delivery>)((Seq)new .colon.colon((Object)delivery, (List)Nil$.MODULE$))).head())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

