/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class CsvReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<CsvReporter> {
    public static final String PERIOD = "period";
    public static final String CLOCK_REF = "clock-ref";
    public static final String DIRECTORY = "directory";
    public static final String LOCALE = "locale";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";

    @Override
    public Class<CsvReporter> getObjectType() {
        return CsvReporter.class;
    }

    @Override
    protected CsvReporter createInstance() {
        File dir;
        CsvReporter.Builder reporter = CsvReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        if (this.hasProperty(CLOCK_REF)) {
            reporter.withClock(this.getPropertyRef(CLOCK_REF, Clock.class));
        }
        if (this.hasProperty(LOCALE)) {
            reporter.formatFor(this.parseLocale(this.getProperty(LOCALE)));
        }
        if (!(dir = new File(this.getProperty(DIRECTORY))).mkdirs() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Directory doesn't exist or couldn't be created");
        }
        return reporter.build(dir);
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }

    protected Locale parseLocale(String localeString) {
        int underscore = localeString.indexOf(95);
        if (underscore == -1) {
            return new Locale(localeString);
        }
        return new Locale(localeString.substring(0, underscore), localeString.substring(underscore + 1));
    }
}

