/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.storedproc.StoredProcedureSnapshotGenerator;
import java.math.BigInteger;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.StringUtil;

public class MySQLStoredProcedureSnapshotGenerator
extends StoredProcedureSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MySQLDatabase) {
            return 50;
        }
        return super.getPriority(clazz, database);
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database object, StoredDatabaseLogic<?> storedDatabaseLogic) {
        CharSequence charSequence = this.getSnapshotObjectSql(storedDatabaseLogic, (Database)object);
        object = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", (Database)object).queryForList(new RawSqlStatement((String)charSequence));
        object = this.castToListOfMaps(object);
        charSequence = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        Boolean bl2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            if (string == null) {
                string = (String)map.get("OBJECT_NAME");
            }
            if (bl2 == null) {
                bl2 = "VALID".equals(map.get("STATUS"));
            }
            String string2 = (String)map.get("DATA_TYPE");
            Object object2 = (String)map.get("PARAMETER_MODE");
            Object object3 = (String)map.get("PARAMETER_NAME");
            if (object3 != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (object2 != null) {
                    stringBuilder.append((String)object2);
                    stringBuilder.append(" ");
                }
                stringBuilder.append((String)object3);
                stringBuilder.append(" ");
                stringBuilder.append(string2.toUpperCase());
                string2 = map.get("CHAR_LENGTH");
                object2 = (BigInteger)map.get("NUMERIC_PRECISION");
                object3 = (Integer)map.get("NUMERIC_SCALE");
                if (string2 != null) {
                    stringBuilder.append("( ");
                    stringBuilder.append((Object)string2);
                    stringBuilder.append(" )");
                } else if (object2 != null) {
                    stringBuilder.append("( ");
                    stringBuilder.append(object2);
                    if (object3 != null && (Integer)object3 > 0) {
                        stringBuilder.append(", ");
                        stringBuilder.append(object3);
                    }
                    stringBuilder.append(" )");
                }
            }
            if (((StringBuilder)charSequence).length() != 0) continue;
            string2 = (String)map.get("OBJECT_BODY");
            if (string2 == null) {
                string2 = " [CANNOT READ OBJECT BODY]";
                object2 = "\nThe current MySQL user does not have permissions to access Stored Logic object bodies needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ OBJECT BODY]' to locate inaccessible objects. This is potentially due to a known\nMySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering permissions with suggested MySQL GRANTs at\nhttps://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object2)));
                Scope.getCurrentScope().getLog(this.getClass()).warning((String)object2);
            }
            ((StringBuilder)charSequence).append(string2.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        charSequence = new StringBuilder(StringUtil.trimToEmpty(StringUtil.trimToEmpty(((StringBuilder)charSequence).toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"))));
        object = " ( " + stringBuilder.toString() + " )";
        ((StringBuilder)charSequence).insert(0, "CREATE PROCEDURE " + string + (String)object + "\n\n");
        return ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogic.getSchema()).setName(string)).setValid(bl2)).setBody(((StringBuilder)charSequence).toString());
    }
}

