/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.Algorithms$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\r\u001b\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011)\u0019!C\u0001m!A\u0001\n\u0001B\u0001B\u0003%q\u0007\u0003\u0005J\u0001\t\u0015\r\u0011\"\u00017\u0011!Q\u0005A!A!\u0002\u00139\u0004\"B&\u0001\t\u0003a\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\u000f]\u0003!\u0019!C\u00051\"1q\f\u0001Q\u0001\neCq\u0001\u0019\u0001C\u0002\u0013%\u0001\f\u0003\u0004b\u0001\u0001\u0006I!\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\u0006y\u0002!\t! \u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0012\u0001\t\u0003\tIE\u0001\tBY\u001e|'/\u001b;i[\u000eCWmY6fe*\u00111\u0004H\u0001\u0004gNd'BA\u000f\u001f\u0003%\u00198\u000f\\2p]\u001aLwM\u0003\u0002 A\u0005AA/\u001f9fg\u00064WMC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005!1-\u001a:u\u0015\tI#&\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0014\u0003'A[\u0015\nW\"feR\u0004\u0016\r\u001e5DQ\u0016\u001c7.\u001a:\u0002\u00115\\Gj\\4hKJ\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003iE\u0012Q\u0002T8hO\u0016\u0014h)Y2u_JL\u0018\u0001F:jO:\fG/\u001e:f\u0007>t7\u000f\u001e:bS:$8/F\u00018!\rA\u0014\t\u0012\b\u0003s}\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0004'\u0016$(B\u0001!>!\t)e)D\u0001\u001b\u0013\t9%DA\nBY\u001e|'/\u001b;i[\u000e{gn\u001d;sC&tG/A\u000btS\u001et\u0017\r^;sK\u000e{gn\u001d;sC&tGo\u001d\u0011\u0002\u001d-,\u0017pQ8ogR\u0014\u0018-\u001b8ug\u0006y1.Z=D_:\u001cHO]1j]R\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002F\u0001!)aF\u0002a\u0001_!)QG\u0002a\u0001o!)\u0011J\u0002a\u0001o\u00051An\\4hKJ,\u0012a\u0015\t\u0003aQK!!V\u0019\u0003\u00199{G)\u001a9t\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u000592/[4oCR,(/Z\"p]N$(/Y5oiNl\u0015\r]\u000b\u00023B!\u0001H\u0017/E\u0013\tY6IA\u0002NCB\u0004\"\u0001O/\n\u0005y\u001b%AB*ue&tw-\u0001\rtS\u001et\u0017\r^;sK\u000e{gn\u001d;sC&tGo]'ba\u0002\n\u0011c[3z\u0007>t7\u000f\u001e:bS:$8/T1q\u0003IYW-_\"p]N$(/Y5oiNl\u0015\r\u001d\u0011\u00025%\u001chi\u001c:xCJ$7\t[3dW&twmU;qa>\u0014H/\u001a3\u0015\u0003\u0011\u0004\"!\u001a4\u000e\u0003uJ!aZ\u001f\u0003\u000f\t{w\u000e\\3b]\u00061r-\u001a;TkB\u0004xN\u001d;fI\u0016CH/\u001a8tS>t7\u000fF\u0001k!\rYW\u000eX\u0007\u0002Y*\u0011!GK\u0005\u0003\u00052\fA!\u001b8jiR\u0011\u0001o\u001d\t\u0003KFL!A]\u001f\u0003\tUs\u0017\u000e\u001e\u0005\u0006i>\u0001\r\u0001Z\u0001\bM>\u0014x/\u0019:e\u0003]1\u0017N\u001c3TS\u001et\u0017\r^;sK\u000e{gn\u001d;sC&tG\u000f\u0006\u0002xuB\u0019Q\r\u001f#\n\u0005el$AB(qi&|g\u000eC\u0003|!\u0001\u0007A,A\u0005bY\u001e|'/\u001b;i[\u0006\tb-\u001b8e\u0017\u0016L8i\u001c8tiJ\f\u0017N\u001c;\u0015\u0005]t\b\"B>\u0012\u0001\u0004a\u0016\u0001G2iK\u000e\\7+[4oCR,(/Z!mO>\u0014\u0018\u000e\u001e5ngR\u0019\u0001/a\u0001\t\u000f\u0005\u0015!\u00031\u0001\u0002\b\u0005A\u00010\u000e\u0019:\u0007\u0016\u0014H\u000fE\u0002&\u0003\u0013I1!a\u0003'\u0005=AV\u0007M\u001dDKJ$\u0018NZ5dCR,\u0017AE2iK\u000e\\7*Z=BY\u001e|'/\u001b;i[N$2\u0001]A\t\u0011\u001d\t)a\u0005a\u0001\u0003\u000f\tQa\u00195fG.$R\u0001]A\f\u0003?Aaa\n\u000bA\u0002\u0005e\u0001cA\u0013\u0002\u001c%\u0019\u0011Q\u0004\u0014\u0003\u0017\r+'\u000f^5gS\u000e\fG/\u001a\u0005\b\u0003C!\u0002\u0019AA\u0012\u0003I)hN]3t_24X\rZ\"sSR,\u0005\u0010^:\u0011\t-\f)\u0003X\u0005\u0004\u0003Oa'AC\"pY2,7\r^5p]\u0006a2/\u001e8tKR\u001c\u0006*Q\u0019TS\u001et\u0017\r^;sK\u0006cwm\u001c:ji\"lGc\u00019\u0002.!9\u0011QA\u000bA\u0002\u0005\u001d\u0011\u0001D5oM>|enU;og\u0016$H#\u00029\u00024\u0005U\u0002bBA\u0003-\u0001\u0007\u0011q\u0001\u0005\b\u0003o1\u0002\u0019AA\u001d\u00039)\u0007\u0010]5sCRLwN\u001c#bi\u0016\u00042a[A\u001e\u0013\r\ti\u0004\u001c\u0002\u0012\u000fJ,wm\u001c:jC:\u001c\u0015\r\\3oI\u0006\u0014\u0018\u0001D<be:|enU;og\u0016$H#\u00029\u0002D\u0005\u0015\u0003bBA\u0003/\u0001\u0007\u0011q\u0001\u0005\b\u0003o9\u0002\u0019AA\u001d\u000359W\r^\"p[6|gNT1nKR\u0019A,a\u0013\t\r\u001dB\u0002\u0019AA\u0004\u0001")
public class AlgorithmChecker
extends PKIXCertPathChecker {
    private final scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints;
    private final scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints;
    private final NoDepsLogger logger;
    private final Map<String, AlgorithmConstraint> signatureConstraintsMap;
    private final Map<String, AlgorithmConstraint> keyConstraintsMap;

    public scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints() {
        return this.signatureConstraints;
    }

    public scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints() {
        return this.keyConstraints;
    }

    private NoDepsLogger logger() {
        return this.logger;
    }

    private Map<String, AlgorithmConstraint> signatureConstraintsMap() {
        return this.signatureConstraintsMap;
    }

    private Map<String, AlgorithmConstraint> keyConstraintsMap() {
        return this.keyConstraintsMap;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void init(boolean forward) {
        this.logger().debug(new StringBuilder(16).append("init: forward = ").append(forward).toString());
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
    }

    public Option<AlgorithmConstraint> findSignatureConstraint(String algorithm) {
        return this.signatureConstraintsMap().get((Object)algorithm);
    }

    public Option<AlgorithmConstraint> findKeyConstraint(String algorithm) {
        return this.keyConstraintsMap().get((Object)algorithm);
    }

    public void checkSignatureAlgorithms(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        this.logger().debug(new StringBuilder(72).append("checkSignatureAlgorithms: sigAlgName = ").append(sigAlgName).append(", sigAlgName = ").append(sigAlgName).append(", sigAlgorithms = ").append(sigAlgorithms).toString());
        sigAlgorithms.foreach((Function1 & Serializable & scala.Serializable)a -> {
            AlgorithmChecker.$anonfun$checkSignatureAlgorithms$1(this, x509Cert, a);
            return BoxedUnit.UNIT;
        });
    }

    public void checkKeyAlgorithms(X509Certificate x509Cert) {
        PublicKey key = x509Cert.getPublicKey();
        String keyAlgorithmName = key.getAlgorithm();
        int keySize = BoxesRunTime.unboxToInt((Object)Algorithms$.MODULE$.keySize(key).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(21).append("No keySize found for ").append(key).toString());
        }));
        scala.collection.immutable.Set<String> keyAlgorithms = Algorithms$.MODULE$.decomposes(keyAlgorithmName);
        this.logger().debug(new StringBuilder(69).append("checkKeyAlgorithms: keyAlgorithmName = ").append(keyAlgorithmName).append(", keySize = ").append(keySize).append(", keyAlgorithms = ").append(keyAlgorithms).toString());
        keyAlgorithms.foreach((Function1 & Serializable & scala.Serializable)a -> {
            AlgorithmChecker.$anonfun$checkKeyAlgorithms$2(this, keySize, x509Cert, a);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) {
        X509Certificate x509Certificate;
        Certificate certificate = cert;
        if (certificate instanceof X509Certificate) {
            x509Certificate = (X509Certificate)certificate;
            String commonName = this.getCommonName(x509Certificate);
            Collection<List<?>> subAltNames = x509Certificate.getSubjectAlternativeNames();
            String certName = x509Certificate.getSubjectX500Principal().getName();
            if (this.logger().isDebugEnabled()) {
                long expirationDate = x509Certificate.getNotAfter().getTime();
                SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                this.logger().debug(new StringBuilder(89).append("check: checking certificate commonName = ").append(commonName).append(", subjAltName = ").append(subAltNames).append(", certName = ").append(certName).append(", expirationDate = ").append(isoFormat.format(BoxesRunTime.boxToLong((long)expirationDate))).toString());
            }
        } else {
            throw new UnsupportedOperationException("check only works with x509 certificates!");
        }
        this.sunsetSHA1SignatureAlgorithm(x509Certificate);
        this.checkSignatureAlgorithms(x509Certificate);
        this.checkKeyAlgorithms(x509Certificate);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void sunsetSHA1SignatureAlgorithm(X509Certificate x509Cert) {
        block2: {
            GregorianCalendar january2017;
            String sigAlgName = x509Cert.getSigAlgName();
            scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
            if (!sigAlgorithms.contains((Object)"SHA1") && !sigAlgorithms.contains((Object)"SHA-1")) break block2;
            GregorianCalendar june2016 = new GregorianCalendar(2016, 6, 1, 0, 0, 0);
            GregorianCalendar december2016 = new GregorianCalendar(2016, 12, 31, 0, 0, 0);
            GregorianCalendar expirationDate = new GregorianCalendar();
            expirationDate.setTime(new Date(x509Cert.getNotAfter().getTime()));
            if (expirationDate.after(june2016) && expirationDate.before(december2016)) {
                this.infoOnSunset(x509Cert, expirationDate);
            }
            if ((january2017 = new GregorianCalendar(2017, 1, 1, 0, 0, 0)).equals(expirationDate) || january2017.before(expirationDate)) {
                this.warnOnSunset(x509Cert, expirationDate);
            }
        }
    }

    public void infoOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.logger().info(new StringBuilder(98).append("Certificate ").append(certName).append(" uses SHA-1 and expires ").append(expirationDate).append(": this certificate expires soon, but SHA-1 is being sunsetted.").toString());
    }

    public void warnOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.logger().warn(new StringBuilder(112).append("Certificate ").append(certName).append(" uses SHA-1 and expires ").append(expirationDate).append(": SHA-1 cannot be considered secure and this certificate should be replaced.").toString());
    }

    public String getCommonName(X509Certificate cert) {
        String string;
        try {
            LdapName ldapName = new LdapName(cert.getSubjectX500Principal().getName());
            ObjectRef cn = ObjectRef.create(null);
            ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ldapName.getRdns()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AlgorithmChecker.$anonfun$getCommonName$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)rdn -> {
                AlgorithmChecker.$anonfun$getCommonName$2(cn, rdn);
                return BoxedUnit.UNIT;
            });
            string = (String)cn.elem;
        }
        catch (InvalidNameException e) {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$checkSignatureAlgorithms$2(AlgorithmChecker $this, String a$1, X509Certificate x509Cert$1, AlgorithmConstraint constraint) {
        if (constraint.matches(a$1)) {
            $this.logger().debug(new StringBuilder(59).append("checkSignatureAlgorithms: x509Cert = ").append(x509Cert$1).append(" failed on constraint ").append(constraint).toString());
            String msg = new StringBuilder(40).append("Certificate failed: ").append(a$1).append(" matched constraint ").append(constraint).toString();
            throw new CertPathValidatorException(msg);
        }
    }

    public static final /* synthetic */ void $anonfun$checkSignatureAlgorithms$1(AlgorithmChecker $this, X509Certificate x509Cert$1, String a) {
        $this.findSignatureConstraint(a).foreach((Function1 & Serializable & scala.Serializable)constraint -> {
            AlgorithmChecker.$anonfun$checkSignatureAlgorithms$2($this, a, x509Cert$1, constraint);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkKeyAlgorithms$3(AlgorithmChecker $this, String a$2, int keySize$1, X509Certificate x509Cert$2, AlgorithmConstraint constraint) {
        if (constraint.matches(a$2, keySize$1)) {
            String certName = x509Cert$2.getSubjectX500Principal().getName();
            $this.logger().debug(new StringBuilder(77).append("checkKeyAlgorithms: cert = \"").append(certName).append("\" failed on constraint ").append(constraint).append(", algorithm = ").append(a$2).append(", keySize = ").append(keySize$1).toString());
            String msg = new StringBuilder(77).append("Certificate failed: cert = \"").append(certName).append("\" failed on constraint ").append(constraint).append(", algorithm = ").append(a$2).append(", keySize = ").append(keySize$1).toString();
            throw new CertPathValidatorException(msg);
        }
    }

    public static final /* synthetic */ void $anonfun$checkKeyAlgorithms$2(AlgorithmChecker $this, int keySize$1, X509Certificate x509Cert$2, String a) {
        $this.findKeyConstraint(a).foreach((Function1 & Serializable & scala.Serializable)constraint -> {
            AlgorithmChecker.$anonfun$checkKeyAlgorithms$3($this, a, keySize$1, x509Cert$2, constraint);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getCommonName$1(Rdn check$ifrefutable$1) {
        Rdn rdn = check$ifrefutable$1;
        boolean bl = rdn != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getCommonName$2(ObjectRef cn$1, Rdn rdn) {
        block0: {
            if (!"CN".equalsIgnoreCase(rdn.getType())) break block0;
            cn$1.elem = rdn.getValue().toString();
        }
    }

    public AlgorithmChecker(LoggerFactory mkLogger, scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints, scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints) {
        this.signatureConstraints = signatureConstraints;
        this.keyConstraints = keyConstraints;
        this.logger = mkLogger.apply(this.getClass());
        this.signatureConstraintsMap = signatureConstraints.iterator().map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.algorithm()), c)).toMap(Predef$.MODULE$.$conforms());
        this.keyConstraintsMap = keyConstraints.iterator().map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.algorithm()), c)).toMap(Predef$.MODULE$.$conforms());
    }
}

