/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.DatabaseFunction;
import liquibase.util.StringUtil;

@DataTypeInfo(name="char", aliases={"java.sql.Types.CHAR", "bpchar"}, minParameters=0, maxParameters=1, priority=1)
public class CharType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof MSSQLDatabase) {
            String param1;
            Object[] parameters = this.getParameters();
            if (!(parameters.length <= 0 || (param1 = parameters[0].toString()).matches("\\d+") && new BigInteger(param1).compareTo(BigInteger.valueOf(8000L)) <= 0)) {
                DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("char"), 8000);
                type.addAdditionalInformation(this.getAdditionalInformation());
                return type;
            }
            if (parameters.length == 0) {
                parameters = new Object[]{1};
            } else if (parameters.length > 1) {
                parameters = Arrays.copyOfRange(parameters, 0, 1);
            }
            DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("char"), parameters);
            type.addAdditionalInformation(this.getAdditionalInformation());
            return type;
        }
        if (database instanceof PostgresDatabase) {
            if (this.getParameters() != null && this.getParameters().length == 1 && "2147483647".equals(this.getParameters()[0].toString())) {
                DatabaseDataType type = new DatabaseDataType("CHARACTER");
                type.addAdditionalInformation("VARYING");
                return type;
            }
            return super.toDatabaseDataType(database);
        }
        return super.toDatabaseDataType(database);
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || "null".equals(value.toString().toLowerCase(Locale.US))) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return value.toString();
        }
        String val = String.valueOf(value);
        if (database instanceof MSSQLDatabase && !StringUtil.isAscii(val)) {
            return "N'" + database.escapeStringForDatabase(val) + "'";
        }
        return "'" + database.escapeStringForDatabase(val) + "'";
    }

    protected int getSize() {
        if (this.getParameters().length == 0) {
            return -1;
        }
        if (this.getParameters()[0] instanceof String) {
            return Integer.parseInt((String)this.getParameters()[0]);
        }
        if (this.getParameters()[0] instanceof Number) {
            return ((Number)this.getParameters()[0]).intValue();
        }
        return -1;
    }

    @Override
    public LoadDataChange.LOAD_DATA_TYPE getLoadTypeName() {
        return LoadDataChange.LOAD_DATA_TYPE.STRING;
    }
}

