/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.ReleasefileExporter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/dsl")
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class DslApi
implements ApiService {
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private ReleasefileExporter releasefileExporter;

    @Autowired
    public DslApi(PermissionChecker permissions, ReleaseService releaseService, ReleasefileExporter releasefileExporter) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releasefileExporter = releasefileExporter;
    }

    public String serviceName() {
        return "dslApi";
    }

    @GET
    @Path(value="/preview/{templateId:.*Release[^/]*}")
    @Produces(value={"text/plain"})
    public Response previewExportTemplateToXFile(@PathParam(value="templateId") String templateId, @QueryParam(value="exportTemplate") boolean asTemplate) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releaseService.findById(templateId);
        return Response.ok((Object)this.releasefileExporter.exportAsString(template, asTemplate)).build();
    }

    @GET
    @Path(value="/export/{templateId:.*Release[^/]*}")
    @Produces(value={"application/octet-stream"})
    public Response exportTemplateToXFile(@PathParam(value="templateId") String templateId, @QueryParam(value="exportTemplate") boolean asTemplate) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releaseService.findById(templateId);
        StreamingOutput output = outputStream -> {
            WorkDirContext.initWorkdir();
            WorkDir workDir = WorkDirContext.get();
            try {
                this.releasefileExporter.exportZippedWithAttachments(template, asTemplate, outputStream);
            }
            finally {
                workDir.delete();
                WorkDirContext.clear();
            }
        };
        return ResponseHelper.streamFile((String)(template.getTitle() + ".zip"), (StreamingOutput)output, (String)"application/zip");
    }

    @PublicApiMember
    public String exportTemplate(Release template) {
        return this.exportTemplate(template, false);
    }

    @PublicApiMember
    public String exportTemplate(Release template, boolean asTemplate) {
        return this.apiExportTemplate(template, asTemplate);
    }

    private String apiExportTemplate(Release template, boolean renderAsTemplate) {
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(template.getId()), (Object)"Only templates can be exported.");
        this.permissions.checkView(template.getId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.releasefileExporter.exportAsReleasefile(template, renderAsTemplate, baos);
        try {
            return baos.toString(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

