/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.SpringSessionConverterFactory;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import com.xebialabs.xlrelease.repository.SpringSessionRepository;
import com.xebialabs.xlrelease.spring.configuration.CustomJdbcHttpSessionConfiguration;
import com.xebialabs.xlrelease.spring.repository.CustomJdbcIndexedSessionRepository;
import com.xebialabs.xlrelease.spring.repository.CustomJdbcIndexedSessionRepositoryCustomizer;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SpringSessionConfiguration
extends CustomJdbcHttpSessionConfiguration {
    private XlrConfig xlrConfig;
    private DatabaseInfo dbInfo;
    private ClassLoader classLoader;
    private SpringSessionConverterFactory converterFactory;
    private String cleanupCron;

    public SpringSessionConfiguration(@Autowired XlrConfig xlrConfig, @Autowired @Qualifier(value="xlrDbInfo") DatabaseInfo dbInfo, @Autowired ServerConfiguration serverConfiguration, @Autowired(required=false) SpringSessionConverterFactory converterFactory) {
        this.xlrConfig = xlrConfig;
        this.dbInfo = dbInfo;
        this.converterFactory = converterFactory;
        int sessionTimeoutSeconds = serverConfiguration.getClientSessionTimeoutMinutes() * 60;
        int maxInactiveInterval = sessionTimeoutSeconds == 0 ? 2592000 : sessionTimeoutSeconds;
        super.setMaxInactiveIntervalInSeconds(maxInactiveInterval);
        this.cleanupCron = xlrConfig.server_session_storage_cleanupCron();
        super.setCleanupCron(this.cleanupCron);
    }

    @Override
    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, @Qualifier(value="xlrRepositoryDataSourceProxy") ObjectProvider<DataSource> dataSource) {
        super.setDataSource(springSessionDataSource, dataSource);
    }

    @Override
    @Autowired
    public void setTransactionManager(@Qualifier(value="xlrRepositoryTransactionManager") PlatformTransactionManager transactionManager) {
        super.setTransactionManager(transactionManager);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.classLoader = classLoader;
    }

    @Override
    @Bean
    public CustomJdbcIndexedSessionRepository sessionRepository() {
        CustomJdbcIndexedSessionRepository repo = super.sessionRepository();
        GenericConversionService conversionService = this.createConversionServiceWithBeanClassLoader();
        repo.setConversionService((ConversionService)conversionService);
        return repo;
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        if (this.xlrConfig.server_session_storage_enabled()) {
            return new SpringSessionBackedSessionRegistry((FindByIndexNameSessionRepository)this.sessionRepository());
        }
        return new SessionRegistryImpl();
    }

    @Bean
    public CustomJdbcIndexedSessionRepositoryCustomizer customJdbcIndexedSessionRepositoryCustomizer() {
        return new CustomJdbcIndexedSessionRepositoryCustomizer(this.dbInfo);
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader() {
        DefaultConversionService conversionService = new DefaultConversionService();
        if (this.converterFactory != null) {
            conversionService.addConverter(this.converterFactory.buildSerializer(this.classLoader));
            conversionService.addConverter(this.converterFactory.buildDeserializer(this.classLoader));
        } else {
            conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
            conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader));
        }
        return conversionService;
    }

    @EnableScheduling
    @Configuration(proxyBeanMethods=false)
    class EmptyPrincipalCleanupConfiguration
    implements SchedulingConfigurer {
        private final SpringSessionRepository springSessionRepository;

        EmptyPrincipalCleanupConfiguration(SpringSessionRepository springSessionRepository) {
            this.springSessionRepository = springSessionRepository;
        }

        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            taskRegistrar.addCronTask(this.springSessionRepository::cleanUpSessionsWithEmptyPrincipal, SpringSessionConfiguration.this.cleanupCron);
        }
    }
}

