/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.api.v1.form.ApplicationForm;
import com.xebialabs.xlrelease.api.v1.views.ApplicationView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/applications")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class ApplicationApi
implements ApiService {
    private ApplicationService applicationService;

    public String serviceName() {
        return "applicationApi";
    }

    @Autowired
    public ApplicationApi(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @POST
    @Timed
    public ApplicationView createApplication(ApplicationForm applicationForm) {
        return ApplicationView.fromApplication(this.applicationService.createApplication(applicationForm.toApplication()));
    }

    @GET
    @Timed
    @Path(value="/{applicationId:.*/Application[^/]*}")
    public ApplicationView getApplication(@PathParam(value="applicationId") String applicationId) {
        return ApplicationView.fromApplication(this.applicationService.findApplicationById(applicationId));
    }

    @PUT
    @Timed
    @Path(value="/{applicationId:.*/Application[^/]*}")
    public ApplicationView updateApplication(@PathParam(value="applicationId") String applicationId, ApplicationForm applicationForm) {
        Application application = applicationForm.toApplication();
        application.setId(applicationId);
        return ApplicationView.fromApplication(this.applicationService.updateApplication(application));
    }

    @POST
    @Timed
    @Path(value="/search")
    public List<ApplicationView> searchApplications(ApplicationFilters applicationFilters) {
        return this.applicationService.searchApplications(applicationFilters).stream().map(ApplicationView::fromApplication).collect(Collectors.toList());
    }

    @DELETE
    @PublicApiMember
    @Timed
    @Path(value="/{applicationId:.*/Application[^/]*}")
    public void deleteApplication(@PathParam(value="applicationId") String applicationId) {
        this.applicationService.deleteApplication(applicationId);
    }

    @PublicApiMember
    @Timed
    public Application create(Application application) {
        return this.applicationService.createApplication(application);
    }

    @PublicApiMember
    @Timed
    public Application getById(String applicationId) {
        return this.applicationService.findApplicationById(applicationId);
    }

    @PublicApiMember
    @Timed
    public Application update(Application application) {
        return this.applicationService.updateApplication(application);
    }

    @PublicApiMember
    @Timed
    public List<Application> search(ApplicationFilters filters) {
        return this.applicationService.searchApplications(filters);
    }
}

