/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class JwtReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ReactiveJwtDecoder jwtDecoder;
    private Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter = new ReactiveJwtAuthenticationConverterAdapter(new JwtAuthenticationConverter());

    public JwtReactiveAuthenticationManager(ReactiveJwtDecoder jwtDecoder) {
        Assert.notNull((Object)jwtDecoder, (String)"jwtDecoder cannot be null");
        this.jwtDecoder = jwtDecoder;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(arg_0 -> ((ReactiveJwtDecoder)this.jwtDecoder).decode(arg_0)).flatMap(arg_0 -> this.jwtAuthenticationConverter.convert(arg_0)).cast(Authentication.class).onErrorMap(JwtException.class, this::onError);
    }

    public void setJwtAuthenticationConverter(Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
        Assert.notNull(jwtAuthenticationConverter, (String)"jwtAuthenticationConverter cannot be null");
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    }

    private AuthenticationException onError(JwtException e) {
        if (e instanceof BadJwtException) {
            return new InvalidBearerTokenException(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }
}

