/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.scheduler;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private final ScheduledExecutorService scheduler;
    private int awaitTerminationSeconds;
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);

    public Scheduler(ScheduledExecutorService scheduler, int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduler);
    }

    public synchronized ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(Scheduler.withLoggedExceptions(command), initialDelay, delay, unit);
    }

    public synchronized ScheduledFuture<?> scheduleOnce(Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule(command, delay, unit);
    }

    public void execute(Runnable command) {
        this.scheduler.execute(Scheduler.withLoggedExceptions(command));
    }

    public Future<?> submit(Runnable command) {
        return this.scheduler.submit(Scheduler.withLoggedExceptions(command));
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> command) {
        return CompletableFuture.supplyAsync(command, this.scheduler);
    }

    public CompletableFuture<Object> supplyAsync(Supplier<Object> command, long timeout, TimeUnit unit) {
        return CompletableFuture.anyOf(this.supplyAsync(command), this.timeoutAfter(timeout, unit));
    }

    private <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        this.scheduler.schedule(() -> result.completeExceptionally(new TimeoutException()), timeout, unit);
        return result;
    }

    public void shutdown() {
        LOG.info("Initiating Scheduler shutdown.");
        this.shutdownAndAwaitTermination(this.scheduler);
        LOG.info("Scheduler shutdown finished");
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private void shutdownAndAwaitTermination(ExecutorService executorService) {
        try {
            List<Runnable> runnables = executorService.shutdownNow();
            for (Runnable runnable : runnables) {
                FutureTask futureTask;
                if (!(runnable instanceof FutureTask) || (futureTask = (FutureTask)runnable).isDone()) continue;
                futureTask.cancel(true);
            }
            boolean terminated = executorService.awaitTermination(this.awaitTerminationSeconds, TimeUnit.SECONDS);
            if (!terminated) {
                LOG.warn("Could not finish termination of executorService. There are still active threads.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Could not finish termination of executorService.", (Throwable)e);
        }
    }

    private static Runnable withLoggedExceptions(Runnable command) {
        return () -> {
            try {
                command.run();
            }
            catch (Exception e) {
                LOG.error("Error while running a scheduled task.", (Throwable)e);
                throw e;
            }
        };
    }
}

