/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.Deploy;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.Props;
import akka.actor.Scope;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.persistence.Persistence$;
import akka.persistence.PersistenceSettings;
import akka.persistence.RecoveryPermitter$;
import akka.persistence.StashOverflowStrategy;
import akka.persistence.StashOverflowStrategyConfigurator;
import akka.persistence.journal.EventAdapters;
import akka.persistence.journal.EventAdapters$;
import akka.persistence.journal.IdentityEventAdapters$;
import akka.routing.RouterConfig;
import akka.util.Collections;
import akka.util.Reflect$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rMt!B*U\u0011\u0003If!B.U\u0011\u0003a\u0006B\u0002;\u0002\t\u0003\u0011i\u000fC\u0004\u0003p\u0006!\tE!=\t\u000f\t=\u0018\u0001\"\u0011\u0003|\"9!\u0011]\u0001\u0005\u0002\r\u0015\u0001bBB\u0005\u0003\u0011\u000511\u0002\u0004\b\u00033\u000b\u0001\tVAN\u0011%1wA!f\u0001\n\u0003\ty\u0003\u0003\u0006\u0002*\u001e\u0011\t\u0012)A\u0005\u0003cA!\"a+\b\u0005+\u0007I\u0011AAW\u0011)\tYl\u0002B\tB\u0003%\u0011q\u0016\u0005\u000b\u0003+9!Q3A\u0005\u0002\u0005]\u0001BCA\u0016\u000f\tE\t\u0015!\u0003\u0002\u001a!1Ao\u0002C\u0001\u0003{C\u0011\"!3\b\u0003\u0003%\t!a3\t\u0013\u0005Mw!%A\u0005\u0002\u0005U\u0007\"CAu\u000fE\u0005I\u0011AAv\u0011%\tyoBI\u0001\n\u0003\t\t\u0010C\u0005\u0002v\u001e\t\t\u0011\"\u0011\u0002\u0002!I\u0011q_\u0004\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u00039\u0011\u0011!C\u0001\u0005\u0007A\u0011Ba\u0004\b\u0003\u0003%\tE!\u0005\t\u0013\t}q!!A\u0005\u0002\t\u0005\u0002\"\u0003B\u0016\u000f\u0005\u0005I\u0011\tB\u0017\u0011%\u0011ycBA\u0001\n\u0003\u0012\t\u0004C\u0005\u00034\u001d\t\t\u0011\"\u0011\u00036\u001dQ1QB\u0001\u0002\u0002#\u0005Aka\u0004\u0007\u0015\u0005e\u0015!!A\t\u0002Q\u001b\t\u0002\u0003\u0004u9\u0011\u00051q\u0004\u0005\n\u0005_a\u0012\u0011!C#\u0005cA\u0011b!\t\u001d\u0003\u0003%\tia\t\t\u0013\r-B$!A\u0005\u0002\u000e5\u0002\"CB 9\u0005\u0005I\u0011BB!\u0011%\u0019I%\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0004L\u0005\u0001\u000b\u0011BA\u0002\u0011%\u0019i%\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0004P\u0005\u0001\u000b\u0011BA\u0002\u0011!\u0019\t&\u0001C\u0001-\u000eM\u0003\u0002CB1\u0003\u0011\u0005aka\u0019\t\u000f\r-\u0014\u0001\"\u0003\u0004n\u0019!1\f\u0016\u0001k\u0011!q\u0017F!b\u0001\n\u0003y\u0007\u0002C:*\u0005\u0003\u0005\u000b\u0011\u00029\t\u000bQLC\u0011A;\t\u000b]LC\u0011\u0002=\t\u0011}L#\u0019!C\u0005\u0003\u0003A\u0001\"a\u0005*A\u0003%\u00111\u0001\u0005\n\u0003+I#\u0019!C\u0005\u0003/A\u0001\"a\u000b*A\u0003%\u0011\u0011\u0004\u0005\u000b\u0003[I#\u0019!C\u0001-\u0006=\u0002\u0002CA\u001cS\u0001\u0006I!!\r\t\u0015\u0005\u001d\u0013\u0006#b\u0001\n\u0013\t\t\u0001\u0003\u0006\u0002J%B)\u0019!C\u0005\u0003\u0003A!\"a\u0013*\u0011\u000b\u0007I\u0011AA'\u0011%\t)&\u000bb\u0001\n\u0003\t9\u0006\u0003\u0005\u0002`%\u0002\u000b\u0011BA-\u0011%\t\t'\u000bb\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0003:%\u0002\u000b\u0011BA3\u0011\u001d\u0011Y$\u000bC\u0005\u0005{AqA!\u0014*\t\u0013\u0011y\u0005C\u0004\u0003V%\")Aa\u0016\t\u000f\tU\u0013\u0006\"\u0002\u0003^!A!QK\u0015\u0005\u0006Y\u0013)\u0007\u0003\u0005\u0003l%\")A\u0016B7\u0011)\u0011\u0019(KI\u0001\n\u000b1\u0016\u0011\u001f\u0005\t\u0005kJCQ\u0001,\u0003x!A!1P\u0015\u0005\u0006Y\u0013i\b\u0003\u0006\u0003\u0004&\n\n\u0011\"\u0002W\u0003cD\u0001B!\"*\t\u000b1&q\u0011\u0005\u000b\u0005#K\u0013\u0013!C\u0003-\u0006E\bb\u0002BJS\u0011%!Q\u0013\u0005\b\u0005WKC\u0011\u0002BW\u0011\u001d\u0011\u0019,\u000bC\u0005\u0005kCqAa/*\t\u0003\u0011i\fC\u0004\u0003D&\"IA!2\u0007\r\t-\u0017\u0006\u0002Bg\u0011)\u0011Y\u0005\u0014B\u0001B\u0003%\u0011q\u0012\u0005\u000b\u00057c%\u0011!Q\u0001\n\u0005=\u0005B\u0003BP\u0019\n\u0005\t\u0015!\u0003\u0002\u001a!1A\u000f\u0014C\u0001\u0005\u001fDa\u0001\u001e'\u0005\u0002\tm\u0007b\u0002Bq\u0019\u0012\u0005#1]\u0001\f!\u0016\u00148/[:uK:\u001cWM\u0003\u0002V-\u0006Y\u0001/\u001a:tSN$XM\\2f\u0015\u00059\u0016\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u0002[\u00035\tAKA\u0006QKJ\u001c\u0018n\u001d;f]\u000e,7#B\u0001^G\n\u001d\bC\u00010b\u001b\u0005y&\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t|&AB!osJ+g\rE\u0002eO&l\u0011!\u001a\u0006\u0003MZ\u000bQ!Y2u_JL!\u0001[3\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u00035&\u001a2!K/l!\t!G.\u0003\u0002nK\nIQ\t\u001f;f]NLwN\\\u0001\u0007gf\u001cH/Z7\u0016\u0003A\u0004\"\u0001Z9\n\u0005I,'aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%4\b\"\u00028-\u0001\u0004\u0001\u0018a\u00017pOV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}-\u0006)QM^3oi&\u0011ap\u001f\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003]qun\u00158baNDw\u000e^*u_J,\u0007\u000b\\;hS:LE-\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\u0004TiJLgnZ\u0001\u0019\u001d>\u001cf.\u00199tQ>$8\u000b^8sKBcWoZ5o\u0013\u0012\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\u001aA!\u00111DA\u0014\u001b\t\tiB\u0003\u0003\u0002\u0016\u0005}!\u0002BA\u0011\u0003G\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003K\t1aY8n\u0013\u0011\tI#!\b\u0003\r\r{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0011C]3d_Z,'/\u001f)fe6LG\u000f^3s+\t\t\t\u0004E\u0002e\u0003gI1!!\u000ef\u0005!\t5\r^8s%\u00164\u0017A\u0005:fG>4XM]=QKJl\u0017\u000e\u001e;fe\u0002B3aMA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u0013q\b\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0001\feK\u001a\fW\u000f\u001c;K_V\u0014h.\u00197QYV<\u0017N\\%e\u0003]!WMZ1vYR\u001cf.\u00199tQ>$\b\u000b\\;hS:LE-\u0001\u0013eK\u001a\fW\u000f\u001c;J]R,'O\\1m'R\f7\u000f[(wKJ4Gn\\<TiJ\fG/Z4z+\t\ty\u0005E\u0002[\u0003#J1!a\u0015U\u0005U\u0019F/Y:i\u001fZ,'O\u001a7poN#(/\u0019;fOf\f\u0001b]3ui&twm]\u000b\u0003\u00033\u00022AWA.\u0013\r\ti\u0006\u0016\u0002\u0014!\u0016\u00148/[:uK:\u001cWmU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n\u0011\u0003\u001d7vO&tW\t\u001f;f]NLwN\\%e+\t\t)\u0007\u0005\u0004\u0002h\u0005U\u0014\u0011P\u0007\u0003\u0003SRA!a\u001b\u0002n\u00051\u0011\r^8nS\u000eTA!a\u001c\u0002r\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005M\u00141B\u0001\u0005kRLG.\u0003\u0003\u0002x\u0005%$aD!u_6L7MU3gKJ,gnY3\u0011\u0011\u0005m\u0014\u0011RAH\u0003'sA!! \u0002\u0006B\u0019\u0011qP0\u000e\u0005\u0005\u0005%bAAB1\u00061AH]8pizJ1!a\"`\u0003\u0019\u0001&/\u001a3fM&!\u00111RAG\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u000f{\u0006\u0003BA>\u0003#KA!!\u0005\u0002\u000eB!AmZAK!\r\t9j\u0002\b\u00035\u0002\u0011A\u0002\u00157vO&t\u0007j\u001c7eKJ\u001craB/l\u0003;\u000b\u0019\u000bE\u0002_\u0003?K1!!)`\u0005\u001d\u0001&o\u001c3vGR\u00042AXAS\u0013\r\t9k\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007C\u000e$xN\u001d\u0011\u0002\u0011\u0005$\u0017\r\u001d;feN,\"!a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.U\u0003\u001dQw.\u001e:oC2LA!!/\u00024\niQI^3oi\u0006#\u0017\r\u001d;feN\f\u0011\"\u00193baR,'o\u001d\u0011\u0015\u0011\u0005}\u00161YAc\u0003\u000f\u00042!!1\b\u001b\u0005\t\u0001B\u00024\u000f\u0001\u0004\t\t\u0004C\u0004\u0002,:\u0001\r!a,\t\u000f\u0005Ua\u00021\u0001\u0002\u001a\u0005!1m\u001c9z)!\ty,!4\u0002P\u0006E\u0007\u0002\u00034\u0010!\u0003\u0005\r!!\r\t\u0013\u0005-v\u0002%AA\u0002\u0005=\u0006\"CA\u000b\u001fA\u0005\t\u0019AA\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a6+\t\u0005E\u0012\u0011\\\u0016\u0003\u00037\u0004B!!8\u0002f6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011I0\n\t\u0005\u001d\u0018q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[TC!a,\u0002Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAzU\u0011\tI\"!7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0010E\u0002_\u0003{L1!a@`\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Aa\u0003\u0011\u0007y\u00139!C\u0002\u0003\n}\u00131!\u00118z\u0011%\u0011i!FA\u0001\u0002\u0004\tY0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u001c\t\u0015QB\u0001B\f\u0015\r\u0011IbX\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0005B\u0015!\rq&QE\u0005\u0004\u0005Oy&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u001b9\u0012\u0011!a\u0001\u0005\u000b\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003w\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\ta!Z9vC2\u001cH\u0003\u0002B\u0012\u0005oA\u0011B!\u0004\u001b\u0003\u0003\u0005\rA!\u0002\u0002%AdWoZ5o\u000bb$XM\\:j_:LE\rI\u0001 m\u0016\u0014\u0018NZ=K_V\u0014h.\u00197QYV<\u0017N\\\"p]\u001aLw-\u0012=jgR\u001cHC\u0002B \u0005\u000b\u0012I\u0005E\u0002_\u0005\u0003J1Aa\u0011`\u0005\u0011)f.\u001b;\t\u000f\t\u001d3\b1\u0001\u0002\u001a\u0005a\u0001\u000f\\;hS:\u001cuN\u001c4jO\"9!1J\u001eA\u0002\u0005=\u0015AC2p]\u001aLw\rU1uQ\u0006\u0001c/\u001a:jMf\u001cf.\u00199tQ>$\b\u000b\\;hS:\u001cuN\u001c4jO\u0016C\u0018n\u001d;t)\u0019\u0011yD!\u0015\u0003T!9!q\t\u001fA\u0002\u0005e\u0001b\u0002B&y\u0001\u0007\u0011qR\u0001\fC\u0012\f\u0007\u000f^3sg\u001a{'\u000f\u0006\u0003\u00020\ne\u0003b\u0002B.{\u0001\u0007\u0011qR\u0001\u0010U>,(O\\1m!2,x-\u001b8JIR1\u0011q\u0016B0\u0005CBqAa\u0017?\u0001\u0004\ty\tC\u0004\u0003dy\u0002\r!!\u0007\u0002')|WO\u001d8bYBcWoZ5o\u0007>tg-[4\u0015\t\u0005=&q\r\u0005\b\u0005Sz\u0004\u0019AA\u0019\u0003IQw.\u001e:oC2\u0004F.^4j]\u0006\u001bGo\u001c:\u0002!)|WO\u001d8bY\u000e{gNZ5h\r>\u0014HCBA\r\u0005_\u0012\t\bC\u0004\u0003\\\u0001\u0003\r!a$\t\u0013\t\r\u0004\t%AA\u0002\u0005e\u0011A\u00076pkJt\u0017\r\\\"p]\u001aLwMR8sI\u0011,g-Y;mi\u0012\u0012\u0014!C2p]\u001aLwMR8s)\u0011\tIB!\u001f\t\u000f\t%$\t1\u0001\u00022\u0005Q!n\\;s]\u0006dgi\u001c:\u0015\r\u0005E\"q\u0010BA\u0011\u001d\u0011Yf\u0011a\u0001\u0003\u001fC\u0011Ba\u0019D!\u0003\u0005\r!!\u0007\u0002))|WO\u001d8bY\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003A\u0019h.\u00199tQ>$8\u000b^8sK\u001a{'\u000f\u0006\u0004\u00022\t%%Q\u0012\u0005\b\u0005\u0017+\u0005\u0019AAH\u0003A\u0019h.\u00199tQ>$\b\u000b\\;hS:LE\rC\u0005\u0003\u0010\u0016\u0003\n\u00111\u0001\u0002\u001a\u0005!2O\\1qg\"|G\u000f\u00157vO&t7i\u001c8gS\u001e\f!d\u001d8baNDw\u000e^*u_J,gi\u001c:%I\u00164\u0017-\u001e7uII\nq\u0002\u001d7vO&t\u0007j\u001c7eKJ4uN\u001d\u000b\t\u0003+\u00139J!'\u0003\u001e\"9!1J$A\u0002\u0005=\u0005b\u0002BN\u000f\u0002\u0007\u0011qR\u0001\rM\u0006dGNY1dWB\u000bG\u000f\u001b\u0005\b\u0005?;\u0005\u0019AA\r\u0003A\tG\rZ5uS>t\u0017\r\\\"p]\u001aLw\rK\u0002H\u0005G\u0003BA!*\u0003(6\u0011\u00111]\u0005\u0005\u0005S\u000b\u0019OA\u0004uC&d'/Z2\u0002\u0019\r\u0014X-\u0019;f!2,x-\u001b8\u0015\r\u0005E\"q\u0016BY\u0011\u001d\u0011Y\u0005\u0013a\u0001\u0003\u001fCqAa\u0012I\u0001\u0004\tI\"\u0001\bde\u0016\fG/Z!eCB$XM]:\u0015\r\u0005=&q\u0017B]\u0011\u001d\u0011Y%\u0013a\u0001\u0003\u001fCqAa(J\u0001\u0004\tI\"A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u000b\u0005\u0003\u001f\u0013y\fC\u0004\u0003B*\u0003\r!!\r\u0002\u001fA,'o]5ti\u0016tG/Q2u_J\f!!\u001b3\u0015\t\u0005=%q\u0019\u0005\b\u0005\u0013\\\u0005\u0019AA\u0019\u0003\r\u0011XM\u001a\u0002\u0018!2,x-\u001b8I_2$WM]#yi\u0016t7/[8o\u0013\u0012\u001cB\u0001T/\u0002\u0014RA!\u0011\u001bBk\u0005/\u0014I\u000eE\u0002\u0003T2k\u0011!\u000b\u0005\b\u0005\u0017\u0002\u0006\u0019AAH\u0011\u001d\u0011Y\n\u0015a\u0001\u0003\u001fCqAa(Q\u0001\u0004\tI\u0002\u0006\u0004\u0003R\nu'q\u001c\u0005\b\u0005\u0017\n\u0006\u0019AAH\u0011\u001d\u0011Y*\u0015a\u0001\u0003\u001f\u000bqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0005\u0003+\u0013)\u000fC\u0003o%\u0002\u0007\u0001\u000fE\u0002e\u0005SL1Aa;f\u0005M)\u0005\u0010^3og&|g.\u00133Qe>4\u0018\u000eZ3s)\u0005I\u0016aA4fiR\u0019\u0011Na=\t\r9\u001c\u0001\u0019\u0001B{!\r!'q_\u0005\u0004\u0005s,'aC!di>\u00148+_:uK6$2!\u001bB\u007f\u0011\u0019qG\u00011\u0001\u0003\u0000B\u0019Am!\u0001\n\u0007\r\rQM\u0001\u000eDY\u0006\u001c8/[2BGR|'oU=ti\u0016l\u0007K]8wS\u0012,'\u000fF\u0002j\u0007\u000fAQA\\\u0003A\u0002A\fa\u0001\\8pWV\u0004HCAAL\u00031\u0001F.^4j]\"{G\u000eZ3s!\r\t\t\rH\n\u00069\rM\u00111\u0015\t\r\u0007+\u0019Y\"!\r\u00020\u0006e\u0011qX\u0007\u0003\u0007/Q1a!\u0007`\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\b\u0004\u0018\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\r=\u0011!B1qa2LH\u0003CA`\u0007K\u00199c!\u000b\t\r\u0019|\u0002\u0019AA\u0019\u0011\u001d\tYk\ba\u0001\u0003_Cq!!\u0006 \u0001\u0004\tI\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r=21\b\t\u0006=\u000eE2QG\u0005\u0004\u0007gy&AB(qi&|g\u000eE\u0005_\u0007o\t\t$a,\u0002\u001a%\u00191\u0011H0\u0003\rQ+\b\u000f\\34\u0011%\u0019i\u0004IA\u0001\u0002\u0004\ty,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u001111\t\t\u0005\u0003\u000b\u0019)%\u0003\u0003\u0004H\u0005\u001d!AB(cU\u0016\u001cG/A\rK_V\u0014h.\u00197GC2d'-Y2l\u0007>tg-[4QCRD\u0017A\u0007&pkJt\u0017\r\u001c$bY2\u0014\u0017mY6D_:4\u0017n\u001a)bi\"\u0004\u0013aH*oCB\u001c\bn\u001c;Ti>\u0014XMR1mY\n\f7m[\"p]\u001aLw\rU1uQ\u0006\u00013K\\1qg\"|Go\u0015;pe\u00164\u0015\r\u001c7cC\u000e\\7i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003a1XM]5gsBcWoZ5o\u0007>tg-[4Fq&\u001cHo\u001d\u000b\t\u0005\u007f\u0019)fa\u0016\u0004\\!9\u0011Q\u0003\u0014A\u0002\u0005e\u0001bBB-M\u0001\u0007\u0011qR\u0001\ta2,x-\u001b8JI\"91Q\f\u0014A\u0002\u0005=\u0015A\u00039mk\u001eLg\u000eV=qK\"\u001aa%a\u000f\u00027Y,'/\u001b4z!2,x-\u001b8D_:4\u0017nZ%t\t\u00164\u0017N\\3e)\u0019\u0011yd!\u001a\u0004h!91\u0011L\u0014A\u0002\u0005=\u0005bBB/O\u0001\u0007\u0011q\u0012\u0015\u0004O\u0005m\u0012aB5t\u000b6\u0004H/\u001f\u000b\u0005\u0005G\u0019y\u0007C\u0004\u0004r!\u0002\r!a$\u0002\tQ,\u0007\u0010\u001e")
public class Persistence
implements Extension {
    private String defaultJournalPluginId;
    private String defaultSnapshotPluginId;
    private StashOverflowStrategy defaultInternalStashOverflowStrategy;
    private final ExtendedActorSystem system;
    private final String NoSnapshotStorePluginId;
    private final Config config;
    @InternalApi
    private final ActorRef recoveryPermitter;
    private final PersistenceSettings settings;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId;
    private volatile byte bitmap$0;

    public static String SnapshotStoreFallbackConfigPath() {
        return Persistence$.MODULE$.SnapshotStoreFallbackConfigPath();
    }

    public static String JournalFallbackConfigPath() {
        return Persistence$.MODULE$.JournalFallbackConfigPath();
    }

    public static Persistence$ lookup() {
        return Persistence$.MODULE$.lookup();
    }

    public static Persistence createExtension(ExtendedActorSystem extendedActorSystem) {
        return Persistence$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Persistence get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.get(classicActorSystemProvider);
    }

    public static Persistence get(ActorSystem actorSystem) {
        return Persistence$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Persistence$.MODULE$.apply(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter akka$persistence$Persistence$$log() {
        return Logging$.MODULE$.apply((ActorSystem)this.system(), (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
    }

    private String NoSnapshotStorePluginId() {
        return this.NoSnapshotStorePluginId;
    }

    private Config config() {
        return this.config;
    }

    public ActorRef recoveryPermitter() {
        return this.recoveryPermitter;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultJournalPluginId$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                String configPath = this.config().getString("journal.plugin");
                Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
                this.verifyJournalPluginConfigExists(ConfigFactory.empty(), configPath);
                this.defaultJournalPluginId = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultJournalPluginId;
    }

    private String defaultJournalPluginId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultJournalPluginId$lzycompute() : this.defaultJournalPluginId;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultSnapshotPluginId$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String string;
                String configPath = this.config().getString("snapshot-store.plugin");
                if (Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(configPath)) {
                    this.akka$persistence$Persistence$$log().warning("No default snapshot store configured! To configure a default snapshot-store plugin set the `akka.persistence.snapshot-store.plugin` key. For details see 'reference.conf'");
                    string = this.NoSnapshotStorePluginId();
                } else {
                    void var2_2;
                    this.verifySnapshotPluginConfigExists(ConfigFactory.empty(), configPath);
                    string = var2_2;
                }
                this.defaultSnapshotPluginId = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.NoSnapshotStorePluginId = null;
        return this.defaultSnapshotPluginId;
    }

    private String defaultSnapshotPluginId() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.defaultSnapshotPluginId$lzycompute() : this.defaultSnapshotPluginId;
    }

    private StashOverflowStrategy defaultInternalStashOverflowStrategy$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.defaultInternalStashOverflowStrategy = (StashOverflowStrategy)this.system().dynamicAccess().createInstanceFor(this.config().getString("internal-stash-overflow-strategy"), (Seq)Collections.EmptyImmutableSeq$.MODULE$, ClassTag$.MODULE$.apply(StashOverflowStrategyConfigurator.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.create(this.system().settings().config())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public StashOverflowStrategy defaultInternalStashOverflowStrategy() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.defaultInternalStashOverflowStrategy$lzycompute() : this.defaultInternalStashOverflowStrategy;
    }

    public PersistenceSettings settings() {
        return this.settings;
    }

    private AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId() {
        return this.pluginExtensionId;
    }

    private void verifyJournalPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Journal");
    }

    private void verifySnapshotPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Snapshot store");
    }

    public final EventAdapters adaptersFor(String journalPluginId) {
        return this.adaptersFor(journalPluginId, ConfigFactory.empty());
    }

    public final EventAdapters adaptersFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).adapters();
    }

    public final EventAdapters adaptersFor(ActorRef journalPluginActor) {
        EventAdapters eventAdapters;
        Option option = ((MapLike)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new scala.Serializable(this, journalPluginActor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$1;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ActorRef actorRef = ((PluginHolder)A1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                Object object = !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) ? ((PluginHolder)A1.apply((ActorSystem)this.$outer.system())).adapters() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ExtensionId<PluginHolder> extensionId = x1;
                ActorRef actorRef = ((PluginHolder)extensionId.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                boolean bl = !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$1 = journalPluginActor$1;
            }
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            EventAdapters adapters = (EventAdapters)some.value();
            eventAdapters = adapters;
        } else {
            eventAdapters = IdentityEventAdapters$.MODULE$;
        }
        return eventAdapters;
    }

    public final Config journalConfigFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).config();
    }

    public final Config journalConfigFor$default$2() {
        return ConfigFactory.empty();
    }

    public final Config configFor(ActorRef journalPluginActor) {
        Config conf;
        Option option = ((MapLike)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new scala.Serializable(this, journalPluginActor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$2;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ActorRef actorRef = ((PluginHolder)A1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                Object object = !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) ? ((PluginHolder)A1.apply((ActorSystem)this.$outer.system())).config() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ExtensionId<PluginHolder> extensionId = x1;
                ActorRef actorRef = ((PluginHolder)extensionId.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                boolean bl = !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$2 = journalPluginActor$2;
            }
        });
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin actor ").append(journalPluginActor).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Config config = conf = (Config)some.value();
        return config;
    }

    public final ActorRef journalFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).actor();
    }

    public final Config journalFor$default$2() {
        return ConfigFactory.empty();
    }

    public final ActorRef snapshotStoreFor(String snapshotPluginId, Config snapshotPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(snapshotPluginId) ? this.defaultSnapshotPluginId() : snapshotPluginId;
        this.verifySnapshotPluginConfigExists(snapshotPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.SnapshotStoreFallbackConfigPath(), snapshotPluginConfig).actor();
    }

    public final Config snapshotStoreFor$default$2() {
        return ConfigFactory.empty();
    }

    private PluginHolder pluginHolderFor(String configPath, String fallbackPath, Config additionalConfig) {
        Option option;
        block1: {
            while (true) {
                Map<String, ExtensionId<PluginHolder>> extensionIdMap;
                if ((option = (extensionIdMap = this.pluginExtensionId().get()).get((Object)configPath)) instanceof Some) break block1;
                if (!None$.MODULE$.equals(option)) break;
                PluginHolderExtensionId extensionId = new PluginHolderExtensionId(this, configPath, fallbackPath, additionalConfig);
                this.pluginExtensionId().compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        ExtensionId extensionId = (ExtensionId)some.value();
        PluginHolder pluginHolder = (PluginHolder)extensionId.apply((ActorSystem)this.system());
        return pluginHolder;
    }

    public ActorRef akka$persistence$Persistence$$createPlugin(String configPath, Config pluginConfig) {
        .colon.colon colon2;
        String pluginActorName = configPath;
        String pluginClassName = pluginConfig.getString("class");
        if (Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(pluginClassName)) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Plugin class name must be defined in config property [").append(configPath).append(".class]").toString());
        }
        this.akka$persistence$Persistence$$log().debug(new StringBuilder(16).append("Create plugin: ").append(pluginActorName).append(" ").append(pluginClassName).toString());
        Class pluginClass = (Class)this.system().dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.Any()).get();
        String pluginDispatcherId = pluginConfig.getString("plugin-dispatcher");
        try {
            Reflect$.MODULE$.findConstructor(pluginClass, (Seq)new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$)));
            colon2 = new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$));
        }
        catch (Throwable throwable) {
            .colon.colon colon3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                try {
                    Reflect$.MODULE$.findConstructor(pluginClass, (Seq)new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$));
                    colon3 = new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (option2.isEmpty()) {
                        throw throwable3;
                    }
                    Nil$ nil$ = Nil$.MODULE$;
                    colon3 = nil$;
                }
            } else {
                throw throwable;
            }
            .colon.colon colon4 = colon3;
            colon2 = colon4;
        }
        .colon.colon pluginActorArgs = colon2;
        String x$1 = pluginDispatcherId;
        String x$2 = Deploy$.MODULE$.apply$default$1();
        Config x$3 = Deploy$.MODULE$.apply$default$2();
        RouterConfig x$4 = Deploy$.MODULE$.apply$default$3();
        Scope x$5 = Deploy$.MODULE$.apply$default$4();
        String x$6 = Deploy$.MODULE$.apply$default$6();
        Props pluginActorProps = new Props(new Deploy(x$2, x$3, x$4, x$5, x$1, x$6), pluginClass, (Seq)pluginActorArgs);
        return this.system().systemActorOf(pluginActorProps, pluginActorName);
    }

    public EventAdapters akka$persistence$Persistence$$createAdapters(String configPath, Config additionalConfig) {
        Config pluginConfig = additionalConfig.withFallback((ConfigMergeable)this.system().settings().config()).getConfig(configPath);
        return EventAdapters$.MODULE$.apply(this.system(), pluginConfig);
    }

    public String persistenceId(ActorRef persistentActor) {
        return this.id(persistentActor);
    }

    private String id(ActorRef ref) {
        return ref.path().toStringWithoutAddress();
    }

    public Persistence(ExtendedActorSystem system) {
        this.system = system;
        this.NoSnapshotStorePluginId = "akka.persistence.no-snapshot-store";
        this.config = system.settings().config().getConfig("akka.persistence");
        int maxPermits = this.config().getInt("max-concurrent-recoveries");
        this.recoveryPermitter = system.systemActorOf(RecoveryPermitter$.MODULE$.props(maxPermits), "recoveryPermitter");
        this.settings = new PersistenceSettings(this.config());
        this.pluginExtensionId = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.config().getStringList("journal.auto-start-journals").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.akka$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting journal plugin `").append(id).append("`").toString());
                this.$outer.journalFor(id, this.$outer.journalFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.config().getStringList("snapshot-store.auto-start-snapshot-stores").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.akka$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting snapshot store `").append(id).append("`").toString());
                this.$outer.snapshotStoreFor(id, this.$outer.snapshotStoreFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class PluginHolder
    implements Extension,
    Product,
    scala.Serializable {
        private final ActorRef actor;
        private final EventAdapters adapters;
        private final Config config;

        public ActorRef actor() {
            return this.actor;
        }

        public EventAdapters adapters() {
            return this.adapters;
        }

        public Config config() {
            return this.config;
        }

        public PluginHolder copy(ActorRef actor, EventAdapters adapters, Config config) {
            return new PluginHolder(actor, adapters, config);
        }

        public ActorRef copy$default$1() {
            return this.actor();
        }

        public EventAdapters copy$default$2() {
            return this.adapters();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.actor();
                    break;
                }
                case 1: {
                    object = this.adapters();
                    break;
                }
                case 2: {
                    object = this.config();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PluginHolder;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PluginHolder)) return false;
            boolean bl = true;
            if (!bl) return false;
            PluginHolder pluginHolder = (PluginHolder)x$1;
            ActorRef actorRef = this.actor();
            ActorRef actorRef2 = pluginHolder.actor();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            EventAdapters eventAdapters = this.adapters();
            EventAdapters eventAdapters2 = pluginHolder.adapters();
            if (eventAdapters == null) {
                if (eventAdapters2 != null) {
                    return false;
                }
            } else if (!eventAdapters.equals(eventAdapters2)) return false;
            Config config = this.config();
            Config config2 = pluginHolder.config();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            if (!pluginHolder.canEqual(this)) return false;
            return true;
        }

        public PluginHolder(ActorRef actor, EventAdapters adapters, Config config) {
            this.actor = actor;
            this.adapters = adapters;
            this.config = config;
            Product.$init$((Product)this);
        }
    }

    public class PluginHolderExtensionId
    implements ExtensionId<PluginHolder> {
        private final String configPath;
        private final String fallbackPath;
        private final Config additionalConfig;
        public final /* synthetic */ Persistence $outer;

        public Extension apply(ActorSystem system) {
            return ExtensionId.apply$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension apply(ClassicActorSystemProvider system) {
            return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public Extension get(ActorSystem system) {
            return ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension get(ClassicActorSystemProvider system) {
            return ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public final int hashCode() {
            return ExtensionId.hashCode$((ExtensionId)this);
        }

        public final boolean equals(Object other) {
            return ExtensionId.equals$((ExtensionId)this, (Object)other);
        }

        public PluginHolder createExtension(ExtendedActorSystem system) {
            Config mergedConfig = this.additionalConfig.withFallback((ConfigMergeable)system.settings().config());
            Predef$.MODULE$.require(!Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(this.configPath) && mergedConfig.hasPath(this.configPath), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append($this.configPath).append("'").toString());
            Config config = mergedConfig.getConfig(this.configPath).withFallback((ConfigMergeable)mergedConfig.getConfig(this.fallbackPath));
            ActorRef plugin = this.akka$persistence$Persistence$PluginHolderExtensionId$$$outer().akka$persistence$Persistence$$createPlugin(this.configPath, config);
            EventAdapters adapters = this.akka$persistence$Persistence$PluginHolderExtensionId$$$outer().akka$persistence$Persistence$$createAdapters(this.configPath, mergedConfig);
            return new PluginHolder(plugin, adapters, config);
        }

        public /* synthetic */ Persistence akka$persistence$Persistence$PluginHolderExtensionId$$$outer() {
            return this.$outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath, Config additionalConfig) {
            this.configPath = configPath;
            this.fallbackPath = fallbackPath;
            this.additionalConfig = additionalConfig;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            ExtensionId.$init$((ExtensionId)this);
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath) {
            this($outer, configPath, fallbackPath, ConfigFactory.empty());
        }
    }
}

