/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eq!B\f\u0019\u0011\u0003yb!B\u0011\u0019\u0011\u0003\u0011\u0003\"\u0002\u001d\u0002\t\u0003Q\b\"B>\u0002\t\u0003b\bBB>\u0002\t\u0003\n\u0019\u0001C\u0004\u0002\u000e\u0005!\t%a\u0004\t\u000f\u0005M\u0011\u0001\"\u0011\u0002\u0016\u0019!\u0011\u0005\u0007\u00021\u0011!!tA!A!\u0002\u0013)\u0004\"\u0002\u001d\b\t\u0003I\u0004bB\u001e\b\u0005\u0004%I\u0001\u0010\u0005\u0007\r\u001e\u0001\u000b\u0011B\u001f\t\u000f\u001d;!\u0019!C\u0005\u0011\"1qk\u0002Q\u0001\n%CQ\u0001W\u0004\u0005\u0002eCQ!X\u0004\u0005\nyCQAY\u0004\u0005\u0002\rDQ\u0001[\u0004\u0005\u0002%DQa[\u0004\u0005\u00021DQ\u0001]\u0004\u0005\u0002EDq\u0001^\u0004C\u0002\u0013%a\f\u0003\u0004v\u000f\u0001\u0006Ia\u0018\u0005\u0006m\u001e!\tAX\u0001\u001a\u00072,8\u000f^3s\u00072LWM\u001c;SK\u000e,\u0007\u000f^5p]&\u001cHO\u0003\u0002\u001a5\u000511\r\\5f]RT!a\u0007\u000f\u0002\u000f\rdWo\u001d;fe*\tQ$\u0001\u0003bW.\f7\u0001\u0001\t\u0003A\u0005i\u0011\u0001\u0007\u0002\u001a\u00072,8\u000f^3s\u00072LWM\u001c;SK\u000e,\u0007\u000f^5p]&\u001cHo\u0005\u0003\u0002G%:\bC\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\rE\u0002+[=j\u0011a\u000b\u0006\u0003Yq\tQ!Y2u_JL!AL\u0016\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003A\u001d\u00192aB\u00122!\tQ#'\u0003\u00024W\tIQ\t\u001f;f]NLwN\\\u0001\u0007gf\u001cH/Z7\u0011\u0005)2\u0014BA\u001c,\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u0019a\u0014N\\5u}Q\u0011qF\u000f\u0005\u0006i%\u0001\r!N\u0001\u0007G>tg-[4\u0016\u0003u\u0002\"A\u0010#\u000e\u0003}R!a\u000f!\u000b\u0005\u0005\u0013\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\u000b1aY8n\u0013\t)uH\u0001\u0004D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0011\u0011x\u000e\\3\u0016\u0003%\u00032\u0001\n&M\u0013\tYUE\u0001\u0004PaRLwN\u001c\t\u0003\u001bRs!A\u0014*\u0011\u0005=+S\"\u0001)\u000b\u0005Es\u0012A\u0002\u001fs_>$h(\u0003\u0002TK\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019V%A\u0003s_2,\u0007%\u0001\u0007jgR+'/\\5oCR,G-F\u0001[!\t!3,\u0003\u0002]K\t9!i\\8mK\u0006t\u0017A\u00049vEN+(-T3eS\u0006$xN]\u000b\u0002?B\u0011!\u0006Y\u0005\u0003C.\u0012\u0001\"Q2u_J\u0014VMZ\u0001\u0010e\u0016<\u0017n\u001d;feN+'O^5dKR\u0011Am\u001a\t\u0003I\u0015L!AZ\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006YA\u0001\raX\u0001\u0012k:\u0014XmZ5ti\u0016\u00148+\u001a:wS\u000e,GC\u00013k\u0011\u0015a\u0013\u00031\u0001`\u0003I\u0011XmZ5ti\u0016\u00148+\u001e2tGJL'-\u001a:\u0015\u0007\u0011lw\u000eC\u0003o%\u0001\u0007A*A\u0003u_BL7\rC\u0003-%\u0001\u0007q,\u0001\u000bv]J,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u0004IJ\u001c\b\"\u00028\u0014\u0001\u0004a\u0005\"\u0002\u0017\u0014\u0001\u0004y\u0016\u0001\u0004:fG\u0016\u0004H/[8oSN$\u0018!\u0004:fG\u0016\u0004H/[8oSN$\b%\u0001\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\"A\u000b=\n\u0005e\\#aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#A\u0010\u0002\u0007\u001d,G\u000f\u0006\u00020{\")Ag\u0001a\u0001}B\u0011!f`\u0005\u0004\u0003\u0003Y#aC!di>\u00148+_:uK6$2aLA\u0003\u0011\u0019!D\u00011\u0001\u0002\bA\u0019!&!\u0003\n\u0007\u0005-1F\u0001\u000eDY\u0006\u001c8/[2BGR|'oU=ti\u0016l\u0007K]8wS\u0012,'/\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003\u0003#q!\u0001\t\u0001\u0002\u001f\r\u0014X-\u0019;f\u000bb$XM\\:j_:$2aLA\f\u0011\u0015!d\u00011\u00016\u0001")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) return false;
        return true;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Put x$1 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Remove x$1 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Subscribe x$1 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Unsubscribe x$1 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
        String string = this.config().getString("role");
        Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
        this.role = object;
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String string2 = this.config().getString("use-dispatcher");
            String string3 = "".equals(string2) ? "akka.actor.default-dispatcher" : string2;
            String dispatcher = string3;
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }
}

