/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverUriPool {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverUriPool.class);
    public static final boolean DEFAULT_RANDOMIZE_ENABLED = false;
    private final LinkedList<URI> uris;
    private final Map<String, String> nestedOptions;
    private final AtomicBoolean randomize = new AtomicBoolean(false);

    public FailoverUriPool() {
        this.uris = new LinkedList();
        this.nestedOptions = Collections.emptyMap();
    }

    public FailoverUriPool(List<URI> uris, Map<String, String> nestedOptions) {
        this.uris = new LinkedList();
        this.nestedOptions = nestedOptions != null ? nestedOptions : Collections.emptyMap();
        if (uris != null) {
            for (URI uri : uris) {
                this.add(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            return this.uris.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            return this.uris.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getNext() {
        URI next = null;
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            if (!this.uris.isEmpty()) {
                next = this.uris.removeFirst();
                this.uris.addLast(next);
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected() {
        if (this.isRandomize()) {
            LinkedList<URI> linkedList = this.uris;
            synchronized (linkedList) {
                Collections.shuffle(this.uris);
            }
        }
    }

    public boolean isRandomize() {
        return this.randomize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomize(boolean random) {
        if (this.randomize.compareAndSet(!random, random) && random) {
            LinkedList<URI> linkedList = this.uris;
            synchronized (linkedList) {
                Collections.shuffle(this.uris);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URI uri) {
        if (uri == null) {
            return;
        }
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            if (!this.contains(uri)) {
                if (!this.nestedOptions.isEmpty()) {
                    try {
                        uri = URISupport.applyParameters(uri, this.nestedOptions);
                    }
                    catch (URISyntaxException e) {
                        LOG.debug("Failed to add nested options to uri: {}", (Object)uri);
                    }
                }
                this.uris.add(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<URI> additions) {
        if (additions == null || additions.isEmpty()) {
            return;
        }
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            for (URI uri : additions) {
                this.add(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(URI uri) {
        if (uri == null) {
            return;
        }
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            if (!this.contains(uri)) {
                if (!this.nestedOptions.isEmpty()) {
                    try {
                        uri = URISupport.applyParameters(uri, this.nestedOptions);
                    }
                    catch (URISyntaxException e) {
                        LOG.debug("Failed to add nested options to uri: {}", (Object)uri);
                    }
                }
                this.uris.addFirst(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(URI uri) {
        if (uri == null) {
            return false;
        }
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            for (URI candidate : this.uris) {
                if (!this.compareURIs(uri, candidate)) continue;
                return this.uris.remove(candidate);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            this.uris.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(List<URI> replacements) {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            this.uris.clear();
            this.addAll(replacements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> getList() {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            return new ArrayList<URI>(this.uris);
        }
    }

    public Map<String, String> getNestedOptions() {
        return this.nestedOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedList<URI> linkedList = this.uris;
        synchronized (linkedList) {
            return "URI Pool { " + this.uris + " }";
        }
    }

    private boolean contains(URI newURI) {
        boolean result = false;
        for (URI uri : this.uris) {
            if (!this.compareURIs(newURI, uri)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean compareURIs(URI first, URI second) {
        boolean result;
        block7: {
            result = false;
            if (first == null || second == null) {
                return result;
            }
            if (first.getPort() == second.getPort()) {
                InetAddress firstAddr = null;
                InetAddress secondAddr = null;
                try {
                    firstAddr = InetAddress.getByName(first.getHost());
                    secondAddr = InetAddress.getByName(second.getHost());
                    if (firstAddr.equals(secondAddr)) {
                        result = true;
                    }
                }
                catch (IOException e) {
                    if (firstAddr == null) {
                        LOG.error("Failed to Lookup INetAddress for URI[ " + first + " ] : " + e);
                    } else {
                        LOG.error("Failed to Lookup INetAddress for URI[ " + second + " ] : " + e);
                    }
                    if (!first.getHost().equalsIgnoreCase(second.getHost())) break block7;
                    result = true;
                }
            }
        }
        return result;
    }
}

