/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.actors;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.sharding.ClusterSharding;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardRegion;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActor;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActor$;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorHolder;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorInitializer;
import com.xebialabs.xlrelease.delivery.actors.package$;
import com.xebialabs.xlrelease.delivery.service.DeliveryExecutionService;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@Profile(value={"full"})
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b%\u0003A\u0011\u0001&\t\u000b\u0005\u0004A\u0011\u00022\t\u000f-\u0004!\u0019!C\u0005Y\"1\u0001\u000f\u0001Q\u0001\n5Dq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004|\u0001\u0001\u0006Ia\u001d\u0005\u0006y\u0002!\t! \u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002>\u0001!\t%a\u0010\u0003W\rcWo\u001d;fe\u0016$G)\u001a7jm\u0016\u0014\u0018\u0010\u0015:pG\u0016\u001c8/\u001b8h\u0003\u000e$xN]%oSRL\u0017\r\\5{KJT!\u0001F\u000b\u0002\r\u0005\u001cGo\u001c:t\u0015\t1r#\u0001\u0005eK2Lg/\u001a:z\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t1#\u0003\u0002)'\tAB)\u001a7jm\u0016\u0014\u00180Q2u_JLe.\u001b;jC2L'0\u001a:\u0002\u0013ad'oQ8oM&<\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0018\u0003\u0019\u0019wN\u001c4jO&\u0011q\u0006\f\u0002\n12\u00148i\u001c8gS\u001e\fAb]=ti\u0016l\u0007j\u001c7eKJ\u0004\"A\r\u001b\u000e\u0003MR!\u0001F\f\n\u0005U\u001a$!E!di>\u00148+_:uK6Du\u000e\u001c3fe\u0006yA-\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW\r\u0005\u00029w5\t\u0011H\u0003\u0002;+\u000591/\u001a:wS\u000e,\u0017B\u0001\u001f:\u0005=!U\r\\5wKJL8+\u001a:wS\u000e,\u0017A\u00063fY&4XM]=QCR$XM\u001d8TKJ4\u0018nY3\u0011\u0005az\u0014B\u0001!:\u0005Y!U\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,\u0017\u0001\u00073fY&4XM]=Fq\u0016\u001cW\u000f^5p]N+'O^5dKB\u0011\u0001hQ\u0005\u0003\tf\u0012\u0001\u0004R3mSZ,'/_#yK\u000e,H/[8o'\u0016\u0014h/[2f\u0003M!W\r\\5wKJL\u0018i\u0019;pe\"{G\u000eZ3s!\t1s)\u0003\u0002I'\t\u0019B)\u001a7jm\u0016\u0014\u00180Q2u_JDu\u000e\u001c3fe\u00061A(\u001b8jiz\"ra\u0013'N\u001d>\u0003\u0016\u000b\u0005\u0002'\u0001!)\u0011f\u0002a\u0001U!)\u0001g\u0002a\u0001c!)ag\u0002a\u0001o!)Qh\u0002a\u0001}!)\u0011i\u0002a\u0001\u0005\")Qi\u0002a\u0001\r\"\u0012qa\u0015\t\u0003)~k\u0011!\u0016\u0006\u0003-^\u000b!\"\u00198o_R\fG/[8o\u0015\tA\u0016,A\u0004gC\u000e$xN]=\u000b\u0005i[\u0016!\u00022fC:\u001c(B\u0001/^\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a+\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0007gf\u001cH/Z7\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003!\fA!Y6lC&\u0011!.\u001a\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\bok6\u0014WM](g'\"\f'\u000fZ:\u0016\u00035\u0004\"\u0001\t8\n\u0005=\f#aA%oi\u0006ya.^7cKJ|em\u00155be\u0012\u001c\b%\u0001\ttQ\u0006\u0014H-\u001b8h'\u0016$H/\u001b8hgV\t1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006A1\u000f[1sI&twM\u0003\u0002yO\u000691\r\\;ti\u0016\u0014\u0018B\u0001>v\u0005]\u0019E.^:uKJ\u001c\u0006.\u0019:eS:<7+\u001a;uS:<7/A\ttQ\u0006\u0014H-\u001b8h'\u0016$H/\u001b8hg\u0002\nQc\u001d;beR$U\r\\5wKJL8\u000b[1sI&tw\rF\u0001\u007f!\t!w0C\u0002\u0002\u0002\u0015\u0014\u0001\"Q2u_J\u0014VMZ\u0001\u0012Kb$(/Y2u\t\u0016d\u0017N^3ss&#WCAA\u0004!\u0011\tI!a\u0004\u000f\u0007Q\fY!C\u0002\u0002\u000eU\f1b\u00155be\u0012\u0014VmZ5p]&!\u0011\u0011CA\n\u0005=)\u0005\u0010\u001e:bGR,e\u000e^5us&#'bAA\u0007k\u00061R\r\u001f;sC\u000e$H)\u001a7jm\u0016\u0014\u0018p\u00155be\u0012LE-\u0006\u0002\u0002\u001aA!\u0011\u0011BA\u000e\u0013\u0011\ti\"a\u0005\u0003\u001d\u0015CHO]1diNC\u0017M\u001d3JI\u0006qQ\r\u001f;sC\u000e$8\u000b[1sI&#G\u0003BA\u0012\u0003s\u0001B!!\n\u000249!\u0011qEA\u0018!\r\tI#I\u0007\u0003\u0003WQ1!!\f\u001e\u0003\u0019a$o\\8u}%\u0019\u0011\u0011G\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\t$\t\u0005\b\u0003w\u0001\u0002\u0019AA\u0012\u0003\tIG-\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!!\u0011\u0011\u0007\u0001\n\u0019%C\u0002\u0002F\u0005\u0012A!\u00168ji\":\u0001!!\u0013\u0002X\u0005e\u0003\u0003BA&\u0003'j!!!\u0014\u000b\u0007Y\u000byEC\u0002\u0002Rm\u000bqaY8oi\u0016DH/\u0003\u0003\u0002V\u00055#a\u0002)s_\u001aLG.Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u00037\n#!!\u0018\u0002\t\u0019,H\u000e\u001c\u0015\u0004\u0001\u0005\u0005\u0004\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d4,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u001b\u0002f\tI1i\\7q_:,g\u000e\u001e")
public class ClusteredDeliveryProcessingActorInitializer
implements DeliveryActorInitializer {
    private final ActorSystemHolder systemHolder;
    private final DeliveryService deliveryService;
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryExecutionService deliveryExecutionService;
    private final DeliveryActorHolder deliveryActorHolder;
    private final int numberOfShards;
    private final ClusterShardingSettings shardingSettings;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ClusteredDeliveryProcessingActorInitializer clusteredDeliveryProcessingActorInitializer = this;
        synchronized (clusteredDeliveryProcessingActorInitializer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorSystem system() {
        return this.systemHolder.actorSystem();
    }

    private int numberOfShards() {
        return this.numberOfShards;
    }

    private ClusterShardingSettings shardingSettings() {
        return this.shardingSettings;
    }

    public ActorRef startDeliverySharding() {
        return ((ClusterSharding)ClusterSharding$.MODULE$.apply(this.system())).start("Delivery", DeliveryActor$.MODULE$.props(true, this.deliveryService, this.deliveryPatternService, this.deliveryExecutionService), this.shardingSettings(), this.extractDeliveryId(), this.extractDeliveryShardId());
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractDeliveryId() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DeliveryActor.DeliveryAction) {
                    DeliveryActor.DeliveryAction deliveryAction = (DeliveryActor.DeliveryAction)A1;
                    object = new Tuple2((Object)package$.MODULE$.DeliveryIdExtensions(deliveryAction.deliveryId()).deliveryActorName(), (Object)deliveryAction);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DeliveryActor.DeliveryAction;
                return bl;
            }
        };
    }

    private Function1<Object, String> extractDeliveryShardId() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof DeliveryActor.DeliveryAction) {
                DeliveryActor.DeliveryAction deliveryAction = (DeliveryActor.DeliveryAction)object;
                string = this.extractShardId(deliveryAction.deliveryId());
            } else if (object instanceof ShardRegion.StartEntity) {
                ShardRegion.StartEntity startEntity = (ShardRegion.StartEntity)object;
                String id = startEntity.entityId();
                string = this.extractShardId(id);
            } else {
                throw new MatchError(object);
            }
            return string;
        };
    }

    private String extractShardId(String id) {
        return ((Object)BoxesRunTime.boxToInteger((int)(scala.math.package$.MODULE$.abs(package$.MODULE$.DeliveryIdExtensions(id).deliveryActorName().hashCode()) % this.numberOfShards()))).toString();
    }

    public void initialize() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Initializing clustered delivery processing actor...");
        ActorRef shardRegion = this.startDeliverySharding();
        this.deliveryActorHolder.resolveActorRef(shardRegion);
    }

    @Autowired
    public ClusteredDeliveryProcessingActorInitializer(XlrConfig xlrConfig, ActorSystemHolder systemHolder, DeliveryService deliveryService, DeliveryPatternService deliveryPatternService, DeliveryExecutionService deliveryExecutionService, DeliveryActorHolder deliveryActorHolder) {
        this.systemHolder = systemHolder;
        this.deliveryService = deliveryService;
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryExecutionService = deliveryExecutionService;
        this.deliveryActorHolder = deliveryActorHolder;
        Logging.$init$((Logging)this);
        this.numberOfShards = xlrConfig.sharding().numberOfReleaseShards();
        this.shardingSettings = ClusterShardingSettings$.MODULE$.apply(this.system());
    }
}

