/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationResponse {
    private String redirectUri;
    private String state;
    private String code;
    private OAuth2Error error;

    private OAuth2AuthorizationResponse() {
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public String getCode() {
        return this.code;
    }

    public OAuth2Error getError() {
        return this.error;
    }

    public boolean statusOk() {
        return !this.statusError();
    }

    public boolean statusError() {
        return this.error != null && this.error.getErrorCode() != null;
    }

    public static Builder success(String code) {
        Assert.hasText((String)code, (String)"code cannot be empty");
        return new Builder().code(code);
    }

    public static Builder error(String errorCode) {
        Assert.hasText((String)errorCode, (String)"errorCode cannot be empty");
        return new Builder().errorCode(errorCode);
    }

    public static class Builder {
        private String redirectUri;
        private String state;
        private String code;
        private String errorCode;
        private String errorDescription;
        private String errorUri;

        private Builder() {
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public Builder errorUri(String errorUri) {
            this.errorUri = errorUri;
            return this;
        }

        public OAuth2AuthorizationResponse build() {
            if (StringUtils.hasText((String)this.code) && StringUtils.hasText((String)this.errorCode)) {
                throw new IllegalArgumentException("code and errorCode cannot both be set");
            }
            Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            OAuth2AuthorizationResponse authorizationResponse = new OAuth2AuthorizationResponse();
            authorizationResponse.redirectUri = this.redirectUri;
            authorizationResponse.state = this.state;
            if (StringUtils.hasText((String)this.code)) {
                authorizationResponse.code = this.code;
            } else {
                authorizationResponse.error = new OAuth2Error(this.errorCode, this.errorDescription, this.errorUri);
            }
            return authorizationResponse;
        }
    }
}

