/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001B\u0017/\u0001]B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"AA\u000f\u0001B\u0001B\u0003%Q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u0013Cq!!(\u0001\t\u0003\ty\nC\u0005\u0002(\u0002\t\n\u0011\"\u0001\u0002\n\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006\"CA^\u0001E\u0005I\u0011AA_\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007D\u0011\"!:\u0001#\u0003%\t!a:\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011%\u0011)\u0005AI\u0001\n\u0003\u00119\u0005C\u0004\u0003L\u0001!\tA!\u0014\t\u0013\tm\u0003!%A\u0005\u0002\u0005\u001d\bb\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005;\u0002A\u0011\u0001B4\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\b\u0002!IA!#\t\u000f\t-\u0006\u0001\"\u0003\u0003.\"9!1\u0017\u0001\u0005\n\tU\u0006b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001bDqAa;\u0001\t\u0013\u0011i\u000fC\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\rm\u0001\u0001\"\u0003\u0004\u001e!911\u0005\u0001\u0005\n\r\u0015\u0002bBB\u0015\u0001\u0011%11\u0006\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u000b\u0005=\u0002\u0014aB:feZL7-\u001a\u0006\u0003cI\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M\"\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0014aA2p[\u000e\u00011c\u0001\u00019}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000bMdg\r\u000e6\u000b\u0003\r\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u000b\u0002\u0013q\u0001T8hO&tw-A\u0004g_2$WM]:\u0011\u0005![U\"A%\u000b\u0005)\u0003\u0014A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A*\u0013\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pef\f1\u0002^3b[N+'O^5dKB\u0011q\nU\u0007\u0002]%\u0011\u0011K\f\u0002\f)\u0016\fWnU3sm&\u001cW-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"\u0001\u0013+\n\u0005UK%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006YA/Y:l'\u0016\u0014h/[2f!\ty\u0005,\u0003\u0002Z]\tYA+Y:l'\u0016\u0014h/[2f\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002I9&\u0011Q,\u0013\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\f1bY5JIN+'O^5dKB\u0011q\nY\u0005\u0003C:\u00121bQ5JIN+'O^5dK\u0006!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"a\u00143\n\u0005\u0015t#\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\bC\u00015l\u001b\u0005I'B\u000161\u0003!\u0019XmY;sSRL\u0018B\u00017j\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\tKZ,g\u000e\u001e\"vgB\u0011qN]\u0007\u0002a*\u0011\u0011\u000fM\u0001\u0007KZ,g\u000e^:\n\u0005M\u0004(!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003\u001fZL!a\u001e\u0018\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\t{wrlhp`A\u0001\u0003\u0007\t)!a\u0002\u0002\nA\u0011q\n\u0001\u0005\u0006\r.\u0001\ra\u0012\u0005\u0006\u001b.\u0001\rA\u0014\u0005\u0006%.\u0001\ra\u0015\u0005\u0006-.\u0001\ra\u0016\u0005\u00065.\u0001\ra\u0017\u0005\u0006=.\u0001\ra\u0018\u0005\u0006E.\u0001\ra\u0019\u0005\u0006M.\u0001\ra\u001a\u0005\u0006[.\u0001\rA\u001c\u0005\u0006i.\u0001\r!^\u0001\u0012G\",7m\u001b$pY\u0012,'/\u0012=jgR\u001cH\u0003BA\b\u0003+\u00012!OA\t\u0013\r\t\u0019B\u000f\u0002\u0005+:LG\u000fC\u0004\u0002\u00181\u0001\r!!\u0007\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\u0004B!a\u0007\u0002*9!\u0011QDA\u0013!\r\tyBO\u0007\u0003\u0003CQ1!a\t7\u0003\u0019a$o\\8u}%\u0019\u0011q\u0005\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9C\u000f\u0015\u0004\u0019\u0005E\u0002\u0003BA\u001a\u0003\u0003j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u001e\u0003{\tq!\\3ue&\u001c7OC\u0002\u0002@Q\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u0007\n)DA\u0003US6,G-\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003\u0013\ny\u0005E\u0002:\u0003\u0017J1!!\u0014;\u0005\u001d\u0011un\u001c7fC:Dq!a\u0006\u000e\u0001\u0004\tI\u0002K\u0002\u000e\u0003c\t\u0001bZ3u)&$H.\u001a\u000b\u0005\u00033\t9\u0006C\u0004\u0002\u00189\u0001\r!!\u0007)\u00079\t\t$\u0001\u0005gS:$')_%e)\u0019\ty&a\u001c\u0002rA!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014A\u00024pY\u0012,'OC\u0002\u0002jA\na\u0001Z8nC&t\u0017\u0002BA7\u0003G\u0012aAR8mI\u0016\u0014\bbBA\f\u001f\u0001\u0007\u0011\u0011\u0004\u0005\n\u0003gz\u0001\u0013!a\u0001\u0003k\nQ\u0001Z3qi\"\u0004B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003mC:<'BAA@\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0015\u0011\u0010\u0002\b\u0013:$XmZ3sQ\ry\u0011\u0011G\u0001\u0013M&tGMQ=JI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\f*\"\u0011QOAGW\t\ty\t\u0005\u0003\u0002\u0012\u0006eUBAAJ\u0015\u0011\t)*a&\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cu%!\u00111TAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$b!a\u0018\u0002\"\u0006\r\u0006bBA\f#\u0001\u0007\u0011\u0011\u0004\u0005\n\u0003g\n\u0002\u0013!a\u0001\u0003kB3!EA\u0019\u0003\u00052\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133\u0003)1\u0017N\u001c3CsB\u000bG\u000f\u001b\u000b\u0007\u0003?\ni+!-\t\u000f\u0005=6\u00031\u0001\u0002\u001a\u0005!\u0001/\u0019;i\u0011%\t\u0019h\u0005I\u0001\u0002\u0004\t\u0019\fE\u0002:\u0003kK1!a.;\u0005\rIe\u000e\u001e\u0015\u0004'\u0005E\u0012\u0001\u00064j]\u0012\u0014\u0015\u0010U1uQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@*\"\u00111WAG\u0003Ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:t)!\t)-!5\u0002V\u0006}\u0007CBAd\u0003\u001b\fy&\u0004\u0002\u0002J*!\u00111ZA?\u0003\u0011)H/\u001b7\n\t\u0005=\u0017\u0011\u001a\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002TV\u0001\r!!\u0007\u0002\u0011A\f'/\u001a8u\u0013\u0012Dq!a6\u0016\u0001\u0004\tI.\u0001\u0003qC\u001e,\u0007c\u0001%\u0002\\&\u0019\u0011Q\\%\u0003\tA\u000bw-\u001a\u0005\n\u0003C,\u0002\u0013!a\u0001\u0003\u0013\nq\u0003Z3d_J\fG/Z,ji\"\u0004VM]7jgNLwN\\:)\u0007U\t\t$A\u000fmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tIO\u000b\u0003\u0002J\u00055\u0015\u0001B7pm\u0016$b!a\u0018\u0002p\u0006E\bbBA\f/\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003g<\u0002\u0019AA\r\u0003-qWm\u001e)be\u0016tG/\u00133)\u0007]\t\t$\u0001\u0004sK:\fW.\u001a\u000b\u0007\u0003?\nY0!@\t\u000f\u0005]\u0001\u00041\u0001\u0002\u001a!9\u0011q \rA\u0002\u0005e\u0011a\u00028fo:\u000bW.\u001a\u0015\u00041\u0005E\u0012aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\r\t\u001d!\u0011\u0003B\n!\u0019\t9-!4\u0003\nA!!1\u0002B\u0007\u001b\t\t9'\u0003\u0003\u0003\u0010\u0005\u001d$a\u0002*fY\u0016\f7/\u001a\u0005\b\u0003/I\u0002\u0019AA\r\u0011\u001d\t9.\u0007a\u0001\u00033D3!GA\u0019\u00039\u0019X-\u0019:dQJ+G.Z1tKN$\u0002Ba\u0007\u0003(\t%\"\u0011\t\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0019\u0002\rM,\u0017M]2i\u0013\u0011\u0011)Ca\b\u0003'I+G.Z1tKN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\u0005]!\u00041\u0001\u0002\u001a!9!1\u0006\u000eA\u0002\t5\u0012a\u00024jYR,'o\u001d\t\u0005\u0005_\u0011i$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u00151wN]7t\u0015\u0011\u00119D!\u000f\u0002\u0005Y\f$b\u0001B\u001ea\u0005\u0019\u0011\r]5\n\t\t}\"\u0011\u0007\u0002\u0010%\u0016dW-Y:fg\u001aKG\u000e^3sg\"I\u0011q\u001b\u000e\u0011\u0002\u0003\u0007\u0011\u0011\u001c\u0015\u00045\u0005E\u0012\u0001G:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\n\u0016\u0005\u00033\fi)\u0001\u0007n_Z,G+Z7qY\u0006$X\r\u0006\u0005\u0002\u001a\t=#\u0011\u000bB+\u0011\u001d\t9\u0002\ba\u0001\u00033AqAa\u0015\u001d\u0001\u0004\tI\"\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012D\u0011Ba\u0016\u001d!\u0003\u0005\r!!\u0013\u0002!MDw.\u001e7e\u001b\u0016\u0014x-\u001a+fC6\u001c\bf\u0001\u000f\u00022\u00051Rn\u001c<f)\u0016l\u0007\u000f\\1uK\u0012\"WMZ1vYR$3'\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003?\u0012\tGa\u0019\t\u000f\u0005Mg\u00041\u0001\u0002\u001a!9\u0011Q\r\u0010A\u0002\u0005}\u0003f\u0001\u0010\u00022QA\u0011q\fB5\u0005W\u0012i\u0007C\u0004\u0002T~\u0001\r!!\u0007\t\u000f\u0005\u0015t\u00041\u0001\u0002`!9!qN\u0010A\u0002\u0005%\u0013AE2sK\u0006$X\rR3gCVdG\u000fV3b[ND3aHA\u0019\u0003\u0019!W\r\\3uKR!\u0011q\u0002B<\u0011\u001d\t9\u0002\ta\u0001\u00033A3\u0001IA\u0019\u0003=\t'o\u00195jm\u0016|%\u000fR3mKR,GCBA\b\u0005\u007f\u0012\u0019\tC\u0004\u0003\u0002\u0006\u0002\r!a-\u0002\u0013\u0019|G\u000eZ3s+&$\u0007b\u0002BCC\u0001\u0007\u0011\u0011D\u0001\ne\u0016dW-Y:f\u0013\u0012\f!\"\\3sO\u0016$V-Y7t)!\tyAa#\u0003\u000e\n=\u0005bBA\fE\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005'\u0012\u0003\u0019AA\r\u0011\u001d\u0011\tJ\ta\u0001\u0005'\u000bQ\u0002^3na2\fG/\u001a+fC6\u001c\bC\u0002BK\u0005?\u0013)K\u0004\u0003\u0003\u0018\nme\u0002BA\u0010\u00053K\u0011aO\u0005\u0004\u0005;S\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005C\u0013\u0019KA\u0002TKFT1A!(;!\u0011\u0011YAa*\n\t\t%\u0016q\r\u0002\u0005)\u0016\fW.\u0001\u0007sKBd\u0017mY3UK\u0006l7\u000f\u0006\u0004\u0002\u0010\t=&\u0011\u0017\u0005\b\u0003/\u0019\u0003\u0019AA\r\u0011\u001d\u0011\u0019f\ta\u0001\u00033\t1$\\3sO\u0016$V-\u001c9mCR,\u0017I\u001c3G_2$WM\u001d+fC6\u001cHC\u0002BJ\u0005o\u0013Y\fC\u0004\u0003:\u0012\u0002\rAa%\u0002\u0017\u0019|G\u000eZ3s)\u0016\fWn\u001d\u0005\b\u0005##\u0003\u0019\u0001BJ\u00035\u0011Xm]3u)\u0006\u001c8\u000eV3b[R!\u0011q\u0002Ba\u0011\u001d\u0011\u0019&\na\u0001\u00033\tad\u0019:fCR,G)\u001a4bk2$H+Z1ng\u001a{'\u000f\u00165f\r>dG-\u001a:\u0015\r\u0005=!q\u0019Be\u0011\u001d\t)G\na\u0001\u0003?Bq!a5'\u0001\u0004\tI\"A\u0010hKRtuN\\%oQ\u0016\u0014\u0018\u000e^3e\r>dG-\u001a:SK\u001a,'/\u001a8dKN$bAa4\u0003f\n\u001d\bC\u0002Bi\u00057\u0014y.\u0004\u0002\u0003T*!!Q\u001bBl\u0003\u001diW\u000f^1cY\u0016T1A!7;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005;\u0014\u0019NA\u0002TKR\u0004BAa\u0003\u0003b&!!1]A4\u0005E\u0011\u0015m]3D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003/9\u0003\u0019AA\r\u0011\u001d\u0011Io\na\u0001\u00033\t1B\\3xM>dG-\u001a:JI\u0006)2\r[3dW\u001a{G\u000eZ3s\u0007\u0006t')Z'pm\u0016$G\u0003CA\b\u0005_\u0014\tPa?\t\u000f\u0005]\u0001\u00061\u0001\u0002\u001a!9!1\u001f\u0015A\u0002\tU\u0018!\u00058fo\u001a|G\u000eZ3s\u0013\u0012|\u0005\u000f^5p]B)\u0011Ha>\u0002\u001a%\u0019!\u0011 \u001e\u0003\r=\u0003H/[8o\u0011\u001d\u0011i\u0010\u000ba\u0001\u00033\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002\u001b\r\u0014X-\u0019;f\t\u0016$\u0018-\u001b7t)!\u0019\u0019aa\u0002\u0004\u000e\rE\u0001\u0003BA<\u0007\u000bIA!a\u000b\u0002z!91\u0011B\u0015A\u0002\r-\u0011AD1di&4XMU3mK\u0006\u001cXm\u001d\t\u0007\u0005+\u0013yJ!\u0003\t\u000f\r=\u0011\u00061\u0001\u0004\f\u0005A\u0012-\u001e;p'R\f'\u000f\u001e)f]\u0012Lgn\u001a*fY\u0016\f7/Z:\t\u000f\rM\u0011\u00061\u0001\u0004\u0016\u0005Y\u0011N\u001c<bY&$'+\u001a4t!\u0019\u00199b!\u0007\u0003`6\u0011!q[\u0005\u0005\u0005;\u00149.A\fdQ\u0016\u001c7\u000eV3na2\fG/Z\"b]\n+Wj\u001c<fIR1\u0011qBB\u0010\u0007CAqAa\u0015+\u0001\u0004\tI\u0002C\u0004\u0002\u0018)\u0002\r!!\u0007\u0002%\u001d,GOU;o]&twMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0007\u0017\u00199\u0003C\u0004\u0002\u0018-\u0002\r!!\u0007\u00027\u001d,G/Q;u_N#\u0018M\u001d;QK:$\u0017N\\4SK2,\u0017m]3t)\u0011\u0019Ya!\f\t\u000f\u0005]A\u00061\u0001\u0002\u001a\u0001")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringBuilder(23).append("Folder ").append(Ids.ROOT_FOLDER_ID).append(" cannot be found").toString(), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringBuilder(1).append(folderId).append("/").append(Ids.getName((String)templateId)).toString();
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Attempted to move template ").append(templateId).append(" to same folder ").append(folderId).append(". Will be ignored.").toString());
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)folder.getId())).toString());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Creating folder ").append(folder.getTitle()).append(" with id ").append(folder.getId()).toString());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        this.eventBus.publish((XLReleaseEvent)new FolderCreatedEvent(folder));
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
                return saved;
            }
        }
        this.eventBus.publish((XLReleaseEvent)new TeamsUpdatedEvent(folder.getId()));
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleting folder ").append(folderId).toString());
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("archiveOrDelete(").append(folderUid).append(", ").append(releaseId).append("): status=").append(status).append(" [inactive? ").append(status.isInactive()).append("]").toString());
        if (this.releaseRepository.getStatus(releaseId).isInactive()) {
            if (!this.archivingService.existsPreArchived(releaseId)) {
                Release release = this.releaseRepository.findById(releaseId);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("release loaded: ").append(release).toString());
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("archiveRelease(").append(releaseId).append(")").toString());
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("deleteRelease(").append(releaseId).append(")").toString());
            this.releaseRepository.delete(releaseId);
        }
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getFolderPermissions()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getReleasePermissions()).asScala()).union((GenSeq)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getTriggerPermissions()).asScala(), Buffer$.MODULE$.canBuildFrom())).union((GenSeq)new .colon.colon((Object)XLReleasePermissions.VIEW_FOLDER.getPermissionName(), (List)Nil$.MODULE$), Buffer$.MODULE$.canBuildFrom());
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)folderOwner, (List)new .colon.colon((Object)templateOwner, (List)new .colon.colon((Object)releaseAdmin, (List)Nil$.MODULE$)))).asJava());
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        scala.collection.mutable.Seq releases = (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Tried to ").append(operation).append(" folder ").append(folderId).append(", which has active releases ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(" or pending releases with auto start option enabled: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringBuilder(62).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain ").append(details).toString(), new Object[0]);
        }
    }

    private String createDetails(Seq<Release> activeReleases, Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = new StringBuilder(17).append(details).append("active releases: ").append(((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString();
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = new StringBuilder(34).append(details).append("pending releases with auto start: ").append(((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString();
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = new StringBuilder(66).append(details).append("configuration references not inherited by the destination folder: ").append(((TraversableOnce)invalidRefs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), scala.collection.Set$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")).toString();
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), Set$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, x$4))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$7, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$7) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }
}

