/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.DeadLetterSuppression;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterHeartbeatSenderState;
import akka.cluster.ClusterMessage;
import akka.cluster.HeartbeatNodeRing;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import akka.remote.HeartbeatMessage;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]va\u0002@\u0000\u0011\u0003y\u0018q\u0001\u0004\t\u0003\u0017y\b\u0012A@\u0002\u000e!9\u00111D\u0001\u0005\u0002\u0005}aABA\u0011\u0003\t\u000b\u0019\u0003\u0003\u0006\u0002P\r\u0011)\u001a!C\u0001\u0003#B!\"!\u0017\u0004\u0005#\u0005\u000b\u0011BA*\u0011)\tYf\u0001BK\u0002\u0013\u0005\u0011Q\f\u0005\u000b\u0003K\u001a!\u0011#Q\u0001\n\u0005}\u0003BCA4\u0007\tU\r\u0011\"\u0001\u0002^!Q\u0011\u0011N\u0002\u0003\u0012\u0003\u0006I!a\u0018\t\u000f\u0005m1\u0001\"\u0001\u0002l!I\u0011qO\u0002\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0003\u001b\u0011\u0013!C\u0001\u0003\u0007C\u0011\"!'\u0004#\u0003%\t!a'\t\u0013\u0005}5!%A\u0005\u0002\u0005m\u0005\"CAQ\u0007\u0005\u0005I\u0011IAR\u0011%\t)lAA\u0001\n\u0003\t9\fC\u0005\u0002@\u000e\t\t\u0011\"\u0001\u0002B\"I\u0011QZ\u0002\u0002\u0002\u0013\u0005\u0013q\u001a\u0005\n\u0003;\u001c\u0011\u0011!C\u0001\u0003?D\u0011\"!;\u0004\u0003\u0003%\t%a;\t\u0013\u000558!!A\u0005B\u0005=\b\"CAy\u0007\u0005\u0005I\u0011IAz\u000f%\t90AA\u0001\u0012\u0003\tIPB\u0005\u0002\"\u0005\t\t\u0011#\u0001\u0002|\"9\u00111\u0004\r\u0005\u0002\t%\u0001\"CAw1\u0005\u0005IQIAx\u0011%\u0011Y\u0001GA\u0001\n\u0003\u0013i\u0001C\u0005\u0003\u0016a\t\t\u0011\"!\u0003\u0018!I!\u0011\u0006\r\u0002\u0002\u0013%!1\u0006\u0004\u0007\u0005g\t!I!\u000e\t\u0015\u0005=cD!f\u0001\n\u0003\u00119\u0004\u0003\u0006\u0002Zy\u0011\t\u0012)A\u0005\u0005sA!\"a\u0017\u001f\u0005+\u0007I\u0011AA/\u0011)\t)G\bB\tB\u0003%\u0011q\f\u0005\u000b\u0003Or\"Q3A\u0005\u0002\u0005u\u0003BCA5=\tE\t\u0015!\u0003\u0002`!9\u00111\u0004\u0010\u0005\u0002\t}\u0002\"CA<=\u0005\u0005I\u0011\u0001B%\u0011%\t\tIHI\u0001\n\u0003\u0011\t\u0006C\u0005\u0002\u001az\t\n\u0011\"\u0001\u0002\u001c\"I\u0011q\u0014\u0010\u0012\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003Cs\u0012\u0011!C!\u0003GC\u0011\"!.\u001f\u0003\u0003%\t!a.\t\u0013\u0005}f$!A\u0005\u0002\tU\u0003\"CAg=\u0005\u0005I\u0011IAh\u0011%\tiNHA\u0001\n\u0003\u0011I\u0006C\u0005\u0002jz\t\t\u0011\"\u0011\u0002l\"I\u0011Q\u001e\u0010\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003ct\u0012\u0011!C!\u0005;:\u0011B!\u0019\u0002\u0003\u0003E\tAa\u0019\u0007\u0013\tM\u0012!!A\t\u0002\t\u0015\u0004bBA\u000eg\u0011\u0005!\u0011\u000e\u0005\n\u0003[\u001c\u0014\u0011!C#\u0003_D\u0011Ba\u00034\u0003\u0003%\tIa\u001b\t\u0013\tU1'!A\u0005\u0002\nM\u0004\"\u0003B\u0015g\u0005\u0005I\u0011\u0002B\u0016\u000f\u001d\u0011Y(\u0001EA\u0005{2qAa \u0002\u0011\u0003\u0013\t\tC\u0004\u0002\u001ci\"\tAa!\t\u0013\u0005\u0005&(!A\u0005B\u0005\r\u0006\"CA[u\u0005\u0005I\u0011AA\\\u0011%\tyLOA\u0001\n\u0003\u0011)\tC\u0005\u0002Nj\n\t\u0011\"\u0011\u0002P\"I\u0011Q\u001c\u001e\u0002\u0002\u0013\u0005!\u0011\u0012\u0005\n\u0003ST\u0014\u0011!C!\u0003WD\u0011\"!<;\u0003\u0003%\t%a<\t\u0013\t%\"(!A\u0005\n\t-bA\u0002BG\u0003\t\u0013y\t\u0003\u0006\u0002P\u0011\u0013)\u001a!C\u0001\u0005oA!\"!\u0017E\u0005#\u0005\u000b\u0011\u0002B\u001d\u0011\u001d\tY\u0002\u0012C\u0001\u0005#C\u0011\"a\u001eE\u0003\u0003%\tAa&\t\u0013\u0005\u0005E)%A\u0005\u0002\tE\u0003\"CAQ\t\u0006\u0005I\u0011IAR\u0011%\t)\fRA\u0001\n\u0003\t9\fC\u0005\u0002@\u0012\u000b\t\u0011\"\u0001\u0003\u001c\"I\u0011Q\u001a#\u0002\u0002\u0013\u0005\u0013q\u001a\u0005\n\u0003;$\u0015\u0011!C\u0001\u0005?C\u0011\"!;E\u0003\u0003%\t%a;\t\u0013\u00055H)!A\u0005B\u0005=\b\"CAy\t\u0006\u0005I\u0011\tBR\u000f%\u00119+AA\u0001\u0012\u0003\u0011IKB\u0005\u0003\u000e\u0006\t\t\u0011#\u0001\u0003,\"9\u00111D*\u0005\u0002\tM\u0006\"CAw'\u0006\u0005IQIAx\u0011%\u0011YaUA\u0001\n\u0003\u0013)\fC\u0005\u0003\u0016M\u000b\t\u0011\"!\u0003:\"I!\u0011F*\u0002\u0002\u0013%!1\u0006\u0004\b\u0003\u0017y\ba B`\u0011\u001d\tY\"\u0017C\u0001\u0005\u001bD\u0011\"!\u0001Z\u0005\u0004%\tA!5\t\u0011\te\u0017\f)A\u0005\u0005'D\u0011Ba7Z\u0005\u0004%\tA!8\t\u0011\t}\u0017\f)A\u0005\u0003CD\u0011B!9Z\u0005\u0004%\tAa9\t\u0011\tE\u0018\f)A\u0005\u0005KD\u0011\"a\u0017Z\u0001\u0004%\t!a.\t\u0013\tM\u0018\f1A\u0005\u0002\tU\b\u0002CA33\u0002\u0006K!!/\t\u000f\t}\u0018\f\"\u0001\u0004\u0002!I1qA-C\u0002\u0013\u00051\u0011\u0002\u0005\t\u0007#I\u0006\u0015!\u0003\u0004\f!I11C-A\u0002\u0013\u00051Q\u0003\u0005\n\u0007;I\u0006\u0019!C\u0001\u0007?A\u0001ba\tZA\u0003&1q\u0003\u0005\n\u0007KI&\u0019!C\u0001\u0007OA\u0001ba\fZA\u0003%1\u0011\u0006\u0005\n\u0007cI\u0006\u0019!C\u0005\u0003;B\u0011ba\rZ\u0001\u0004%Ia!\u000e\t\u0011\re\u0012\f)Q\u0005\u0003?Bqaa\u000fZ\t\u0003\u001ai\u0004C\u0004\u0004@e#\te!\u0010\t\u000f\r\u0005\u0013\f\"\u0001\u0004D!91qJ-\u0005\u0002\rE\u0003bBB13\u0012\u00051\u0011\u000b\u0005\b\u0007GJF\u0011AB)\u0011\u001d\u0019)'\u0017C\u0001\u0007OBqa!#Z\t\u0003\u0019Y\tC\u0004\u0004\u0012f#\taa%\t\u000f\r]\u0015\f\"\u0001\u0004\u001a\"91QT-\u0005\u0002\r}\u0005bBBR3\u0012\u00051Q\b\u0005\b\u0007KKF\u0011BB\u001f\u0011\u001d\u00199+\u0017C\u0001\u0007SCqa!-Z\t\u0003\u0019\u0019,\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s\u0015\u0011\t\t!a\u0001\u0002\u000f\rdWo\u001d;fe*\u0011\u0011QA\u0001\u0005C.\\\u0017\rE\u0002\u0002\n\u0005i\u0011a \u0002\u0017\u00072,8\u000f^3s\u0011\u0016\f'\u000f\u001e2fCR\u001cVM\u001c3feN\u0019\u0011!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q!!!\u0006\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005e\u00111\u0003\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\"!a\u0002\u0003\u0013!+\u0017M\u001d;cK\u0006$8#D\u0002\u0002\u0010\u0005\u0015\u00121FA\u001c\u0003\u0007\nI\u0005\u0005\u0003\u0002\n\u0005\u001d\u0012bAA\u0015\u007f\nq1\t\\;ti\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u00121A\u0001\u0007e\u0016lw\u000e^3\n\t\u0005U\u0012q\u0006\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRlUm]:bO\u0016\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0005\u0003{\t\u0019!A\u0003bGR|'/\u0003\u0003\u0002B\u0005m\"!\u0006#fC\u0012dU\r\u001e;feN+\b\u000f\u001d:fgNLwN\u001c\t\u0005\u0003#\t)%\u0003\u0003\u0002H\u0005M!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003#\tY%\u0003\u0003\u0002N\u0005M!\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00024s_6,\"!a\u0015\u0011\t\u0005e\u0012QK\u0005\u0005\u0003/\nYDA\u0004BI\u0012\u0014Xm]:\u0002\u000b\u0019\u0014x.\u001c\u0011\u0002\u0015M,\u0017/^3oG\u0016t%/\u0006\u0002\u0002`A!\u0011\u0011CA1\u0013\u0011\t\u0019'a\u0005\u0003\t1{gnZ\u0001\fg\u0016\fX/\u001a8dK:\u0013\b%A\tde\u0016\fG/[8o)&lWMT1o_N\f!c\u0019:fCRLwN\u001c+j[\u0016t\u0015M\\8tAQA\u0011QNA9\u0003g\n)\bE\u0002\u0002p\ri\u0011!\u0001\u0005\b\u0003\u001fR\u0001\u0019AA*\u0011\u001d\tYF\u0003a\u0001\u0003?Bq!a\u001a\u000b\u0001\u0004\ty&\u0001\u0003d_BLH\u0003CA7\u0003w\ni(a \t\u0013\u0005=3\u0002%AA\u0002\u0005M\u0003\"CA.\u0017A\u0005\t\u0019AA0\u0011%\t9g\u0003I\u0001\u0002\u0004\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015%\u0006BA*\u0003\u000f[#!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0003'\u000b\u0019\"\u0001\u0006b]:|G/\u0019;j_:LA!a&\u0002\u000e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0014\u0016\u0005\u0003?\n9)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\t1\fgn\u001a\u0006\u0003\u0003_\u000bAA[1wC&!\u00111WAU\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0018\t\u0005\u0003#\tY,\u0003\u0003\u0002>\u0006M!aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAb\u0003\u0013\u0004B!!\u0005\u0002F&!\u0011qYA\n\u0005\r\te.\u001f\u0005\n\u0003\u0017\f\u0012\u0011!a\u0001\u0003s\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAi!\u0019\t\u0019.!7\u0002D6\u0011\u0011Q\u001b\u0006\u0005\u0003/\f\u0019\"\u0001\u0006d_2dWm\u0019;j_:LA!a7\u0002V\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t/a:\u0011\t\u0005E\u00111]\u0005\u0005\u0003K\f\u0019BA\u0004C_>dW-\u00198\t\u0013\u0005-7#!AA\u0002\u0005\r\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002b\u0006U\b\"CAf-\u0005\u0005\t\u0019AAb\u0003%AU-\u0019:uE\u0016\fG\u000fE\u0002\u0002pa\u0019R\u0001GA\u007f\u0003\u0013\u0002B\"a@\u0003\u0006\u0005M\u0013qLA0\u0003[j!A!\u0001\u000b\t\t\r\u00111C\u0001\beVtG/[7f\u0013\u0011\u00119A!\u0001\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002z\u0006)\u0011\r\u001d9msRA\u0011Q\u000eB\b\u0005#\u0011\u0019\u0002C\u0004\u0002Pm\u0001\r!a\u0015\t\u000f\u0005m3\u00041\u0001\u0002`!9\u0011qM\u000eA\u0002\u0005}\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u00053\u0011)\u0003\u0005\u0004\u0002\u0012\tm!qD\u0005\u0005\u0005;\t\u0019B\u0001\u0004PaRLwN\u001c\t\u000b\u0003#\u0011\t#a\u0015\u0002`\u0005}\u0013\u0002\u0002B\u0012\u0003'\u0011a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u00149\u0005\u0005\t\u0019AA7\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003.A!\u0011q\u0015B\u0018\u0013\u0011\u0011\t$!+\u0003\r=\u0013'.Z2u\u00051AU-\u0019:uE\u0016\fGOU:q'5q\u0012qBA\u0013\u0003W\t9$a\u0011\u0002JU\u0011!\u0011\b\t\u0005\u0003\u0013\u0011Y$C\u0002\u0003>}\u0014Q\"\u00168jcV,\u0017\t\u001a3sKN\u001cH\u0003\u0003B!\u0005\u0007\u0012)Ea\u0012\u0011\u0007\u0005=d\u0004C\u0004\u0002P\u0015\u0002\rA!\u000f\t\u000f\u0005mS\u00051\u0001\u0002`!9\u0011qM\u0013A\u0002\u0005}C\u0003\u0003B!\u0005\u0017\u0012iEa\u0014\t\u0013\u0005=c\u0005%AA\u0002\te\u0002\"CA.MA\u0005\t\u0019AA0\u0011%\t9G\nI\u0001\u0002\u0004\ty&\u0006\u0002\u0003T)\"!\u0011HAD)\u0011\t\u0019Ma\u0016\t\u0013\u0005-G&!AA\u0002\u0005eF\u0003BAq\u00057B\u0011\"a3/\u0003\u0003\u0005\r!a1\u0015\t\u0005\u0005(q\f\u0005\n\u0003\u0017\f\u0014\u0011!a\u0001\u0003\u0007\fA\u0002S3beR\u0014W-\u0019;SgB\u00042!a\u001c4'\u0015\u0019$qMA%!1\tyP!\u0002\u0003:\u0005}\u0013q\fB!)\t\u0011\u0019\u0007\u0006\u0005\u0003B\t5$q\u000eB9\u0011\u001d\tyE\u000ea\u0001\u0005sAq!a\u00177\u0001\u0004\ty\u0006C\u0004\u0002hY\u0002\r!a\u0018\u0015\t\tU$\u0011\u0010\t\u0007\u0003#\u0011YBa\u001e\u0011\u0015\u0005E!\u0011\u0005B\u001d\u0003?\ny\u0006C\u0005\u0003(]\n\t\u00111\u0001\u0003B\u0005i\u0001*Z1si\n,\u0017\r\u001e+jG.\u00042!a\u001c;\u00055AU-\u0019:uE\u0016\fG\u000fV5dWN9!(a\u0004\u0002D\u0005%CC\u0001B?)\u0011\t\u0019Ma\"\t\u0013\u0005-g(!AA\u0002\u0005eF\u0003BAq\u0005\u0017C\u0011\"a3A\u0003\u0003\u0005\r!a1\u0003-\u0015C\b/Z2uK\u00124\u0015N]:u\u0011\u0016\f'\u000f\u001e2fCR\u001cr\u0001RA\b\u0003\u0007\nI\u0005\u0006\u0003\u0003\u0014\nU\u0005cAA8\t\"9\u0011qJ$A\u0002\teB\u0003\u0002BJ\u00053C\u0011\"a\u0014I!\u0003\u0005\rA!\u000f\u0015\t\u0005\r'Q\u0014\u0005\n\u0003\u0017d\u0015\u0011!a\u0001\u0003s#B!!9\u0003\"\"I\u00111\u001a(\u0002\u0002\u0003\u0007\u00111\u0019\u000b\u0005\u0003C\u0014)\u000bC\u0005\u0002LF\u000b\t\u00111\u0001\u0002D\u00061R\t\u001f9fGR,GMR5sgRDU-\u0019:uE\u0016\fG\u000fE\u0002\u0002pM\u001bRa\u0015BW\u0003\u0013\u0002\u0002\"a@\u00030\ne\"1S\u0005\u0005\u0005c\u0013\tAA\tBEN$(/Y2u\rVt7\r^5p]F\"\"A!+\u0015\t\tM%q\u0017\u0005\b\u0003\u001f2\u0006\u0019\u0001B\u001d)\u0011\u0011YL!0\u0011\r\u0005E!1\u0004B\u001d\u0011%\u00119cVA\u0001\u0002\u0004\u0011\u0019jE\u0004Z\u0003\u001f\u0011\tMa2\u0011\t\u0005e\"1Y\u0005\u0005\u0005\u000b\fYDA\u0003BGR|'\u000f\u0005\u0003\u0002:\t%\u0017\u0002\u0002Bf\u0003w\u0011A\"Q2u_JdunZ4j]\u001e$\"Aa4\u0011\u0007\u0005%\u0011,\u0006\u0002\u0003TB!\u0011\u0011\u0002Bk\u0013\r\u00119n \u0002\b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013\u0001\u0005<fe\n|7/\u001a%fCJ$(-Z1u+\t\t\t/A\twKJ\u0014wn]3IK\u0006\u0014HOY3bi\u0002\nADZ5mi\u0016\u0014\u0018J\u001c;fe:\fGn\u00117vgR,'/T3nE\u0016\u00148/\u0006\u0002\u0003fBA\u0011\u0011\u0003Bt\u0005W\f\t/\u0003\u0003\u0003j\u0006M!!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tIA!<\n\u0007\t=xP\u0001\u0004NK6\u0014WM]\u0001\u001eM&dG/\u001a:J]R,'O\\1m\u00072,8\u000f^3s\u001b\u0016l'-\u001a:tA\u0005q1/Z9vK:\u001cWM\u0014:`I\u0015\fH\u0003\u0002B|\u0005{\u0004B!!\u0005\u0003z&!!1`A\n\u0005\u0011)f.\u001b;\t\u0013\u0005-'-!AA\u0002\u0005e\u0016!D:fY\u001aDU-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0004\u0004A\u00191QA\u0002\u000f\u0007\u0005%\u0001!A\bgC&dWO]3EKR,7\r^8s+\t\u0019Y\u0001\u0005\u0004\u0002.\r5\u00111K\u0005\u0005\u0007\u001f\tyCA\fGC&dWO]3EKR,7\r^8s%\u0016<\u0017n\u001d;ss\u0006\u0001b-Y5mkJ,G)\u001a;fGR|'\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0007/\u0001B!!\u0003\u0004\u001a%\u001911D@\u00037\rcWo\u001d;fe\"+\u0017M\u001d;cK\u0006$8+\u001a8eKJ\u001cF/\u0019;f\u0003%\u0019H/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0003x\u000e\u0005\u0002\"CAfQ\u0006\u0005\t\u0019AB\f\u0003\u0019\u0019H/\u0019;fA\u0005i\u0001.Z1si\n,\u0017\r\u001e+bg.,\"a!\u000b\u0011\t\u0005e21F\u0005\u0005\u0007[\tYDA\u0006DC:\u001cW\r\u001c7bE2,\u0017A\u00045fCJ$(-Z1u)\u0006\u001c8\u000eI\u0001\u000ei&\u001c7\u000eV5nKN$\u0018-\u001c9\u0002#QL7m\u001b+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0003x\u000e]\u0002\"CAf[\u0006\u0005\t\u0019AA0\u00039!\u0018nY6US6,7\u000f^1na\u0002\n\u0001\u0002\u001d:f'R\f'\u000f\u001e\u000b\u0003\u0005o\f\u0001\u0002]8tiN#x\u000e]\u0001\u0012Q\u0016\f'\u000f\u001e2fCR\u0014VmY3jm\u0016\u0014H\u0003BB#\u0007\u0017\u0002B!!\u000f\u0004H%!1\u0011JA\u001e\u00059\t5\r^8s'\u0016dWm\u0019;j_:Dqa!\u0014r\u0001\u0004\t\u0019&A\u0004bI\u0012\u0014Xm]:\u0002\u000fI,7-Z5wKV\u001111\u000b\t\u0005\u0007+\u001aYF\u0004\u0003\u0002:\r]\u0013\u0002BB-\u0003w\tQ!Q2u_JLAa!\u0018\u0004`\t9!+Z2fSZ,'\u0002BB-\u0003w\tA\"\u001b8ji&\fG.\u001b>j]\u001e\fa!Y2uSZ,\u0017\u0001B5oSR$BAa>\u0004j!911N;A\u0002\r5\u0014\u0001C:oCB\u001c\bn\u001c;\u0011\t\r=41\u0011\b\u0005\u0007c\u001ayH\u0004\u0003\u0004t\rud\u0002BB;\u0007wj!aa\u001e\u000b\t\re\u0014QD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\u0015\u0011\u0002BA\u0001\u0003\u0007I1a!!\u0000\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0019)ia\"\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\u0007\r\u0005u0A\u0005bI\u0012lU-\u001c2feR!!q_BG\u0011\u001d\u0019yI\u001ea\u0001\u0005W\f\u0011!\\\u0001\re\u0016lwN^3NK6\u0014WM\u001d\u000b\u0005\u0005o\u001c)\nC\u0004\u0004\u0010^\u0004\rAa;\u0002#Ut'/Z1dQ\u0006\u0014G.Z'f[\n,'\u000f\u0006\u0003\u0003x\u000em\u0005bBBHq\u0002\u0007!1^\u0001\u0010e\u0016\f7\r[1cY\u0016lU-\u001c2feR!!q_BQ\u0011\u001d\u0019y)\u001fa\u0001\u0005W\f\u0011\u0002[3beR\u0014W-\u0019;\u0002#\rDWmY6US\u000e\\\u0017J\u001c;feZ\fG.\u0001\u0007iK\u0006\u0014HOY3biJ\u001b\b\u000f\u0006\u0003\u0003x\u000e-\u0006bBBWy\u0002\u00071qV\u0001\te\u0016\u001c\bo\u001c8tKB\u00191Q\u0001\u0010\u0002+Q\u0014\u0018nZ4fe\u001aK'o\u001d;IK\u0006\u0014HOY3biR!!q_B[\u0011\u001d\ty% a\u0001\u0005s\u0001")
public class ClusterHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return new Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp() {
        return this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    object = BoxedUnit.UNIT;
                } else if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    this.$outer.heartbeatRsp(heartbeatRsp);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : object instanceof ExpectedFirstHeartbeat)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        block0: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) || this.state().contains(m.uniqueAddress()) || !BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block0;
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
        }
    }

    public void removeMember(Member m) {
        block2: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block2;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
            } else {
                this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            }
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.cluster().ClusterLogger().logWarning("Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, e.g. by running blocking tasks on the default dispatcher, CPU overload, or GC.", BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp())), BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.state().activeReceivers().apply((Object)from) || this.failureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.failureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.filterInternalClusterMembers = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    scala.Serializable {
        private final UniqueAddress from;

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.from();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            return true;
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress == null) {
                if (uniqueAddress2 != null) {
                    return false;
                }
            } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            return true;
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }
}

