/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.TestIds;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleasesActorHolder;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.api.internal.FixturesResource;
import com.xebialabs.xlrelease.db.ArchivingDbInitializer;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.rules.JcrTestInDirectoryRule;
import com.xebialabs.xlrelease.rules.LoginRule;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.python.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml"}, initializers={XlrWebApplicationInitializer.class})
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseIntegrationTest.class);
    private final boolean useCache;
    private List<String> cisForDeletion = Lists.newArrayList();
    @Autowired
    private ArchivingDbInitializer archivingDbInitializer;
    @Autowired
    public RepositoryService repositoryService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    private Teams teams;
    @Autowired
    private ReleasesActorHolder releasesActorHolder;
    public JcrTestInDirectoryRule directory;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected ReleaseActorService releaseActorService;
    @Autowired
    protected ActorSystemHolder actorSystemHolder;
    @Autowired
    protected ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private List<? extends ApiService> apiServices;

    @Autowired
    public void setApiServices(List<? extends ApiService> apiServices) {
        this.apiServices = apiServices;
    }

    public XLReleaseIntegrationTest() {
        this(false);
    }

    public XLReleaseIntegrationTest(boolean useCache) {
        this.useCache = useCache;
    }

    @Before
    public void before() {
        logger.debug("XLReleaseIntegrationTest 'before' started");
        XLReleasePermissions.init();
        try {
            new TestContextManager(((Object)((Object)this)).getClass()).prepareTestInstance((Object)this);
            this.directory = JcrTestInDirectoryRule.newDirectory(TestIds.RELEASES_DIR, this.repositoryService, this.useCache);
            this.directory.before();
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
        this.archivingDbInitializer.init();
        LoginRule.grantAdminPermissionTo((String)"admin", (PermissionEditor)this.permissionEditor, (RoleService)this.roleService);
        this.releasesActorHolder.awaitActorRef();
        XLReleaseServiceHolder.init((RepositoryService)((RepositoryService)this.applicationContext.getBean(RepositoryService.class)), this.apiServices);
        this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
        logger.debug("XLReleaseIntegrationTest 'before' finished");
    }

    @After
    public void tearDown() throws Exception {
        logger.debug("XLReleaseIntegrationTest 'after' started");
        this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
        this.archivingDbInitializer.dropAll();
        this.directory.after();
        this.cleanActivityLogs();
        this.deleteCis();
        this.verifyRepositoryClean();
        logger.debug("XLReleaseIntegrationTest 'after' finished");
    }

    private void cleanActivityLogs() {
        if (this.repositoryService.exists(ActivityLogs.ACTIVITY_LOGS_DIR)) {
            this.repositoryService.delete(new String[]{ActivityLogs.ACTIVITY_LOGS_DIR});
        }
    }

    private List<Release> findAllReleases() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setAncestor("Applications");
        searchParameters.setType(Type.valueOf(Release.class));
        List releasesAndTemplates = this.repositoryService.listEntities(searchParameters);
        searchParameters.addProperty("status", ReleaseStatus.TEMPLATE.name());
        List templates = this.repositoryService.listEntities(searchParameters);
        return releasesAndTemplates.stream().filter(r -> !templates.contains(r)).collect(Collectors.toList());
    }

    private void verifyRepositoryClean() {
        List<Release> cis = this.findAllReleases();
        if (cis.size() > 0) {
            throw new RuntimeException("Found " + cis.size() + " releases after the test has finished: " + Joiner.on((String)",").join(cis));
        }
    }

    private void deleteCis() {
        for (String id : this.cisForDeletion) {
            this.repositoryService.delete(new String[]{id});
        }
        this.cisForDeletion = Lists.newArrayList();
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }

    public void markForDeletion(ConfigurationItem item) {
        this.markForDeletion(item.getId());
    }

    public void markForDeletion(String ciId) {
        this.cisForDeletion.add(ciId);
    }

    protected void createCisAndSaveTeams(ConfigurationItem ... cis) {
        this.createCisAndSaveTeams(Arrays.asList(cis));
    }

    protected void createCisAndSaveTeams(Collection<ConfigurationItem> cis) {
        List cisWithoutTeams = cis.stream().filter(ci -> !ci.getType().instanceOf(Type.valueOf(Team.class))).collect(Collectors.toList());
        this.repositoryService.createCollection(cisWithoutTeams);
        FixturesResource.saveTeams(cis, (Teams)this.teams);
    }

    public String createRole(String roleName) {
        Role role = new Role(roleName);
        List allRoles = this.roleService.readRoleAssignments();
        allRoles.add(role);
        this.roleService.writeRoleAssignments(allRoles);
        return roleName;
    }
}

