/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.javadude.t2bus.Subscribe;

public class ExecutionConditionBuilder<S> {
    private final Runnable runnable;
    private static final long DEFAULT_TIMEOUT = 30000L;

    private ExecutionConditionBuilder(Runnable runnable) {
        this.runnable = runnable;
    }

    public static <S> ExecutionConditionBuilder<S> execute(Runnable runnable) {
        return new ExecutionConditionBuilder<S>(runnable);
    }

    public void until(String planItemId, List<S> statuses) throws InterruptedException, TimeoutException {
        this.until(planItemId, statuses, 30000L);
    }

    public void until(String planItemId, List<S> statuses, long timeout) throws InterruptedException, TimeoutException {
        PlanItemStatusExecutionCondition<S> condition = new PlanItemStatusExecutionCondition<S>(planItemId, statuses, timeout);
        EventBusHolder.register(condition);
        this.runnable.run();
        condition.await();
        EventBusHolder.deregister(condition);
    }

    static class PlanItemStatusExecutionCondition<S> {
        private String planItemId;
        private List<S> expectedStatuses;
        private long timeout;
        private CountDownLatch latch = new CountDownLatch(1);

        PlanItemStatusExecutionCondition(String planItemId, List<S> statuses, long timeout) {
            this.planItemId = planItemId;
            this.expectedStatuses = statuses;
            this.timeout = timeout;
        }

        public void await() throws InterruptedException, TimeoutException {
            if (!this.latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException(String.format("release %s did not reach expected status %s within %d milliseconds", this.planItemId, this.expectedStatuses, this.timeout));
            }
        }

        @Subscribe
        public void onEvent(CiBaseEvent event) {
            List cis = event.getCis();
            cis.stream().forEach(ci -> {
                Object ciStatus;
                if (ci.getId().equals(this.planItemId) && this.expectedStatuses.contains(ciStatus = ci.getProperty("status"))) {
                    this.latch.countDown();
                }
            });
        }
    }
}

