package com.xebialabs.xlrelease.rules;

import org.junit.rules.ExternalResource;

import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.repository.WorkDirFactory;

public class WorkDirRule extends ExternalResource {

    public void before() throws Throwable {
        WorkDirFactory workDirFactory = new WorkDirFactory(System.getProperty("java.io.tmpdir"));
        new WorkdirHolder(workDirFactory);

        WorkdirHolder.initWorkdir();
    }

    public void after() {
        if (WorkdirHolder.get() != null) {
            WorkdirHolder.get().delete();
            WorkdirHolder.clear();
        }
    }
}
