package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;

import com.xebialabs.xlrelease.views.UserAccount;

import static org.assertj.core.api.Assertions.assertThat;


public class UserAccountAssertion extends AbstractAssert<UserAccountAssertion, UserAccount> {
    public UserAccountAssertion(UserAccount actual) {
        super(actual, UserAccountAssertion.class);
    }

    public UserAccountAssertion hasUsername(String username) {
        assertThat(actual.getUsername()).isEqualTo(username);
        return myself;
    }

    public UserAccountAssertion isNotExternal() {
        assertThat(actual.isExternal()).isFalse();
        return myself;
    }

    public UserAccountAssertion isExternal() {
        assertThat(actual.isExternal()).isTrue();
        return myself;
    }

    public UserAccountAssertion hasNoEmail() {
        assertThat(actual.getEmail()).isNull();
        return myself;
    }

    public UserAccountAssertion hasNoProfile() {
        assertThat(actual.getProfileId()).isNull();
        return myself;
    }

    public UserAccountAssertion hasEmail(String email) {
        assertThat(actual.getEmail()).isEqualTo(email);
        return myself;
    }

    public UserAccountAssertion hasProfileId(String profileId) {
        assertThat(actual.getProfileId()).isEqualTo(profileId);
        return myself;
    }
}
