package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.views.Point;

public class PointAssertion extends AbstractAssert<PointAssertion, Point> {

    protected PointAssertion(Point actual) {
        super(actual, PointAssertion.class);
    }

    public PointAssertion hasName(String name) {
        isNotNull();
        Assertions.assertThat(actual.getName()).isEqualTo(name);
        return this;
    }

    public PointAssertion hasX(float x) {
        isNotNull();
        Assertions.assertThat(actual.getX()).isEqualTo(x);
        return this;
    }

    public PointAssertion hasY(float y) {
        isNotNull();
        Assertions.assertThat(actual.getY()).isEqualTo(y);
        return this;
    }

    public PointAssertion hasYGreaterThanZero() {
        isNotNull();
        Assertions.assertThat(actual.getY()).isGreaterThan(0);
        return this;
    }
}
