package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.*;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.views.Point;
import com.xebialabs.xlrelease.views.UserAccount;

/**
 * Brings our custom assertions into scope. Use this instead of the default FEST Assert class.
 */
public class XLReleaseAssertions extends Assertions {

    public static ActivityLogAssertion assertThat(ActivityLogs activityLogs) {
        return new ActivityLogAssertion(activityLogs);
    }

    public static ActivityLogEntryAssertion assertThat(ActivityLogEntry activityLogEntry) {
        return new ActivityLogEntryAssertion(activityLogEntry);
    }

    public static PhaseAssertion assertThat(Phase phase) {
        return new PhaseAssertion(phase);
    }

    public static PointAssertion assertThat(Point point) {
        return new PointAssertion(point);
    }

    public static ReleaseAssertion assertThat(Release release) {
        return new ReleaseAssertion(release);
    }

    public static TaskAssertion assertThat(Task task) {
        return new TaskAssertion(task);
    }

    public static DeployitTaskAssertion assertThat(DeployitTask task) {
        return new DeployitTaskAssertion(task);
    }

    public static ChangesAssertion assertThat(Changes actual) {
        return new ChangesAssertion(actual);
    }

    public static VariableReferenceAssertion assertThat(VariableReference actual) {
        return new VariableReferenceAssertion(actual);
    }

    public static VariableAssertion assertThat(Variable actual) {
        return new VariableAssertion(actual);
    }

    public static UserAccountAssertion assertThat(UserAccount actual) {
        return new UserAccountAssertion(actual);
    }

    public static TeamAssertion assertThat(Team actual) {
        return new TeamAssertion(actual);
    }

    public static ReleaseTriggerAssertion assertThat(ReleaseTrigger actual) {
        return new ReleaseTriggerAssertion(actual);
    }
}
