/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.TestIds;
import com.xebialabs.xlrelease.actors.ActorsInitializer;
import com.xebialabs.xlrelease.db.ArchivingDbInitializer;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.rules.JcrTestInDirectoryRule;
import com.xebialabs.xlrelease.rules.LoginRule;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.python.google.common.base.Joiner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml"})
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest {
    private final boolean useCache;
    private List<String> cisForDeletion = Lists.newArrayList();
    @Autowired
    private ArchivingDbInitializer archivingDbInitializer;
    @Autowired
    public RepositoryService repositoryService;
    @Autowired
    public JcrTemplate jcrTemplate;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ActorsInitializer actorsInitializer;
    public JcrTestInDirectoryRule directory;
    @Autowired
    protected ApplicationContext applicationContext;

    public XLReleaseIntegrationTest() {
        this(false);
    }

    public XLReleaseIntegrationTest(boolean useCache) {
        this.useCache = useCache;
    }

    @Before
    public void before() {
        try {
            new TestContextManager(this.getClass()).prepareTestInstance((Object)this);
            this.directory = JcrTestInDirectoryRule.newDirectory(TestIds.RELEASES_DIR, this.repositoryService, this.useCache);
            this.directory.before();
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
        new JcrTemplateHolder(this.jcrTemplate);
        this.archivingDbInitializer.init();
        LoginRule.grantAdminPermissionTo("admin", this.permissionEditor, this.roleService);
    }

    @After
    public void tearDown() throws Exception {
        this.archivingDbInitializer.dropAll();
        this.directory.after();
        this.cleanActivityLogs();
        this.deleteCis();
        this.verifyRepositoryClean();
    }

    private void cleanActivityLogs() {
        if (this.repositoryService.exists(ActivityLogs.ACTIVITY_LOGS_DIR)) {
            this.repositoryService.delete(new String[]{ActivityLogs.ACTIVITY_LOGS_DIR});
        }
    }

    private void verifyRepositoryClean() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setParent("Applications");
        searchParameters.setType(Type.valueOf(Release.class));
        List cis = this.repositoryService.listEntities(searchParameters);
        if (cis.size() > 0) {
            throw new RuntimeException("Found " + cis.size() + " releases after the test has finished: " + Joiner.on((String)",").join((Iterable)cis));
        }
        this.deleteOnTearDown(cis.toArray(new ConfigurationItem[cis.size()]));
        this.deleteCis();
    }

    private void deleteCis() {
        for (String id : this.cisForDeletion) {
            this.repositoryService.delete(new String[]{id});
        }
        this.cisForDeletion = Lists.newArrayList();
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }
}

