/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.repository.XlRepositoryInitializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.xml.sax.InputSource;
import scala.Option;

public class JackrabbitRepositoryBooter {
    private RepositoryImpl repository;
    private File homeDir = Files.createTempDir();
    private XlRepositoryConfig xlConfig;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Repository boot() throws RepositoryException {
        this.xlConfig = new JackrabbitInMemoryConfig();
        try (InputStream stream = this.xlConfig.jcrRepositoryConfig().getInputStream();){
            InputSource configurationInputSource = new InputSource(stream);
            RepositoryConfig repositoryConfig = RepositoryConfig.create((InputSource)configurationInputSource, (String)this.homeDir.getAbsolutePath());
            this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
            new XlRepositoryInitializer((Repository)this.repository, this.xlConfig).init();
            RepositoryImpl repositoryImpl = this.repository;
            return repositoryImpl;
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void shutdown() {
        this.repository.shutdown();
        try {
            GuavaFiles.deleteRecursively((File)this.homeDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    public XlRepositoryConfig getXlConfig() {
        return this.xlConfig;
    }

    private class JackrabbitInMemoryConfig
    implements XlRepositoryConfig {
        private JackrabbitInMemoryConfig() {
        }

        public RepositoryConfigurationSource jcrRepositoryConfig() {
            return new RepositoryConfigurationSource("jackrabbit/inmemory-repository.xml");
        }

        public String repositoryName() {
            return "xl-release";
        }

        public Version repositoryVersion() {
            return Version.valueOf((String)"xl-release", (String)"0.0.0");
        }

        public Option<String> repositoryId() {
            return Option.apply(null);
        }

        public Option<? extends Credentials> credentials() {
            return Option.apply((Object)new SimpleCredentials("admin", "admin".toCharArray()));
        }
    }
}

