package com.xebialabs.xlrelease.beans

import java.io.IOException
import java.nio.file.Files

import grizzled.slf4j.Logging
import org.apache.commons.io.FileUtils
import org.springframework.context.annotation.{Bean, Configuration}

class TempDirectory extends Logging {

  lazy val path = {
    val p = Files.createTempDirectory("test")
    logger.info(s"Creating temporary directory $p")
    p
  }

  def delete(): Unit = {
    logger.info(s"Deleting temporary directory $path")
    try {
      FileUtils.deleteDirectory(path.toFile)
    } catch {
      // On Windows, the derby DB can't be deleted :(
      case e: IOException => logger.warn(e.getMessage)
    }
  }

  def asJDBC: String = s"jdbc:derby:${path.toAbsolutePath}/db;create=true"
}


@Configuration
class TempDirectoryConfig {

  @Bean(name = Array("autoDestroyedTempDirectory"), destroyMethod = "delete")
  def autoDestroyedTempDirectory() = new TempDirectory
}