/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.xli.config;

import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.configuration.HttpConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class PluginProperties {
    private final String scheme;
    private final String host;
    private final int port;
    private final String contextPath;
    private final String assetsPath;
    private final String apiPath;
    private final String username;
    private final String password;
    private final String userRole;
    private final boolean acceptSelfSignedSSLs;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final Boolean verbose;

    public PluginProperties(HttpConnection httpConnection) {
        URL url = null;
        try {
            url = new URL(httpConnection.getUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.scheme = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.contextPath = this.getWithDefault(httpConnection, "contextPath", "/xli/");
        this.assetsPath = this.contextPath + this.getWithDefault(httpConnection, "assetsPath", "assets/");
        this.apiPath = this.contextPath + this.getWithDefault(httpConnection, "assetsPath", "api/");
        this.username = httpConnection.getUsername();
        this.password = PasswordEncrypter.getInstance().decrypt(httpConnection.getPassword());
        this.userRole = this.getWithDefault(httpConnection, "userRole", "user");
        this.acceptSelfSignedSSLs = httpConnection.hasProperty("acceptSelfSignedSSL") && (Boolean)httpConnection.getProperty("acceptSelfSignedSSL") != false;
        this.proxyHost = httpConnection.getProxyHost() == null || httpConnection.getProxyHost().trim().isEmpty() ? null : httpConnection.getProxyHost();
        this.proxyPort = httpConnection.getProxyPort() == null || httpConnection.getProxyPort().trim().isEmpty() ? null : Integer.valueOf(Integer.parseInt(httpConnection.getProxyPort()));
        this.proxyUsername = httpConnection.getProxyUsername() == null || httpConnection.getProxyUsername().trim().isEmpty() ? null : httpConnection.getProxyUsername();
        this.proxyPassword = httpConnection.getProxyPassword() == null || httpConnection.getProxyPassword().trim().isEmpty() ? null : PasswordEncrypter.getInstance().decrypt(httpConnection.getProxyPassword());
        this.verbose = httpConnection.hasProperty("verbose") ? (Boolean)httpConnection.getProperty("verbose") : Boolean.valueOf(false);
    }

    private String getWithDefault(HttpConnection httpConnection, String property, String defaultValue) {
        if (httpConnection.hasProperty(property) && httpConnection.getProperty(property) != null && !((String)httpConnection.getProperty(property)).trim().isEmpty()) {
            return ((String)httpConnection.getProperty(property)).trim();
        }
        return defaultValue;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getAssetsPath() {
        return this.assetsPath;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public boolean isAcceptSelfSignedSSLs() {
        return this.acceptSelfSignedSSLs;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String toString() {
        return "PluginProperties{scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", contextPath='" + this.contextPath + '\'' + ", assetsPath='" + this.assetsPath + '\'' + ", apiPath='" + this.apiPath + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", userRole='" + this.userRole + '\'' + ", acceptSelfSignedSSLs=" + this.acceptSelfSignedSSLs + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + ", proxyUsername='" + this.proxyUsername + '\'' + ", proxyPassword='" + this.proxyPassword + '\'' + ", verbose=" + this.verbose + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginProperties that = (PluginProperties)o;
        return this.port == that.port && this.acceptSelfSignedSSLs == that.acceptSelfSignedSSLs && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.contextPath, that.contextPath) && Objects.equals(this.assetsPath, that.assetsPath) && Objects.equals(this.apiPath, that.apiPath) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.userRole, that.userRole) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.verbose, that.verbose);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.contextPath, this.assetsPath, this.apiPath, this.username, this.password, this.userRole, this.acceptSelfSignedSSLs, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, this.verbose);
    }
}

