/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.xli.config;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.config.XlrConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginProperties {
    private final String scheme;
    private final String host;
    private final int port;
    private final String contextPath;
    private final String assetsPath;
    private final String apiPath;
    private final String username;
    private final String password;
    private final String userRole;
    private final boolean acceptSelfSignedSSLs;

    @Autowired
    public PluginProperties(XlrConfig config) {
        Config rootConfig = config.getRootConfig();
        this.scheme = rootConfig.getString("xl.plugin.xliUI.scheme");
        this.host = rootConfig.getString("xl.plugin.xliUI.host");
        this.port = rootConfig.getInt("xl.plugin.xliUI.port");
        this.contextPath = rootConfig.getString("xl.plugin.xliUI.contextPath");
        this.assetsPath = this.contextPath + rootConfig.getString("xl.plugin.xliUI.assetsPath");
        this.apiPath = this.contextPath + rootConfig.getString("xl.plugin.xliUI.apiPath");
        this.username = rootConfig.getString("xl.plugin.xliUI.username");
        this.password = PasswordEncrypter.getInstance().ensureDecrypted(rootConfig.getString("xl.plugin.xliUI.password"));
        this.userRole = rootConfig.getString("xl.plugin.xliUI.userRole");
        this.acceptSelfSignedSSLs = rootConfig.getBoolean("xl.plugin.xliUI.acceptSelfSignedSSLs");
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getAssetsPath() {
        return this.assetsPath;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public boolean isAcceptSelfSignedSSLs() {
        return this.acceptSelfSignedSSLs;
    }

    public String toString() {
        return "PluginProperties{scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", contextPath='" + this.contextPath + '\'' + ", assetsPath='" + this.assetsPath + '\'' + ", apiPath='" + this.apiPath + '\'' + ", username='" + this.username + '\'' + ", userRole='" + this.userRole + '\'' + ", acceptSelfSignedSSLs=" + this.acceptSelfSignedSSLs + '}';
    }
}

