/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlr.util;

import com.xebialabs.deployit.booter.local.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static final String XML_DECLARATION = "<?xml version=\"1.1\" encoding=\"UTF-8\"?>";
    private static final String TAG_TASK = "task";
    private static final String TAG_STEP = "step";
    private static final String TAG_LOG = "log";
    private static final String ATTR_CURRENT_STEP = "currentStep";
    private static final String ATTR_TOTAL_STEPS = "totalSteps";
    private static final String ATTR_FAILURES = "failures";

    public static Document asDocument(String xml) {
        xml = XmlUtil.prependXmlDeclaration(xml);
        Document doc = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            doc = XmlUtil.parse(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed closing stream or reader, reason: " + e.getMessage());
        }
        return doc;
    }

    private static Document parse(InputStreamReader reader) {
        InputSource source = new InputSource(reader);
        source.setEncoding(StandardCharsets.UTF_8.name());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(source);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Failed creating DocumentBuilder, reason: " + pce.getMessage());
        }
        catch (SAXException se) {
            throw new RuntimeException("Failed parsing XML, reason: " + se.getMessage());
        }
        catch (IOException ie) {
            throw new RuntimeException("Failed reading XML, reason: " + ie.getMessage());
        }
        return doc;
    }

    public static String prependXmlDeclaration(String xml) {
        String trimmed = StringUtils.trimLeadingWhitespace((String)xml);
        return trimmed.startsWith("<?xml ") ? trimmed : XML_DECLARATION + trimmed;
    }

    public static TaskAttributes getTaskAttributes(Document taskXml) {
        TaskAttributes attrs = new TaskAttributes();
        Element e = taskXml.getDocumentElement();
        if (e.getTagName().equals(TAG_TASK)) {
            attrs.currentStep = e.getAttribute(ATTR_CURRENT_STEP);
            attrs.totalSteps = e.getAttribute(ATTR_TOTAL_STEPS);
        }
        return attrs;
    }

    private static boolean isElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    private static boolean isText(Node node) {
        return node != null && node.getNodeType() == 3;
    }

    private static Element getChildElementByTag(Element parent, String tag) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element e;
            Node child = children.item(i);
            if (!XmlUtil.isElement(child) || !(e = (Element)child).getTagName().equals(tag)) continue;
            return e;
        }
        return null;
    }

    private static String getStepLogText(Element step) {
        Element log = XmlUtil.getChildElementByTag(step, TAG_LOG);
        if (log == null) {
            return null;
        }
        NodeList children = log.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!XmlUtil.isText(child)) continue;
            return child.getTextContent();
        }
        return null;
    }

    public static List<TaskStep> getTaskSteps(Document xml) {
        ArrayList<TaskStep> steps = new ArrayList<TaskStep>();
        NodeList nodes = xml.getElementsByTagName(TAG_STEP);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!XmlUtil.isElement(node)) continue;
            Element e = (Element)node;
            TaskStep step = new TaskStep();
            String failures = e.getAttribute(ATTR_FAILURES);
            if (failures != null && !failures.isEmpty()) {
                step.failures = Integer.parseInt(failures);
            }
            step.log = XmlUtil.getStepLogText(e);
            steps.add(step);
        }
        return steps;
    }

    public static class TaskStep {
        public int failures;
        public String log;

        public boolean hasLog() {
            return Strings.isNotBlank((String)this.log);
        }
    }

    public static class TaskAttributes {
        public String currentStep;
        public String totalSteps;
    }
}

