from xlrxldeploy import *
from xldeploy.domain.ConfigurationItem import ConfigurationItem
from com.xebialabs.deployit.util import PasswordEncrypter


def delete_ci(task, ci_id, env_id, server, throw_on_fail=False, username=None, password=None):
    if throw_on_fail and not check_ci_exist(task, server, ci_id):
        raise Exception(
            "CI with id [{}] does not exist or you do not have the correct permissions to read it.".format(ci_id))

    client = get_api_client(server, task, username=username, password=password)

    if env_id:
        env = client.repository.read(env_id)
        update = False
        if ci_id in env.members:
            env.members.remove(ci_id)
            update = True
        if ci_id in env.dictionaries:
            env.dictionaries.remove(ci_id)
            update = True
        if update:
            print env.to_dict()
            client.repository.update_ci(env)

    client.repository.delete(ci_id)


def get_ci_property(task, ci_id, prop_key, server):
    if not check_ci_exist(task, server, ci_id):
        raise Exception("CI with id [{}] does not exist or you do not have the correct permissions to read it.".format(ci_id))

    client = get_api_client(server, task)
    ci = client.repository.read(ci_id)
    ci_dict = ci.to_dict()
    ci_dict['name'] = ci_dict['id'].split('/')[-1]

    if not isinstance(ci_dict[prop_key], int) and not isinstance(ci_dict[prop_key], bool):
        if prop_key in ci_dict:
            prop_value = ci_dict[prop_key]
            if isinstance(prop_value, dict):
                for key, value in prop_value.items():
                    check_encrypted(value, prop_key)
            else:
                check_encrypted(prop_value, prop_key)
            return prop_value
        else:
            raise Exception("CI with id [{}] does not have a property with name [{}].".format(ci_id, prop_key))
    else:
        return ci_dict[prop_key]

def check_encrypted(value, prop_key):
    if PasswordEncrypter.getInstance().prefix() in value:
        raise Exception("Encrypted property [{}] cannot be fetched.".format(prop_key))


def update_ci(task, ci_id, prop_key, prop_value, server):
    if not check_ci_exist(task, server, ci_id):
        raise Exception(
            "CI with id [{}] does not exist or you do not have the correct permissions to read it.".format(ci_id))

    client = get_api_client(server, task)
    ci = client.repository.read(ci_id)

    ci_dict = ci.to_dict()
    # adds ci item in case is NOT present in the response (e.g response does not return empty CI's)
    if prop_key not in ci_dict:
        ci_dict.update({prop_key: prop_value})

    if isinstance(ci_dict[prop_key], list) or isinstance(ci_dict[prop_key], dict):
        ci_dict[prop_key] = eval(prop_value)
    else:
        ci_dict[prop_key] = prop_value

    client.repository.update_ci(ConfigurationItem(ci_dict['id'], ci_dict['type'], ci_dict.copy()))


def create_ci(task, ci_type, ci_id, ci_xml, server, username=None, password=None):
    ci_xml = ci_xml if ci_xml else ''

    xml = '<' + ci_type + ' id="' + ci_id + '">' + ci_xml + '</' + ci_type + '>'
    path = "/repository/ci/{}".format(ci_id)

    xld_config = get_client_config(server, task, username=username, password=password)
    proxies = None
    if xld_config.proxy_host and xld_config.proxy_port:
        proxies = get_proxies(xld_config)
    response = requests.post(get_xldeploy_url(xld_config, path=path), auth=(xld_config.username, xld_config.password),
                             headers=get_xml_headers(), proxies=proxies, verify=xld_config.verify_ssl, data=xml)

    check_response(response, "Failed to create ci [{}]. Server return [{}], with content [{}]".format(ci_id,
                                                                                                      response.status_code,
                                                                                                      response.text))

    print "Created ci [{}] and received response [{}]".format(ci_id, response.text)


def add_ci_to_environment(task, env_id, ci_type, ci_id, server):
    if not check_ci_exist(task, server, env_id):
        raise Exception(
            "CI with id {} does not exist or you do not have the correct permissions to read it.".format(env_id))

    client = get_api_client(server, task)
    env_ci = client.repository.read(env_id).to_dict()

    if ci_type == "udm.Dictionary":
        env_ci["dictionaries"].append(ci_id)
    else:
        env_ci["members"].append(ci_id)

    client.repository.update_ci(ConfigurationItem(env_ci['id'], env_ci['type'], env_ci.copy()))


def read_ci(task, ci_id, accept, server, throw_on_fail=False):
    if throw_on_fail and not check_ci_exist(task, server, ci_id):
        raise Exception(
            "CI with id {} does not exist or you do not have the correct permissions to read it.".format(ci_id))

    path = "/repository/ci/{}".format(ci_id)
    headers = {'Accept': 'application/{}'.format(accept), 'Content-Type': 'application/{}'.format(accept)}
    xld_config = get_client_config(server, task)
    proxies = None
    if xld_config.proxy_host and xld_config.proxy_port:
        proxies = get_proxies(xld_config)
    response = requests.get(get_xldeploy_url(xld_config, path=path), auth=(xld_config.username, xld_config.password),
                            headers=headers, proxies=proxies, verify=xld_config.verify_ssl)

    return response.text


def import_package(task, server,url, username, password):
    client = get_api_client(server, task)
    client.package.fetch2(url=url, username=username, password=password)


def get_download_uuid(deployment_package, server, task):
    xld_config = get_client_config(server, task)
    path = "/export/deploymentpackage/%s" % deployment_package
    proxies = None
    if xld_config.proxy_host and xld_config.proxy_port:
        proxies = get_proxies(xld_config)
    response = requests.get(get_xldeploy_url(xld_config, path=path), auth=(xld_config.username, xld_config.password),
                            headers=get_xml_headers(), proxies=proxies, verify=xld_config.verify_ssl)

    check_response(response, "Failed to get download uuid for package [{}]. Server return [{}], with content [{}]"
                   .format(deployment_package, response.status_code, response.text))
    return response.text


def check_ci_exist(task, server, path, username=None, password=None):
    client = get_api_client(server, task, username=username, password=password)
    return bool(client.repository.exists(path))


def check_response(response, message):
    if not 199 < response.status_code < 399:
        raise Exception(message)
