/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _xlDeployTaskDetailsController = __webpack_require__(2);

var _xlDeployTaskDetailsController2 = _interopRequireDefault(_xlDeployTaskDetailsController);

var _xlDeployTile = __webpack_require__(3);

var _xlDeployTile2 = _interopRequireDefault(_xlDeployTile);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _module = angular.module('xlrelease.xldeploy', []);

_xlDeployTaskDetailsController2.default.$inject = ['$scope', 'Backend', 'TasksService', 'Ids'];
_xlDeployTile2.default.$inject = ['$scope', 'ReleasesService', 'XlrTileHelper', 'ConfigurationInstances'];

_module.controller('xlrelease.xldeploy.XLDeployTaskDetailsController', _xlDeployTaskDetailsController2.default);
_module.controller('xlrelease.xldeploy.XLDeployTileController', _xlDeployTile2.default);

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(0);

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var XLDeployTaskDetailsController = function () {
    function XLDeployTaskDetailsController($scope, Backend, TasksService, Ids) {
        _classCallCheck(this, XLDeployTaskDetailsController);

        this._$scope = $scope;

        this._Backend = Backend;
        this._TasksService = TasksService;
        this._Ids = Ids;

        this._xldPackages = [];
        this._xldEnvironments = [];
        this._xldDeployeds = [];
    }

    _createClass(XLDeployTaskDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            this._ConfigurationInstances = this._$scope.ConfigurationInstances;

            var task = this._$scope.task;
            if (!this._TasksService.isTaskInProgress(task) && !this._TasksService.isTaskReadOnly(task)) {
                this._loadXldAutocompleteList(task);
            }
        }
    }, {
        key: '_loadXldAutocompleteList',
        value: function _loadXldAutocompleteList(task) {
            var _this = this;

            this._xldPackages.length = 0;
            this._xldEnvironments.length = 0;
            this._xldDeployeds.length = 0;

            if (task.inputProperties.server) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId };
                if (task.scriptDefinitionType == 'xldeploy.Undeploy') {
                    this._Backend.get('api/extension/deployed', { params: params }).then(function (response) {
                        return _this._xldDeployeds = response.data.entity;
                    });
                } else if (task.scriptDefinitionType == 'xldeploy.Deploy') {
                    this._Backend.get('api/extension/packages', { params: params }).then(function (response) {
                        return _this._xldPackages = response.data.entity;
                    });
                    this._Backend.get('api/extension/environments', { params: params }).then(function (response) {
                        return _this._xldEnvironments = response.data.entity;
                    });
                }
            }
        }
    }, {
        key: 'areTaskPropertiesReadonlyOrLocked',
        get: function get() {
            return this._TasksService.areTaskPropertiesReadonly(this._$scope.release, this._$scope.task) || this._TasksService.isLocked(this._$scope.task);
        }
    }, {
        key: 'loadXldAutocompleteList',
        get: function get() {
            var _this2 = this;

            return function (task) {
                return _this2._loadXldAutocompleteList(task);
            };
        }
    }, {
        key: 'xldPackages',
        get: function get() {
            return this._xldPackages;
        }
    }, {
        key: 'xldDeployeds',
        get: function get() {
            return this._xldDeployeds;
        }
    }, {
        key: 'xldEnvironments',
        get: function get() {
            return this._xldEnvironments;
        }
    }, {
        key: 'configurationInstances',
        get: function get() {
            return this._ConfigurationInstances;
        }
    }, {
        key: 'properties',
        get: function get() {
            return XLDeployTaskDetailsController._mapPropertyDefinitions(this._$scope.scriptDefinition);
        }
    }], [{
        key: '_mapPropertyDefinitions',
        value: function _mapPropertyDefinitions(taskDefinition) {
            if (!taskDefinition) {
                return {};
            }
            return taskDefinition.outputProperties.concat(taskDefinition.inputProperties).reduce(function (propertiesMap, property) {
                propertiesMap[property.name] = property;
                return propertiesMap;
            }, {});
        }
    }]);

    return XLDeployTaskDetailsController;
}();

exports.default = XLDeployTaskDetailsController;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var XLDeployTileController = function () {
    function XLDeployTileController($scope, ReleasesService, XlrTileHelper, ConfigurationInstances) {
        _classCallCheck(this, XLDeployTileController);

        this._ConfigurationInstances = ConfigurationInstances;
        this._ReleasesService = ReleasesService;
        this._XlrTileHelper = XlrTileHelper;

        if ($scope.xlrDashboard) {
            // summary page
            this._release = $scope.xlrDashboard.release;
        } else {
            // details page
            this._release = $scope.xlrTileDetailsCtrl.release;
        }
    }

    _createClass(XLDeployTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this._loadXldServersAndSetupData();
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this._ConfigurationInstances.reset();
        }
    }, {
        key: '_loadXldServersAndSetupData',
        value: function _loadXldServersAndSetupData() {
            var _this = this;

            this._ConfigurationInstances.load().then(function () {
                var xldServers = _this._ConfigurationInstances.getInstancesByType('xldeploy.XLDeployServer');

                _this._allXLDeployTasks = _this._getAllXLDeployTasks(_this._release, xldServers);
                _this._counts = _this._XlrTileHelper.countTasksByStatus(_this._allXLDeployTasks);
                _this._totalCount = _this._allXLDeployTasks.length;
                _this._gridOptions = _this._getGridOptions(_this._allXLDeployTasks);

                _this._chartOptions = _this._XlrTileHelper.getChartOptions({
                    label: 'Deployment',
                    total: _this._totalCount
                });
            });
        }
    }, {
        key: '_getAllXLDeployTasks',
        value: function _getAllXLDeployTasks(release, xldServers) {
            var _this2 = this;

            return _(this._ReleasesService.getLeafTasks(release)).filter({ scriptDefinitionType: 'xldeploy.Deploy' }).map(function (task) {
                return {
                    taskName: task.title,
                    taskId: task.outputProperties.xlDeployTaskId ? task.outputProperties.xlDeployTaskId.value : undefined,
                    taskPackage: task.inputProperties.deploymentPackage,
                    taskEnvironment: task.inputProperties.deploymentEnvironment,
                    taskStatus: task.status,
                    taskStatusCategory: _this2._XlrTileHelper.getCategoryByTaskStatus(task.status),
                    xldUrl: XLDeployTileController._getXldUrl(xldServers, task.inputProperties.server)
                };
            }).value();
        }
    }, {
        key: '_getGridOptions',
        value: function _getGridOptions(allXLDeployTasks) {
            var columnDefs = [{
                displayName: "Task",
                field: "taskName",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-name-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '30%'
            }, {
                displayName: "Package",
                field: "taskPackage",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Environment",
                field: "taskEnvironment",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Status",
                field: "taskStatusCategory",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-status-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '10%'
            }, {
                displayName: "XL Deploy task ID",
                field: "taskId",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-task-id-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '20%'
            }];
            return this._XlrTileHelper.getGridOptions(allXLDeployTasks, columnDefs);
        }
    }, {
        key: 'release',
        get: function get() {
            return this._release;
        }
    }, {
        key: 'counts',
        get: function get() {
            return this._counts;
        }
    }, {
        key: 'totalCount',
        get: function get() {
            return this._totalCount;
        }
    }, {
        key: 'gridOptions',
        get: function get() {
            return this._gridOptions;
        }
    }, {
        key: 'chartOptions',
        get: function get() {
            return this._chartOptions;
        }
    }], [{
        key: '_getXldUrl',
        value: function _getXldUrl(xldServers, serverId) {
            var server = _.find(xldServers, { 'id': serverId });
            return server ? server.properties.url : null;
        }
    }]);

    return XLDeployTileController;
}();

exports.default = XLDeployTileController;

/***/ })
/******/ ]);