from xml.etree import ElementTree as ET
import requests


class ControlTaskRunner(object):

    def __init__(self, config):
        self.config = config

    def execute_control_task(self, control_task_name, target_ci_id, parameters=None):
        from xlrxldeploy import get_xldeploy_url
        from xlrxldeploy import get_proxies
        from xlrxldeploy import get_xml_headers
        prepare_control_task_url = "/control/prepare/%s/%s" % (control_task_name, target_ci_id)

        prepare_response = requests.get(get_xldeploy_url(self.config, prepare_control_task_url), auth=(self.config.username, self.config.password), headers=get_xml_headers(), proxies=get_proxies(self.config), verify=self.config.verify_ssl)
        control_obj = prepare_response.text
        root = ET.fromstring(control_obj)
        parameter_type_id = self.get_parameter_type_name(root)
        if parameter_type_id:
            parameter_names = self.get_parameter_names(parameter_type_id)
            for parameterName in parameter_names:
                self.add_parameter(root, parameter_type_id, parameterName, parameters)

        invoke_response = requests.post(get_xldeploy_url(self.config, '/control'), auth=(self.config.username, self.config.password), headers=get_xml_headers(), proxies=get_proxies(self.config), verify=self.config.verify_ssl, data= ET.tostring(root))
        return  invoke_response.text

    def get_parameter_names(self, parameter_type_id):
        from xlrxldeploy import get_xldeploy_url
        from xlrxldeploy import get_proxies
        from xlrxldeploy import get_xml_headers
        metadata_url = "/metadata/type/%s" % parameter_type_id
        metadata_response = requests.get(get_xldeploy_url(self.config, metadata_url), auth=(self.config.username, self.config.password), headers=get_xml_headers(), proxies=get_proxies(self.config), verify=self.config.verify_ssl)
        root = ET.fromstring(metadata_response.text)
        params = root.find("property-descriptors")
        if params:
            return [param.get("name") for param in params]
        else:
            return []

    @staticmethod
    def add_parameter(root, parameter_type_id, parameter_name, parameters):
        params = root.find("parameters")
        if params and parameters:
            for child in params:
                if child.tag == parameter_type_id:
                    param = ET.SubElement(child, parameter_name)
                    param.text = str(parameters[parameter_name])

    @staticmethod
    def get_parameter_type_name(root):
        params = root.find("parameters")
        if params:
            for child in params:
                return child.tag