import ast
from xml.etree import ElementTree as ET
import requests


def add_parameter(root, parameter_type_id, parameter_name, parameters):
    params = root.find("parameters")
    if params and parameters:
        property_dict = dict(ast.literal_eval(parameters))
        for child in params:
            if child.tag == parameter_type_id:
                param = ET.SubElement(child, parameter_name)
                param.text = str(property_dict[parameter_name])

def get_parameter_type_name(root):
    params = root.find("parameters")
    if params:
        for child in params:
            return child.tag

class ControlTaskRunner(object):

    def __init__(self, config):
        self.config = config

    def prepare_control_task(self, control_task_name, target_ci_id, parameters=None):
        from xlrxldeploy import get_xldeploy_url
        from xlrxldeploy import  get_xml_headers
        prepare_control_task_url = "/control/prepare/%s/%s" % (control_task_name, target_ci_id)

        proxies = None
        if self.config.proxy_host and self.config.proxy_port:
            from xlrxldeploy import get_proxies
            proxies = get_proxies(self.config)

        prepare_response = requests.get(get_xldeploy_url(self.config, prepare_control_task_url), auth=(self.config.username, self.config.password), headers=get_xml_headers(), proxies=proxies, verify=self.config.verify_ssl)
        control_obj = prepare_response.text
        root = ET.fromstring(control_obj)
        parameter_type_id = get_parameter_type_name(root)
        if parameter_type_id:
            parameter_names = self.get_parameter_names(parameter_type_id)
            for parameterName in parameter_names:
                add_parameter(root, parameter_type_id, parameterName, parameters)

        invoke_response = requests.post(get_xldeploy_url(self.config, '/control'), auth=(self.config.username, self.config.password), headers=get_xml_headers(), proxies=proxies, verify=self.config.verify_ssl, data= ET.tostring(root))
        return  invoke_response.text
