from xlrxldeploy import *


def get_tags_of_ci(task):
    ci =  get_task_property(task, "xldCI")
    check_ci_exist(task, ci)
    client = get_api_client(get_task_property(task, "server"), task)
    return client.repository.read(ci).to_dict() ['tags']


def add_tag_to_ci(task):
    ci = get_task_property(task, "xldCI")
    check_ci_exist(task, ci)
    client = get_api_client(get_task_property(task, "server"), task)
    ci = client.repository.read(ci)
    tags = []
    if ci.has_property("tags"):
        tags = ci.tags
    tags.append(get_task_property(task, "xldNewTag"))
    ci.tags = tags
    client.repository.update_ci(ci)
    return tags


def set_tags_to_ci(task):
    ci = get_task_property(task, "xldCI")
    check_ci_exist(task, ci)
    client = get_api_client(get_task_property(task, "server"), task)
    ci = client.repository.read(ci)
    tags = []
    for tag in get_task_property(task, "xldNewTags"):
        tags.append(tag)
    ci.tags = tags
    client.repository.update_ci(ci)
    return ci.tags


def get_task_property(task, property):
    return task.getPythonScript().getProperty(property)
