from xlrxldeploy import get_api_client
from xlrxldeploy import check_ci_exist
from xldeploy.domain.ConfigurationItem import ConfigurationItem


def create_folders(task):
    client = get_api_client(task.getPythonScript().getProperty("server"), task)
    folders = task.getPythonScript().getProperty("folderTree").split("/")
    folder_to_create = task.getPythonScript().getProperty("folderType")
    for folder in folders:
        folder_to_create += "/" + folder
        if check_ci_exist(task, folder_to_create):
            print "Folder [%s] already exists.\n" % folder_to_create
        else:
            client.repository.create_ci(ConfigurationItem(folder_to_create, "core.Directory"))
            print "Created folder [%s].\n" % folder_to_create
