from com.xebialabs.xlrelease.status.webhook.events import UpdateStatusEvent, StateMetadata, VersionState
from java.util import ArrayList, Locale
from java.text import SimpleDateFormat

def map_application_deployment_package_states(response):
    data = ArrayList()
    for appStatus in response:
        data.add(map_application_deployment_package_state(appStatus))
    return data


def map_application_deployment_package_state(appStatus):
    state = appStatus["state"]
    deployment = map_deployment_package_state(state)
    return UpdateStatusEvent(appStatus["applicationName"], appStatus["applicationUid"], appStatus["applicationPath"], map_status_group(state["deploymentStatus"]), deployment)


def map_status_group(status):
    if status == 'DONE':
        return 'success'
    elif status == 'FAILED' or status == 'ABORTED' or status == 'CANCELLED' or status == 'STOPPED':
        return 'failed'
    else:
        return 'in-progress'

def map_deployment_package_state(state):
    version = state["versionTag"]
    lastChangeTime = state["lastChangeTime"]
    sdf = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.US)
    changeTime = None if lastChangeTime is None else sdf.parse(lastChangeTime)
    return StateMetadata(
        state["destination"],
        state["destinationUid"],
        None,
        map_version_tag(version),
        state["deploymentStatus"],
        state["deploymentType"],
        state["user"],
        changeTime
    )


def map_version_tag(version):
    return VersionState(version["label"], None)
